/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.CAstCallGraphUtil;
import com.ibm.wala.cast.ipa.callgraph.StandardFunctionTargetSelector;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptEntryPoints;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.loader.JavaScriptLoaderFactory;
import com.ibm.wala.cast.js.translator.JSAstTranslator;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.rewrite.CAstRewriterFactory;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.classLoader.SourceURLModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.ClassTargetSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyClassTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSCallGraphUtil
extends CAstCallGraphUtil {
    private static final boolean DEBUG = false;
    public static JavaScriptTranslatorFactory translatorFactory;

    public static void setTranslatorFactory(JavaScriptTranslatorFactory translatorFactory) {
        JSCallGraphUtil.translatorFactory = translatorFactory;
    }

    public static JavaScriptTranslatorFactory getTranslatorFactory() {
        return translatorFactory;
    }

    public static JSAnalysisOptions makeOptions(AnalysisScope scope, IClassHierarchy cha, Iterable<Entrypoint> roots) {
        JSAnalysisOptions options = new JSAnalysisOptions(scope, roots);
        options.setSelector((MethodTargetSelector)new ClassHierarchyMethodTargetSelector(cha));
        options.setSelector((ClassTargetSelector)new ClassHierarchyClassTargetSelector(cha));
        options.setSelector((MethodTargetSelector)new StandardFunctionTargetSelector(cha, options.getMethodTargetSelector()));
        options.setUseConstantSpecificKeys(true);
        options.setUseStacksForLexicalScoping(true);
        return options;
    }

    public static JavaScriptLoaderFactory makeLoaders(CAstRewriterFactory<?, ?> preprocessor) {
        if (translatorFactory == null) {
            throw new IllegalStateException("com.ibm.wala.cast.js.ipa.callgraph.Util.setTranslatorFactory() must be invoked before makeLoaders()");
        }
        return new JavaScriptLoaderFactory(translatorFactory, preprocessor);
    }

    public static JavaScriptLoaderFactory makeLoaders() {
        return JSCallGraphUtil.makeLoaders(null);
    }

    public static IClassHierarchy makeHierarchyForScripts(String ... scriptFiles) throws ClassHierarchyException {
        JavaScriptLoaderFactory loaders = JSCallGraphUtil.makeLoaders();
        AnalysisScope scope = CAstCallGraphUtil.makeScope((String[])scriptFiles, (SingleClassLoaderFactory)loaders, (Language)JavaScriptLoader.JS);
        return JSCallGraphUtil.makeHierarchy(scope, (ClassLoaderFactory)loaders);
    }

    public static IClassHierarchy makeHierarchy(AnalysisScope scope, ClassLoaderFactory loaders) throws ClassHierarchyException {
        return ClassHierarchyFactory.make((AnalysisScope)scope, (ClassLoaderFactory)loaders, (Language)JavaScriptLoader.JS);
    }

    public static JavaScriptEntryPoints makeScriptRoots(IClassHierarchy cha) {
        return new JavaScriptEntryPoints(cha, cha.getLoader(JavaScriptTypes.jsLoader));
    }

    public static Collection<CGNode> getNodes(CallGraph CG, String funName) {
        boolean suffix = funName.startsWith("suffix:");
        if (suffix) {
            HashSet<CGNode> nodes = new HashSet<CGNode>();
            String tail = funName.substring(7);
            for (CGNode n : CG) {
                if (!n.getMethod().getReference().getDeclaringClass().getName().toString().endsWith(tail)) continue;
                nodes.add(n);
            }
            return nodes;
        }
        MethodReference MR = JSCallGraphUtil.getMethodReference(funName);
        return CG.getNodes(MR);
    }

    public static MethodReference getMethodReference(String funName) {
        MethodReference MR;
        boolean ctor = funName.startsWith("ctor:");
        if (ctor) {
            TypeReference TR = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)('L' + funName.substring(5))));
            MR = JavaScriptMethods.makeCtorReference(TR);
        } else {
            TypeReference TR = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)('L' + funName)));
            MR = AstMethodReference.fnReference((TypeReference)TR);
        }
        return MR;
    }

    public static Set<String> loadAdditionalFile(IClassHierarchy cha, JavaScriptLoader cl, URL url) throws IOException {
        return JSCallGraphUtil.loadAdditionalFile(cha, cl, (ModuleEntry)new SourceURLModule(url));
    }

    public static Set<String> loadAdditionalFile(IClassHierarchy cha, JavaScriptLoader cl, ModuleEntry M) throws IOException {
        try {
            TranslatorToCAst toCAst = JSCallGraphUtil.getTranslatorFactory().make((CAst)new CAstImpl(), M);
            final HashSet<String> names = new HashSet<String>();
            JSAstTranslator toIR = new JSAstTranslator(cl){

                @Override
                protected void defineFunction(CAstEntity N, AstTranslator.WalkContext definingContext, AbstractCFG<SSAInstruction, ? extends IBasicBlock<SSAInstruction>> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation LI, AstMethod.DebuggingInformation debugInfo) {
                    String fnName = 'L' + this.composeEntityName(definingContext, N);
                    names.add(fnName);
                    super.defineFunction(N, definingContext, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, LI, debugInfo);
                }

                protected void leaveFunctionStmt(CAstNode n, AstTranslator.WalkContext c, CAstVisitor<AstTranslator.WalkContext> visitor) {
                    CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
                    AstTranslator.Scope cs = c.currentScope();
                    if (!cs.contains(fn.getName()) || cs.lookup(fn.getName()).getDefiningScope().getEntity().getKind() == 2) {
                        int result = this.processFunctionExpr(n, c);
                        this.assignValue(n, c, cs.lookup(fn.getName()), fn.getName(), result);
                    } else {
                        super.leaveFunctionStmt(n, c, visitor);
                    }
                }
            };
            try {
                CAstEntity tree = toCAst.translateToCAst();
                toIR.translate(tree, M);
                for (String name : names) {
                    IClass fcls = cl.lookupClass(name, cha);
                    cha.addClass(fcls);
                }
                return names;
            }
            catch (TranslatorToCAst.Error e) {
                return Collections.emptySet();
            }
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    public static String simulateToStringForPropertyNames(Object v) {
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof Double) {
            String result = v.toString();
            if ((double)Math.round((Double)v) == (Double)v) {
                result = Long.toString(Math.round((Double)v));
            }
            return result;
        }
        if (v instanceof Boolean) {
            if (((Boolean)v).booleanValue()) {
                return "true";
            }
            return "false";
        }
        return null;
    }

    public static Module getPrologueFile(String name) {
        return new Bootstrap(name, JSCallGraphUtil.class.getClassLoader().getResourceAsStream(name), JSCallGraphUtil.class.getClassLoader().getResource(name));
    }

    public static class Bootstrap
    implements SourceModule {
        private String name;
        private InputStream stream;
        private final URL url;

        public Bootstrap(String name, InputStream stream, URL url) {
            this.name = name;
            this.stream = stream;
            this.url = url;
        }

        public Iterator<? extends ModuleEntry> getEntries() {
            return new NonNullSingletonIterator((Object)this);
        }

        public boolean isClassFile() {
            return false;
        }

        public boolean isSourceFile() {
            return true;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        public boolean isModuleFile() {
            return false;
        }

        public Module asModule() {
            return this;
        }

        public String getClassName() {
            return this.getName();
        }

        public Module getContainer() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public Reader getInputReader() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

