/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ipa.callgraph.JSSSAPropagationCallGraphBuilder;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;

public class LoadFileTargetSelector
implements MethodTargetSelector {
    private final MethodTargetSelector base;
    private final JSSSAPropagationCallGraphBuilder builder;
    private final TypeReference loadFileRef = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)"Lprologue.js/loadFile"));
    private final MethodReference loadFileFunRef = AstMethodReference.fnReference((TypeReference)this.loadFileRef);
    private final HashSet<URL> loadedFiles = HashSetFactory.make();

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        IMethod target = this.base.getCalleeTarget(caller, site, receiver);
        if (target != null && target.getReference().equals((Object)this.loadFileFunRef)) {
            HashSet<String> names = new HashSet<String>();
            SSAInstruction call = caller.getIR().getInstructions()[caller.getIR().getCallInstructionIndices(site).intIterator().next()];
            if (call.getNumberOfUses() > 1) {
                LocalPointerKey fileNameV = new LocalPointerKey(caller, call.getUse(1));
                OrdinalSet ptrs = this.builder.getPointerAnalysis().getPointsToSet((PointerKey)fileNameV);
                for (InstanceKey k : ptrs) {
                    Object v;
                    if (!(k instanceof ConstantKey) || !((v = ((ConstantKey)k).getValue()) instanceof String)) continue;
                    names.add((String)v);
                }
                if (names.size() == 1) {
                    String str = (String)names.iterator().next();
                    try {
                        JavaScriptLoader cl = (JavaScriptLoader)this.builder.getClassHierarchy().getLoader(JavaScriptTypes.jsLoader);
                        URL url = new URL(this.builder.getBaseURL(), str);
                        if (!this.loadedFiles.contains(url)) {
                            InputStream inputStream = url.openConnection().getInputStream();
                            Throwable throwable = null;
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            JSCallGraphUtil.loadAdditionalFile(this.builder.getClassHierarchy(), cl, url);
                            this.loadedFiles.add(url);
                            IClass script = this.builder.getClassHierarchy().lookupClass(TypeReference.findOrCreate((ClassLoaderReference)cl.getReference(), (String)('L' + url.getFile())));
                            return script.getMethod(AstMethodReference.fnSelector);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
        return target;
    }

    public LoadFileTargetSelector(MethodTargetSelector base, JSSSAPropagationCallGraphBuilder builder) {
        this.base = base;
        this.builder = builder;
    }
}

