/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.cast.ipa.callgraph.ScopeMappingInstanceKeys;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class RecursionCheckContextSelector
implements ContextSelector {
    private final ContextSelector base;
    private static final int MAX_INTERESTING_PARAM = 5;

    public RecursionCheckContextSelector(ContextSelector base) {
        this.base = base;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
        assert (!RecursionCheckContextSelector.recursiveContext(baseContext, callee));
        return baseContext;
    }

    private static boolean recursiveContext(Context baseContext, IMethod callee) {
        if (!RecursionCheckContextSelector.recursionPossible(callee)) {
            return false;
        }
        LinkedList<Pair<Context, Collection<IMethod>>> worklist = new LinkedList<Pair<Context, Collection<IMethod>>>();
        worklist.push(Pair.make((Object)baseContext, Collections.singleton(callee)));
        while (!worklist.isEmpty()) {
            Pair p = (Pair)worklist.removeFirst();
            Context curContext = (Context)p.fst;
            Collection curEncountered = (Collection)p.snd;
            CGNode callerNode = (CGNode)curContext.get(ContextKey.CALLER);
            if (callerNode != null && !RecursionCheckContextSelector.updateForNode(baseContext, curEncountered, worklist, callerNode)) {
                System.err.println("callee " + callee);
                return true;
            }
            for (int i = 0; i < 5; ++i) {
                CGNode node;
                FilteredPointerKey.SingleInstanceFilter filter = (FilteredPointerKey.SingleInstanceFilter)curContext.get(ContextKey.PARAMETERS[i]);
                if (filter == null) continue;
                InstanceKey ik = filter.getInstance();
                if (ik instanceof ScopeMappingInstanceKeys.ScopeMappingInstanceKey) {
                    ik = ((ScopeMappingInstanceKeys.ScopeMappingInstanceKey)ik).getBase();
                }
                if (!(ik instanceof InstanceKeyWithNode) || RecursionCheckContextSelector.updateForNode(baseContext, curEncountered, worklist, node = ((InstanceKeyWithNode)ik).getNode())) continue;
                System.err.println("callee " + callee);
                return true;
            }
        }
        return false;
    }

    private static boolean updateForNode(Context baseContext, Collection<IMethod> curEncountered, LinkedList<Pair<Context, Collection<IMethod>>> worklist, CGNode callerNode) {
        IMethod method = callerNode.getMethod();
        if (!RecursionCheckContextSelector.recursionPossible(method)) {
            assert (!curEncountered.contains(method));
            return true;
        }
        if (curEncountered.contains(method)) {
            System.err.println("recursion in context on method " + method);
            System.err.println("encountered methods: ");
            for (IMethod m : curEncountered) {
                System.err.println("  " + m);
            }
            System.err.println("context " + baseContext);
            return false;
        }
        ArrayList<IMethod> newEncountered = new ArrayList<IMethod>(curEncountered);
        newEncountered.add(method);
        worklist.add((Pair<Context, Collection<IMethod>>)Pair.make((Object)callerNode.getContext(), newEncountered));
        return true;
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        return this.base.getRelevantParameters(caller, site);
    }

    private static boolean recursionPossible(IMethod m) {
        TypeReference declaringClass;
        return !m.getReference().getName().equals((Object)JavaScriptMethods.ctorAtom) || !(declaringClass = m.getReference().getDeclaringClass()).equals((Object)JavaScriptTypes.Object) && !declaringClass.equals((Object)JavaScriptTypes.Array);
    }
}

