/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodePos;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.rewrite.CAstBasicRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class CAstRewriterExt
extends CAstRewriter<NodePos, CAstBasicRewriter.NoKey> {
    private final Map<CAstControlFlowMap, Set<CAstNode>> extra_nodes = HashMapFactory.make();
    private final Map<CAstControlFlowMap, Set<Edge>> extra_flow = HashMapFactory.make();
    private final Map<CAstControlFlowMap, Set<CAstNode>> flow_to_delete = HashMapFactory.make();
    private final HashSet<Entity> entities_to_add = HashSetFactory.make();
    private final Stack<CAstEntity> entities = new Stack();
    Map<CAstEntity, CAstEntity> rewrite_cache = HashMapFactory.make();

    public CAstNode addNode(CAstNode node, CAstControlFlowMap flow) {
        HashSet nodes = this.extra_nodes.get(flow);
        if (nodes == null) {
            nodes = HashSetFactory.make();
            this.extra_nodes.put(flow, nodes);
        }
        nodes.add((CAstNode)node);
        return node;
    }

    public CAstNode addFlow(CAstNode node, Object label, CAstNode target, CAstControlFlowMap flow) {
        HashSet edges = this.extra_flow.get(flow);
        if (edges == null) {
            edges = HashSetFactory.make();
            this.extra_flow.put(flow, edges);
        }
        edges.add(new Edge(node, label, target));
        return node;
    }

    public void deleteFlow(CAstNode node, CAstEntity entity) {
        CAstControlFlowMap flow = entity.getControlFlow();
        HashSet tmp = this.flow_to_delete.get(flow);
        if (tmp == null) {
            tmp = HashSetFactory.make();
            this.flow_to_delete.put(flow, tmp);
        }
        tmp.add((CAstNode)node);
    }

    protected boolean isFlowDeleted(CAstNode node, CAstEntity entity) {
        CAstControlFlowMap flow = entity.getControlFlow();
        return this.flow_to_delete.containsKey(flow) && this.flow_to_delete.get(flow).contains(node);
    }

    public CAstEntity getCurrentEntity() {
        return this.entities.peek();
    }

    public Iterable<CAstEntity> getEnclosingEntities() {
        return this.entities;
    }

    public void addEntity(CAstNode anchor, CAstEntity entity) {
        this.entities_to_add.add(new Entity(anchor, entity));
    }

    protected Map<CAstNode, Collection<CAstEntity>> copyChildren(CAstNode root, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap, Map<CAstNode, Collection<CAstEntity>> children) {
        Map map = super.copyChildren(root, nodeMap, children);
        Iterator<Entity> es = this.entities_to_add.iterator();
        while (es.hasNext()) {
            Entity e = es.next();
            boolean relevant = NodePos.inSubtree(e.anchor, nodeMap.get(Pair.make((Object)root, null))) || NodePos.inSubtree(e.anchor, root);
            if (!relevant) continue;
            Collection c = (Collection)map.get(e.anchor);
            if (c == null) {
                c = HashSetFactory.make();
                map.put(e.anchor, c);
            }
            c.add(e.me);
            es.remove();
        }
        return map;
    }

    protected CAstNode flowOutTo(Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
        if (oldTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
            return oldTarget;
        }
        Assertions.UNREACHABLE();
        return super.flowOutTo(nodeMap, oldSource, label, oldTarget, orig, src);
    }

    protected CAstControlFlowMap copyFlow(Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap, CAstControlFlowMap orig, CAstSourcePositionMap newSrc) {
        HashMap nodeMapCopy = HashMapFactory.make(nodeMap);
        if (this.flow_to_delete.containsKey(orig)) {
            for (CAstNode node : this.flow_to_delete.get(orig)) {
                nodeMapCopy.remove(Pair.make((Object)node, null));
            }
        }
        CAstControlFlowRecorder flow = (CAstControlFlowRecorder)super.copyFlow((Map)nodeMapCopy, orig, newSrc);
        if (this.extra_nodes.containsKey(orig)) {
            for (CAstNode nd : this.extra_nodes.get(orig)) {
                flow.map((Object)nd, nd);
            }
        }
        if (this.extra_flow.containsKey(orig)) {
            for (Edge e : this.extra_flow.get(orig)) {
                CAstNode from = e.from;
                Object label = e.label;
                CAstNode to = e.to;
                if (nodeMap.containsKey(Pair.make((Object)from, null))) {
                    from = nodeMap.get(Pair.make((Object)from, null));
                }
                if (nodeMap.containsKey(Pair.make((Object)to, null))) {
                    to = nodeMap.get(Pair.make((Object)to, null));
                }
                if (!flow.isMapped((Object)from)) {
                    flow.map((Object)from, from);
                }
                if (!flow.isMapped((Object)to)) {
                    flow.map((Object)to, to);
                }
                flow.add((Object)from, (Object)to, label);
            }
        }
        return flow;
    }

    public CAstEntity rewrite(CAstEntity root) {
        if (this.rewrite_cache.containsKey(root)) {
            return this.rewrite_cache.get(root);
        }
        this.entities.push(root);
        this.enterEntity(root);
        CAstEntity entity = super.rewrite(root);
        this.rewrite_cache.put(root, entity);
        this.leaveEntity();
        this.entities.pop();
        return entity;
    }

    protected void enterEntity(CAstEntity entity) {
    }

    protected void leaveEntity() {
    }

    public CAstRewriterExt(CAst Ast, boolean recursive, NodePos rootContext) {
        super(Ast, recursive, (CAstRewriter.RewriteContext)rootContext);
    }

    private static class Entity {
        private final CAstNode anchor;
        private final CAstEntity me;

        public Entity(CAstNode anchor, CAstEntity me) {
            assert (me != null);
            this.anchor = anchor;
            this.me = me;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + (this.anchor == null ? 0 : this.anchor.hashCode());
            return 31 * result + this.me.hashCode();
        }
    }

    protected static class Edge {
        private CAstNode from;
        private Object label;
        private CAstNode to;

        public Edge(CAstNode from, Object label, CAstNode to) {
            assert (from != null);
            assert (to != null);
            this.from = from;
            this.label = label;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 + this.from.hashCode();
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + this.to.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Edge)) {
                return false;
            }
            Edge that = (Edge)obj;
            return this.from.equals(that.from) && (this.label == null ? that.label == null : this.label.equals(that.label)) && this.to.equals(that.to);
        }
    }
}

