/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.CAstRewriterExt;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ChildPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractedFunction;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPolicy;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPolicyFactory;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionRegion;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.LabelPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodeLabeller;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodePos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.PosSwitch;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.RootPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.TwoLevelExtractionRegion;
import com.ibm.wala.cast.js.translator.JSAstTranslator;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstNodeTypeMap;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.tree.rewrite.CAstBasicRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClosureExtractor
extends CAstRewriterExt {
    private LinkedList<ExtractionPolicy> policies = new LinkedList();
    private final ExtractionPolicyFactory policyFactory;
    private static final boolean LOCALISE = true;
    private static final String EXTRACTED_FUN_BASENAME = "_forin_body_";
    private NodeLabeller labeller = new NodeLabeller();
    private int anonymous_counter = 0;
    private final Set<CAstNode> synthetic = HashSetFactory.make();

    public ClosureExtractor(CAst Ast, ExtractionPolicyFactory policyFactory) {
        super(Ast, true, new RootPos());
        this.policyFactory = policyFactory;
    }

    @Override
    protected void enterEntity(CAstEntity entity) {
        this.policies.push(this.policyFactory.createPolicy(entity));
    }

    @Override
    protected void leaveEntity() {
        this.policies.pop();
    }

    protected CAstNode copyNodes(CAstNode root, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        switch (root.getKind()) {
            case 301: {
                return root;
            }
            case 300: {
                return this.copyConstant(root, context, nodeMap);
            }
            case 3: {
                return this.copyBlock(root, cfg, context, nodeMap);
            }
            case 7: {
                return this.copyReturn(root, cfg, context, nodeMap);
            }
            case 111: {
                return this.copyVar(root, cfg, context, nodeMap);
            }
            case 8: {
                return this.copyGoto(root, cfg, context, nodeMap);
            }
        }
        return this.copyNode(root, cfg, context, nodeMap);
    }

    private CAstNode copyConstant(CAstNode root, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        CAstNode newNode = this.Ast.makeConstant(root.getValue());
        nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
        return newNode;
    }

    private CAstNode copyBlock(CAstNode root, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        List<ExtractionRegion> regions = this.policies.getFirst().extract(root);
        if (regions == null || this.usesArguments(root)) {
            return this.copyNode(root, cfg, context, nodeMap);
        }
        ArrayList<CAstNode> copied_children = new ArrayList<CAstNode>();
        int next_child = 0;
        for (ExtractionRegion region : regions) {
            while (next_child < region.getStart()) {
                copied_children.add(this.copyNodes(root.getChild(next_child), cfg, new ChildPos(root, next_child, context), nodeMap));
                ++next_child;
            }
            copied_children.addAll(this.extractRegion(root, cfg, new ExtractionPos(root, region, context), nodeMap));
            next_child = region.getEnd();
        }
        while (next_child < root.getChildCount()) {
            copied_children.add(this.copyNodes(root.getChild(next_child), cfg, new ChildPos(root, next_child, context), nodeMap));
            ++next_child;
        }
        CAstNode newNode = this.Ast.makeNode(root.getKind(), copied_children.toArray(new CAstNode[0]));
        nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
        return newNode;
    }

    private CAstNode copyVar(CAstNode root, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        if (root.getChild(0).getValue().equals("this")) {
            ExtractionPos epos = ExtractionPos.getOutermostEnclosingExtractionPos(context);
            if (epos != null) {
                epos.addThis();
                CAstNode newNode = this.makeVarRef(epos.getThisParmName());
                this.addExnFlow(newNode, (Object)JavaScriptTypes.ReferenceError, this.getCurrentEntity(), context);
                nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
                return newNode;
            }
            return this.copyNode(root, cfg, context, nodeMap);
        }
        return this.copyNode(root, cfg, context, nodeMap);
    }

    private CAstNode copyGoto(CAstNode root, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        CAstNode target = this.getCurrentEntity().getControlFlow().getTarget(root, null);
        ExtractionPos epos = ExtractionPos.getEnclosingExtractionPos(context);
        if (epos != null && !NodePos.inSubtree(target, epos.getParent())) {
            epos.addGotoTarget(root.getChildCount() > 0 ? (String)root.getChild(0).getValue() : null, target);
            int label = this.labeller.addNode(target);
            CAstNode returnLit = this.addNode(this.Ast.makeNode(110, this.addExnFlow(this.Ast.makeNode(102, this.addExnFlow(this.makeVarRef("Object"), (Object)JavaScriptTypes.ReferenceError, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"ctor")), null, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"type"), this.Ast.makeConstant((Object)"goto"), this.Ast.makeConstant((Object)"target"), this.Ast.makeConstant((Object)String.valueOf((double)label))), this.getCurrentEntity().getControlFlow());
            this.addNode(returnLit, this.getCurrentEntity().getControlFlow());
            CAstNode newNode = this.Ast.makeNode(7, returnLit);
            this.deleteFlow(root, this.getCurrentEntity());
            nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
            return newNode;
        }
        return this.copyNode(root, cfg, context, nodeMap);
    }

    private CAstNode copyReturn(CAstNode root, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        ExtractionPos epos = ExtractionPos.getEnclosingExtractionPos(context);
        if (epos == null || this.isSynthetic(root)) {
            return this.copyNode(root, cfg, context, nodeMap);
        }
        do {
            epos.addReturn();
        } while ((epos = ExtractionPos.getEnclosingExtractionPos(epos.getParentPos())) != null);
        if (root.getChildCount() > 0) {
            CAstNode retval = this.copyNodes(root.getChild(0), cfg, new ChildPos(root, 0, context), nodeMap);
            CAstNode newNode = this.Ast.makeNode(7, this.addNode(this.Ast.makeNode(110, this.addExnFlow(this.Ast.makeNode(102, this.addExnFlow(this.makeVarRef("Object"), (Object)JavaScriptTypes.ReferenceError, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"ctor")), null, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"type"), this.Ast.makeConstant((Object)"return"), this.Ast.makeConstant((Object)"value"), retval), this.getCurrentEntity().getControlFlow()));
            nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
            return newNode;
        }
        CAstNode newNode = this.Ast.makeNode(7, this.addNode(this.Ast.makeNode(110, this.addExnFlow(this.Ast.makeNode(102, this.addExnFlow(this.makeVarRef("Object"), (Object)JavaScriptTypes.ReferenceError, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"ctor")), null, this.getCurrentEntity(), context), this.Ast.makeConstant((Object)"type"), this.Ast.makeConstant((Object)"return")), this.getCurrentEntity().getControlFlow()));
        nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
        return newNode;
    }

    private CAstNode copyNode(CAstNode node, CAstControlFlowMap cfg, NodePos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        CAstNode[] children = new CAstNode[node.getChildCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = this.copyNodes(node.getChild(i), cfg, new ChildPos(node, i, context), nodeMap);
        }
        for (Object label : cfg.getTargetLabels(node)) {
            if (!(label instanceof CAstNode)) continue;
            this.copyNodes((CAstNode)label, cfg, new LabelPos(node, context), nodeMap);
        }
        CAstNode newNode = this.Ast.makeNode(node.getKind(), children);
        nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)node, (Object)context.key()), newNode);
        ExtractionPos epos = ExtractionPos.getEnclosingExtractionPos(context);
        if (!this.isFlowDeleted(newNode, this.getCurrentEntity()) && epos != null) {
            CAstNode target;
            Collection labels = cfg.getTargetLabels(node);
            boolean invalidateCFlow = false;
            for (Object label : labels) {
                target = cfg.getTarget(node, label);
                if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT || epos.contains(target)) continue;
                invalidateCFlow = true;
                break;
            }
            if (invalidateCFlow) {
                this.deleteFlow(node, this.getCurrentEntity());
                for (Object label : labels) {
                    target = cfg.getTarget(node, label);
                    if (epos.contains(target)) {
                        this.addFlow(node, label, target, cfg);
                        continue;
                    }
                    this.addFlow(node, label, CAstControlFlowMap.EXCEPTION_TO_EXIT, cfg);
                }
            }
        }
        return newNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CAstNode> extractRegion(CAstNode root, CAstControlFlowMap cfg, ExtractionPos context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
        CAstNode newNode;
        CAstEntity entity = this.getCurrentEntity();
        boolean extractingBlock = context.getStart() + 1 == context.getEnd() && root.getChild(context.getStart()).getKind() == 3;
        boolean extractingLocalScope = false;
        boolean extractingEmpty = false;
        String name = EXTRACTED_FUN_BASENAME + this.anonymous_counter++;
        ExtractedFunction new_entity = new ExtractedFunction(name, context);
        context.setExtractedEntity(new_entity);
        ArrayList<CAstNode> prologue = new ArrayList<CAstNode>();
        ArrayList<CAstNode> fun_body_stmts = new ArrayList<CAstNode>();
        if (extractingBlock) {
            CAstNode block = root.getChild(context.getStart());
            for (int i = 0; i < block.getChildCount(); ++i) {
                fun_body_stmts.add(block.getChild(i));
            }
        } else if (context.getRegion() instanceof TwoLevelExtractionRegion) {
            CAstNode start = root.getChild(context.getStart());
            TwoLevelExtractionRegion tler = (TwoLevelExtractionRegion)context.getRegion();
            if (tler.getEndInner() != -1) {
                throw new UnimplementedError("Two-level extraction not fully implemented.");
            }
            if (start.getKind() == 3) {
                int i;
                CAstNode[] before = new CAstNode[tler.getStartInner()];
                for (i = 0; i < tler.getStartInner(); ++i) {
                    before[i] = this.copyNodes(start.getChild(i), cfg, context, nodeMap);
                }
                prologue.addAll(Arrays.asList(before));
                if (i + 1 == start.getChildCount()) {
                    fun_body_stmts.add(ClosureExtractor.addSpuriousExnFlow(start.getChild(i), cfg));
                } else {
                    CAstNode[] after = new CAstNode[start.getChildCount() - i];
                    int j = 0;
                    while (j + i < start.getChildCount()) {
                        after[j] = ClosureExtractor.addSpuriousExnFlow(start.getChild(j + i), cfg);
                        ++j;
                    }
                    fun_body_stmts.addAll(Arrays.asList(after));
                }
                for (i = context.getStart() + 1; i < context.getEnd(); ++i) {
                    fun_body_stmts.add(root.getChild(i));
                }
            } else {
                if (start.getKind() != 200) throw new UnimplementedError("Unsupported two-level.");
                if (tler.getStartInner() != 0) throw new UnimplementedError("Unsupported two-level extraction");
                if (tler.getEnd() != tler.getStart() + 1) {
                    throw new UnimplementedError("Unsupported two-level extraction");
                }
                fun_body_stmts.add(start.getChild(0));
                extractingLocalScope = true;
            }
        } else if (context.getEnd() > context.getStart() + 1) {
            CAstNode[] stmts = new CAstNode[context.getEnd() - context.getStart()];
            for (int i = context.getStart(); i < context.getEnd(); ++i) {
                stmts[i - context.getStart()] = root.getChild(i);
            }
            fun_body_stmts.add(this.Ast.makeNode(root.getKind(), stmts));
        } else {
            CAstNode node_to_extract = root.getChild(context.getStart());
            if (node_to_extract.getKind() == 19) {
                extractingEmpty = true;
            }
            fun_body_stmts.add(this.wrapIn(3, node_to_extract));
        }
        List<String> locals = context.getRegion().getLocals();
        String theLocal = null;
        if (locals.size() == 1 && this.noJumpsAndNoCalls(fun_body_stmts)) {
            theLocal = locals.get(0);
            CAstNode retLocal = this.Ast.makeNode(7, this.addExnFlow(this.makeVarRef(theLocal), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context));
            this.markSynthetic(retLocal);
            if (fun_body_stmts.size() == 1 && fun_body_stmts.get(0).getKind() == 3) {
                CAstNode[] stmts = new CAstNode[fun_body_stmts.get(0).getChildCount() + 1];
                for (int i = 0; i < stmts.length - 1; ++i) {
                    stmts[i] = fun_body_stmts.get(0).getChild(i);
                }
                stmts[stmts.length - 1] = retLocal;
                fun_body_stmts.set(0, this.Ast.makeNode(3, stmts));
            } else {
                fun_body_stmts.add(retLocal);
            }
            CAstNode theLocalDecl = this.Ast.makeNode(6, this.Ast.makeConstant((Object)new CAstSymbolImpl(theLocal, JSAstTranslator.Any)), this.addExnFlow(this.makeVarRef("$$undefined"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context));
            if (fun_body_stmts.size() > 1) {
                CAstNode newBlock = this.Ast.makeNode(3, fun_body_stmts.toArray(new CAstNode[0]));
                fun_body_stmts.clear();
                fun_body_stmts.add(newBlock);
            }
            fun_body_stmts.add(0, theLocalDecl);
        }
        CAstNode fun_body = this.Ast.makeNode(3, fun_body_stmts.toArray(new CAstNode[0]));
        HashMap nodes = HashMapFactory.make();
        final CAstNode newRoot = this.copyNodes(fun_body, cfg, context, (Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode>)nodes);
        final CAstSourcePositionMap theSource = this.copySource(nodes, entity.getSourceMap());
        final CAstControlFlowMap theCfg = this.copyFlow(nodes, entity.getControlFlow(), theSource);
        final CAstNodeTypeMap theTypes = this.copyTypes(nodes, entity.getNodeTypeMap());
        final HashMap theChildren = HashMapFactory.make();
        for (int i = context.getStart(); i < context.getEnd(); ++i) {
            theChildren.putAll(this.copyChildren(root.getChild(i), nodes, entity.getAllScopedEntities()));
        }
        CAstRewriter.Rewrite rw = new CAstRewriter.Rewrite(){

            public CAstNode newRoot() {
                return newRoot;
            }

            public CAstControlFlowMap newCfg() {
                return theCfg;
            }

            public CAstSourcePositionMap newPos() {
                return theSource;
            }

            public CAstNodeTypeMap newTypes() {
                return theTypes;
            }

            public Map<CAstNode, Collection<CAstEntity>> newChildren() {
                return theChildren;
            }

            public CAstNode[] newDefaults() {
                return null;
            }
        };
        new_entity.setRewrite(rw);
        ArrayList<CAstNode> args = new ArrayList<CAstNode>();
        CAstNode funExpr = this.Ast.makeNode(100, this.Ast.makeConstant((Object)new_entity));
        args.add(funExpr);
        context.setCallSite(funExpr);
        ExtractionPos outer = ExtractionPos.getEnclosingExtractionPos(context.getParentPos());
        if (outer == null) {
            this.addEntity(funExpr, new_entity);
        } else {
            outer.addNestedPos(context);
        }
        args.add(this.Ast.makeConstant((Object)"do"));
        args.add(this.addNode(this.makeVarRef("__WALA__int3rnal__global"), entity.getControlFlow()));
        for (String parmName : context.getParameters()) {
            args.add(this.addExnFlow(this.makeVarRef(parmName), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context));
        }
        if (context.containsThis()) {
            args.add(this.inFunction() ? this.Ast.makeNode(111, this.Ast.makeConstant((Object)"this")) : this.Ast.makeConstant(null));
        }
        CAstNode call = this.Ast.makeNode(102, args.toArray(new CAstNode[0]));
        this.addExnFlow(call, null, entity, (NodePos)context);
        List<CAstNode> stmts = new ArrayList<CAstNode>(prologue);
        if (context.containsJump()) {
            CAstNode decl = this.Ast.makeNode(14, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), call);
            CAstNode fixup = null;
            if (context.containsGoto()) {
                fixup = this.createGotoFixup(context, entity);
            }
            if (context.containsReturn()) {
                if (context.isOutermost()) {
                    CAstNode return_fixup = this.createReturnFixup(context, entity);
                    fixup = fixup != null ? this.Ast.makeNode(3, return_fixup, fixup) : return_fixup;
                } else {
                    fixup = this.Ast.makeNode(7, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context));
                }
            }
            if (!context.isOutermost() && (context.containsReturn() || context.containsOuterGoto())) {
                fixup = this.Ast.makeNode(7, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context));
            }
            fixup = this.Ast.makeNode(11, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), this.Ast.makeNode(200, this.wrapIn(3, fixup == null ? this.Ast.makeNode(19) : fixup)));
            stmts.add(decl);
            stmts.add(fixup);
        } else if (theLocal != null) {
            stmts.add(this.Ast.makeNode(14, this.addExnFlow(this.makeVarRef(theLocal), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), call));
        } else {
            stmts.add(call);
        }
        if (extractingBlock) {
            newNode = this.Ast.makeNode(3, stmts.toArray(new CAstNode[0]));
            nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), newNode);
            this.deleteFlow(root, this.getCurrentEntity());
            stmts = Collections.singletonList(newNode);
        }
        if (!extractingLocalScope) {
            if (!extractingEmpty) return stmts;
        }
        newNode = this.Ast.makeNode(200, this.wrapIn(3, stmts.toArray(new CAstNode[0])));
        return Collections.singletonList(newNode);
    }

    private static CAstNode addSpuriousExnFlow(CAstNode node, CAstControlFlowMap cfg) {
        CAstControlFlowRecorder flow = (CAstControlFlowRecorder)cfg;
        if (node.getKind() == 14 && node.getChild(0).getKind() == 111) {
            CAstNode var = node.getChild(0);
            if (!flow.isMapped((Object)var)) {
                flow.map((Object)var, var);
            }
            flow.add((Object)var, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)JavaScriptTypes.ReferenceError);
        }
        return node;
    }

    private CAstNode createReturnFixup(ExtractionPos context, CAstEntity entity) {
        return this.Ast.makeNode(11, this.Ast.makeNode(105, (CAstNode)CAstOperator.OP_EQ, this.addExnFlow(this.Ast.makeNode(112, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), this.Ast.makeConstant((Object)"type")), (Object)JavaScriptTypes.TypeError, entity, (NodePos)context), this.Ast.makeConstant((Object)"return")), this.Ast.makeNode(7, this.addExnFlow(this.Ast.makeNode(112, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), this.Ast.makeConstant((Object)"value")), (Object)JavaScriptTypes.TypeError, entity, (NodePos)context)));
    }

    private CAstNode createGotoFixup(ExtractionPos context, CAstEntity entity) {
        CAstNode fixup = null;
        for (Pair<String, CAstNode> goto_target : context.getGotoTargets()) {
            CAstNode cond = this.Ast.makeNode(105, (CAstNode)CAstOperator.OP_EQ, this.addExnFlow(this.Ast.makeNode(112, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), this.Ast.makeConstant((Object)"target")), (Object)JavaScriptTypes.TypeError, entity, (NodePos)context), this.Ast.makeConstant((Object)String.valueOf((double)this.labeller.getLabel((CAstNode)goto_target.snd))));
            CAstNode then_branch = goto_target.fst != null ? this.Ast.makeNode(8, this.Ast.makeConstant(goto_target.fst)) : this.Ast.makeNode(8);
            this.addFlow(then_branch, null, (CAstNode)goto_target.snd, entity.getControlFlow());
            if (fixup != null) {
                fixup = this.Ast.makeNode(11, cond, then_branch, fixup);
                continue;
            }
            fixup = this.Ast.makeNode(11, cond, then_branch);
        }
        return this.Ast.makeNode(11, this.Ast.makeNode(105, (CAstNode)CAstOperator.OP_EQ, this.addExnFlow(this.Ast.makeNode(112, this.addExnFlow(this.makeVarRef("re$"), (Object)JavaScriptTypes.ReferenceError, entity, (NodePos)context), this.Ast.makeConstant((Object)"type")), (Object)JavaScriptTypes.TypeError, entity, (NodePos)context), this.Ast.makeConstant((Object)"goto")), this.Ast.makeNode(200, this.wrapIn(3, fixup)));
    }

    private CAstNode wrapIn(int kind, CAstNode ... nodes) {
        return nodes.length == 1 && nodes[0].getKind() == kind ? nodes[0] : this.Ast.makeNode(kind, nodes);
    }

    private CAstNode addExnFlow(CAstNode node, Object label, CAstEntity entity, NodePos pos) {
        return this.addExnFlow(node, label, entity.getControlFlow(), pos);
    }

    private CAstNode addExnFlow(CAstNode node, Object label, CAstControlFlowMap flow, NodePos pos) {
        CAstNode target = this.getThrowTarget(pos);
        return this.addFlow(node, label, target, flow);
    }

    private CAstNode getThrowTarget(NodePos pos) {
        return pos.accept(new PosSwitch<CAstNode>(){

            @Override
            public CAstNode caseRootPos(RootPos pos) {
                return CAstControlFlowMap.EXCEPTION_TO_EXIT;
            }

            @Override
            public CAstNode caseChildPos(ChildPos pos) {
                int kind = pos.getParent().getKind();
                if (kind == 4 && pos.getIndex() == 0) {
                    return pos.getParent().getChild(1);
                }
                if (kind == 100 || kind == 13) {
                    return CAstControlFlowMap.EXCEPTION_TO_EXIT;
                }
                return ClosureExtractor.this.getThrowTarget(pos.getParentPos());
            }

            @Override
            public CAstNode caseForInLoopBodyPos(ExtractionPos pos) {
                return ClosureExtractor.this.getThrowTarget(pos.getParentPos());
            }

            @Override
            public CAstNode caseLabelPos(LabelPos pos) {
                return ClosureExtractor.this.getThrowTarget(pos.getParentPos());
            }
        });
    }

    private CAstNode makeVarRef(String name) {
        return this.Ast.makeNode(111, this.Ast.makeConstant((Object)name));
    }

    private boolean inFunction() {
        for (CAstEntity e : this.getEnclosingEntities()) {
            if (e.getKind() != 1) continue;
            return true;
        }
        return false;
    }

    private void markSynthetic(CAstNode node) {
        this.synthetic.add(node);
    }

    private boolean isSynthetic(CAstNode node) {
        return this.synthetic.contains(node);
    }

    private boolean noJumpsAndNoCalls(Collection<CAstNode> nodes) {
        for (CAstNode node : nodes) {
            if (this.noJumpsAndNoCalls(node)) continue;
            return false;
        }
        return true;
    }

    private boolean noJumpsAndNoCalls(CAstNode node) {
        switch (node.getKind()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 102: 
            case 109: {
                return false;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (this.noJumpsAndNoCalls(node.getChild(i))) continue;
            return false;
        }
        return true;
    }

    private boolean usesArguments(CAstNode node) {
        if (node.getKind() == 111) {
            return node.getChild(0).getValue().equals("arguments");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.usesArguments(node.getChild(i))) continue;
            return true;
        }
        return false;
    }
}

