/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.Correlation;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.CorrelationSummary;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.EscapeCorrelation;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.ReadWriteCorrelation;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ChildPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPolicy;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionRegion;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodePos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.RootPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.TwoLevelExtractionRegion;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CorrelatedPairExtractionPolicy
extends ExtractionPolicy {
    private static final boolean DEBUG = true;
    private final Map<CAstNode, List<ExtractionRegion>> region_map = HashMapFactory.make();

    private CorrelatedPairExtractionPolicy() {
    }

    private static void findNodesAtPos(int kind, CAstSourcePositionMap.Position pos, CAstSourcePositionMap spmap, ChildPos nodep, Set<ChildPos> res) {
        CAstNode node = nodep.getChild();
        if (node == null) {
            return;
        }
        CAstSourcePositionMap.Position ndpos = spmap.getPosition(node);
        if (ndpos != null) {
            if (!ndpos.getURL().equals(pos.getURL())) {
                return;
            }
            if (pos.getLastLine() >= 0 && ndpos.getFirstLine() > pos.getLastLine()) {
                return;
            }
            if (node.getKind() == kind && ndpos.getFirstOffset() == pos.getFirstOffset() && ndpos.getLastOffset() == pos.getLastOffset()) {
                res.add(nodep);
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            CorrelatedPairExtractionPolicy.findNodesAtPos(kind, pos, spmap, nodep.getChildPos(i), res);
        }
    }

    private static Set<ChildPos> findNodesAtPos(int kind, CAstSourcePositionMap.Position pos, CAstEntity entity) {
        HashSet res = HashSetFactory.make();
        CAstSourcePositionMap spmap = entity.getSourceMap();
        CAstNode ast = entity.getAST();
        for (int i = 0; i < ast.getChildCount(); ++i) {
            CorrelatedPairExtractionPolicy.findNodesAtPos(kind, pos, spmap, new ChildPos(ast, i, new RootPos()), res);
        }
        return res;
    }

    private boolean addCorrelation(CAstEntity entity, Correlation corr, CorrelationSummary correlations) {
        ChildPos endNode;
        ChildPos startNode;
        CAstSourcePositionMap.Position startPos = corr.getStartPosition(correlations.getPositions());
        CAstSourcePositionMap.Position endPos = corr.getEndPosition(correlations.getPositions());
        assert (startPos.getFirstLine() != -1);
        assert (endPos.getFirstLine() != -1);
        Set<ChildPos> startNodes = null;
        Set<ChildPos> endNodes = null;
        if (!entity.getPosition().getURL().equals(startPos.getURL())) {
            return true;
        }
        startNodes = CorrelatedPairExtractionPolicy.findNodesAtPos(112, startPos, entity);
        if (corr instanceof ReadWriteCorrelation) {
            endNodes = CorrelatedPairExtractionPolicy.findNodesAtPos(14, endPos, entity);
        } else if (corr instanceof EscapeCorrelation) {
            int arity = ((EscapeCorrelation)corr).getNumberOfArguments();
            endNodes = CorrelatedPairExtractionPolicy.findNodesAtPos(102, endPos, entity);
            Iterator<ChildPos> iter = endNodes.iterator();
            while (iter.hasNext()) {
                CAstNode candidate = iter.next().getChild();
                if (candidate.getChildCount() - 3 == arity) continue;
                iter.remove();
            }
        } else {
            throw new IllegalArgumentException("Unknown correlation type.");
        }
        if (startNodes.isEmpty() || endNodes.isEmpty()) {
            System.err.println("Couldn't find any " + (startNodes.isEmpty() ? (endNodes.isEmpty() ? "boundary" : "start") : "end") + " nodes for correlation " + corr.pp(correlations.getPositions()));
            return true;
        }
        CorrelatedPairExtractionPolicy.filterNames(startNodes, corr.getIndexName());
        CorrelatedPairExtractionPolicy.filterNames(endNodes, corr.getIndexName());
        Iterator<ChildPos> iter = startNodes.iterator();
        if (startNodes.size() == 2 && endNodes.equals(startNodes)) {
            startNode = iter.next();
            endNode = iter.next();
        } else {
            if (startNodes.size() > 1 || startNodes.size() == 0) {
                System.err.println("Couldn't find unique start node for correlation " + corr.pp(correlations.getPositions()));
                return false;
            }
            if (endNodes.size() > 1 || endNodes.size() == 0) {
                System.err.println("Couldn't find unique end node for correlation " + corr.pp(correlations.getPositions()));
                return false;
            }
            startNode = startNodes.iterator().next();
            endNode = endNodes.iterator().next();
        }
        List<String> locals = corr.getFlownThroughLocals().size() == 1 ? Collections.singletonList(corr.getFlownThroughLocals().iterator().next()) : Collections.emptyList();
        Pair<CAstNode, ? extends ExtractionRegion> region_info = CorrelatedPairExtractionPolicy.findClosestContainingBlock(entity, startNode, endNode, corr.getIndexName(), locals);
        if (region_info == null) {
            System.err.println("Couldn't find enclosing block for correlation " + corr.pp(correlations.getPositions()));
            return false;
        }
        List<ExtractionRegion> regions = this.region_map.get(region_info.fst);
        if (regions == null) {
            regions = new LinkedList<ExtractionRegion>();
            this.region_map.put((CAstNode)region_info.fst, regions);
        }
        for (int i = 0; i < regions.size(); ++i) {
            ExtractionRegion region2 = regions.get(i);
            if (region2.getEnd() <= ((ExtractionRegion)region_info.snd).getStart()) continue;
            if (region2.getStart() < ((ExtractionRegion)region_info.snd).getEnd()) {
                if (((ExtractionRegion)region_info.snd).getParameters().equals(region2.getParameters())) {
                    region2.setStart(Math.min(((ExtractionRegion)region_info.snd).getStart(), region2.getStart()));
                    region2.setEnd(Math.max(((ExtractionRegion)region_info.snd).getEnd(), region2.getEnd()));
                    System.err.println("Successfully processed correlation " + corr.pp(correlations.getPositions()));
                    return true;
                }
                System.err.println("Overlapping regions.");
                return false;
            }
            regions.add(i, (ExtractionRegion)region_info.snd);
            System.out.println("Successfully processed correlation " + corr.pp(correlations.getPositions()));
            return true;
        }
        System.out.println("Successfully processed correlation " + corr.pp(correlations.getPositions()));
        regions.add((ExtractionRegion)region_info.snd);
        return true;
    }

    private static void filterNames(Set<ChildPos> nodes, String indexName) {
        Iterator<ChildPos> iter = nodes.iterator();
        while (iter.hasNext()) {
            CAstNode index;
            CAstNode node = iter.next().getChild();
            if (node.getKind() != 112 || (index = node.getChild(1)).getKind() == 111 && index.getChild(0).getValue().equals(indexName)) continue;
            iter.remove();
        }
    }

    private static Pair<CAstNode, ? extends ExtractionRegion> findClosestContainingBlock(CAstEntity entity, ChildPos startNode, ChildPos endNode, String parmName, List<String> locals) {
        ChildPos pos = startNode;
        CAstNode block = null;
        int start = -1;
        int end = 0;
        int start_inner = -1;
        int end_inner = -1;
        do {
            if (pos != startNode && pos.getParentPos() instanceof ChildPos) {
                pos = (ChildPos)pos.getParentPos();
            }
            while (pos.getParent().getKind() != 3) {
                if (pos.getParentPos() instanceof ChildPos) {
                    pos = (ChildPos)pos.getParentPos();
                    continue;
                }
                return null;
            }
        } while ((end = CorrelatedPairExtractionPolicy.getCoveringChildIndex(block = pos.getParent(), start = pos.getIndex(), endNode.getChild()) + 1) == 0);
        CAstControlFlowMap cfg = entity.getControlFlow();
        for (int i = start; i < end; ++i) {
            CAstNode stmt = block.getChild(i);
            for (Object targetLabel : cfg.getTargetLabels(stmt)) {
                CAstNode target = cfg.getTarget(stmt, targetLabel);
                int targetIndex = CorrelatedPairExtractionPolicy.getCoveringChildIndex(block, start, target);
                if (targetIndex < end) continue;
                end = targetIndex + 1;
            }
        }
        if (block.getChild(0).getKind() == 3 && start == 0) {
            for (start_inner = 0; start_inner < block.getChild(0).getChildCount(); ++start_inner) {
                if (!NodePos.inSubtree(startNode.getChild(), block.getChild(0).getChild(start_inner))) continue;
                return Pair.make((Object)block, (Object)new TwoLevelExtractionRegion(start, end, start_inner, end_inner, Collections.singletonList(parmName), locals));
            }
        } else if (block.getChild(start).getKind() == 200 && end == start + 1) {
            return Pair.make((Object)block, (Object)new TwoLevelExtractionRegion(start, end, 0, -1, Collections.singletonList(parmName), locals));
        }
        return Pair.make((Object)block, (Object)new ExtractionRegion(start, end, Collections.singletonList(parmName), locals));
    }

    private static int getCoveringChildIndex(CAstNode parent, int start, CAstNode child) {
        for (int i = start; i < parent.getChildCount(); ++i) {
            if (!NodePos.inSubtree(child, parent.getChild(i))) continue;
            return i;
        }
        return -1;
    }

    private static CorrelatedPairExtractionPolicy addCorrelations(CAstEntity entity, Map<CAstSourcePositionMap.Position, CorrelationSummary> summaries, CorrelatedPairExtractionPolicy policy) {
        if (entity.getAST() != null && summaries.containsKey(entity.getPosition())) {
            CorrelationSummary correlations = summaries.get(entity.getPosition());
            for (Correlation corr : correlations.getCorrelations()) {
                policy.addCorrelation(entity, corr, correlations);
            }
        }
        Map allScopedEntities = entity.getAllScopedEntities();
        for (Collection scopedEntities : allScopedEntities.values()) {
            for (CAstEntity scopedEntity : scopedEntities) {
                if (CorrelatedPairExtractionPolicy.addCorrelations(scopedEntity, summaries, policy) != null) continue;
                return null;
            }
        }
        return policy;
    }

    public static CorrelatedPairExtractionPolicy make(CAstEntity entity, Map<IMethod, CorrelationSummary> summaries) {
        CorrelatedPairExtractionPolicy policy = new CorrelatedPairExtractionPolicy();
        HashMap summary_map = HashMapFactory.make();
        for (Map.Entry<IMethod, CorrelationSummary> e : summaries.entrySet()) {
            CAstSourcePositionMap.Position pos;
            if (!(e.getKey() instanceof AstMethod) || (pos = ((AstMethod)e.getKey()).getSourcePosition()) == null) continue;
            summary_map.put(pos, e.getValue());
        }
        return CorrelatedPairExtractionPolicy.addCorrelations(entity, summary_map, policy);
    }

    @Override
    public List<ExtractionRegion> extract(CAstNode node) {
        return this.region_map.get(node);
    }
}

