/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.loader;

import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.AstPropertyRead;
import com.ibm.wala.cast.ir.ssa.AstPropertyWrite;
import com.ibm.wala.cast.ir.ssa.AstYieldInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.js.analysis.typeInference.JSPrimitiveType;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraph;
import com.ibm.wala.cast.js.ipa.modref.JavaScriptModRef;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.cast.js.translator.JSAstTranslator;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.CAstAbstractModuleLoader;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.rewrite.CAstRewriterFactory;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.LanguageImpl;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAbstractBinaryInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class JavaScriptLoader
extends CAstAbstractModuleLoader {
    public static final Language JS = new LanguageImpl(){
        {
            JSPrimitiveType.init();
        }

        public Atom getName() {
            return Atom.findOrCreateUnicodeAtom((String)"JavaScript");
        }

        public TypeReference getRootType() {
            return JavaScriptTypes.Root;
        }

        public TypeReference getThrowableType() {
            return JavaScriptTypes.Root;
        }

        public TypeReference getConstantType(Object o) {
            if (o == null) {
                return JavaScriptTypes.Null;
            }
            Class<?> c = o.getClass();
            if (c == Boolean.class) {
                return JavaScriptTypes.Boolean;
            }
            if (c == String.class) {
                return JavaScriptTypes.String;
            }
            if (c == Integer.class) {
                return JavaScriptTypes.Number;
            }
            if (c == Float.class) {
                return JavaScriptTypes.Number;
            }
            if (c == Double.class) {
                return JavaScriptTypes.Number;
            }
            assert (false) : "cannot determine type for " + o + " of class " + c;
            return null;
        }

        public boolean isNullType(TypeReference type) {
            return type.equals((Object)JavaScriptTypes.Undefined) || type.equals((Object)JavaScriptTypes.Null);
        }

        public TypeReference[] getArrayInterfaces() {
            return new TypeReference[0];
        }

        public TypeName lookupPrimitiveType(String name) {
            if ("Boolean".equals(name)) {
                return JavaScriptTypes.Boolean.getName();
            }
            if ("Number".equals(name)) {
                return JavaScriptTypes.Number.getName();
            }
            if ("String".equals(name)) {
                return JavaScriptTypes.String.getName();
            }
            if ("Date".equals(name)) {
                return JavaScriptTypes.Date.getName();
            }
            assert ("RegExp".equals(name));
            return JavaScriptTypes.RegExp.getName();
        }

        public Collection<TypeReference> inferInvokeExceptions(MethodReference target, IClassHierarchy cha) throws InvalidClassFileException {
            return Collections.singleton(JavaScriptTypes.Root);
        }

        public Object getMetadataToken(Object value) {
            assert (false);
            return null;
        }

        public TypeReference getPointerType(TypeReference pointee) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("JavaScript does not permit explicit pointers");
        }

        public boolean methodsHaveDeclaredParameterTypes() {
            return false;
        }

        public JSInstructionFactory instructionFactory() {
            return new JSInstructionFactory(){

                @Override
                public JavaScriptCheckReference CheckReference(int iindex, int ref) {
                    return new JavaScriptCheckReference(iindex, ref);
                }

                @Override
                public SSAGetInstruction GetInstruction(int iindex, int result, int ref, String field) {
                    return this.GetInstruction(iindex, result, ref, FieldReference.findOrCreate((TypeReference)JavaScriptTypes.Root, (Atom)Atom.findOrCreateUnicodeAtom((String)field), (TypeReference)JavaScriptTypes.Root));
                }

                @Override
                public JavaScriptInstanceOf InstanceOf(int iindex, int result, int objVal, int typeVal) {
                    return new JavaScriptInstanceOf(iindex, result, objVal, typeVal);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int[] results, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, results, params, exception, site);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int result, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, result, params, exception, site);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, params, exception, site);
                }

                public AstPropertyRead PropertyRead(int iindex, int result, int objectRef, int memberRef) {
                    return new JavaScriptPropertyRead(iindex, result, objectRef, memberRef);
                }

                public AstPropertyWrite PropertyWrite(int iindex, int objectRef, int memberRef, int value) {
                    return new JavaScriptPropertyWrite(iindex, objectRef, memberRef, value);
                }

                @Override
                public SSAPutInstruction PutInstruction(int iindex, int ref, int value, String field) {
                    try {
                        byte[] utf8 = field.getBytes("UTF-8");
                        return this.PutInstruction(iindex, ref, value, FieldReference.findOrCreate((TypeReference)JavaScriptTypes.Root, (Atom)Atom.findOrCreate((byte[])utf8, (int)0, (int)utf8.length), (TypeReference)JavaScriptTypes.Root));
                    }
                    catch (UnsupportedEncodingException e) {
                        Assertions.UNREACHABLE();
                        return null;
                    }
                }

                @Override
                public JavaScriptTypeOfInstruction TypeOfInstruction(int iindex, int lval, int object) {
                    return new JavaScriptTypeOfInstruction(iindex, lval, object);
                }

                @Override
                public JavaScriptWithRegion WithRegion(int iindex, int expr, boolean isEnter) {
                    return new JavaScriptWithRegion(iindex, expr, isEnter);
                }

                public AstAssertInstruction AssertInstruction(int iindex, int value, boolean fromSpecification) {
                    return new AstAssertInstruction(iindex, value, fromSpecification);
                }

                public AssignInstruction AssignInstruction(int iindex, int result, int val) {
                    return new AssignInstruction(iindex, result, val);
                }

                public EachElementGetInstruction EachElementGetInstruction(int iindex, int value, int objectRef, int prevProp) {
                    return new EachElementGetInstruction(iindex, value, objectRef, prevProp);
                }

                public EachElementHasNextInstruction EachElementHasNextInstruction(int iindex, int value, int objectRef, int prop) {
                    return new EachElementHasNextInstruction(iindex, value, objectRef, prop);
                }

                public AstEchoInstruction EchoInstruction(int iindex, int[] rvals) {
                    return new AstEchoInstruction(iindex, rvals);
                }

                public AstYieldInstruction YieldInstruction(int iindex, int[] rvals) {
                    return new AstYieldInstruction(iindex, rvals);
                }

                public AstGlobalRead GlobalRead(int iindex, int lhs, FieldReference global) {
                    return new AstGlobalRead(iindex, lhs, global);
                }

                public AstGlobalWrite GlobalWrite(int iindex, FieldReference global, int rhs) {
                    return new AstGlobalWrite(iindex, global, rhs);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal, FieldReference fieldRef) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldVal, fieldRef);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, FieldReference fieldRef) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldRef);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldVal);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval) {
                    return new AstIsDefinedInstruction(iindex, lval, rval);
                }

                public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access[] accesses) {
                    return new AstLexicalRead(iindex, accesses);
                }

                public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access access) {
                    return new AstLexicalRead(iindex, access);
                }

                public AstLexicalRead LexicalRead(int iindex, int lhs, String definer, String globalName, TypeReference type) {
                    return new AstLexicalRead(iindex, lhs, definer, globalName, type);
                }

                public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access[] accesses) {
                    return new AstLexicalWrite(iindex, accesses);
                }

                public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access access) {
                    return new AstLexicalWrite(iindex, access);
                }

                public AstLexicalWrite LexicalWrite(int iindex, String definer, String globalName, TypeReference type, int rhs) {
                    return new AstLexicalWrite(iindex, definer, globalName, type, rhs);
                }

                public SSAArrayLengthInstruction ArrayLengthInstruction(int iindex, int result, int arrayref) {
                    throw new UnsupportedOperationException();
                }

                public SSAArrayLoadInstruction ArrayLoadInstruction(int iindex, int result, int arrayref, int index, TypeReference declaredType) {
                    throw new UnsupportedOperationException();
                }

                public SSAArrayStoreInstruction ArrayStoreInstruction(int iindex, int arrayref, int index, int value, TypeReference declaredType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAbstractBinaryInstruction BinaryOpInstruction(int iindex, IBinaryOpInstruction.IOperator operator, boolean overflow, boolean unsigned, int result, int val1, int val2, boolean mayBeInteger) {
                    return new SSABinaryOpInstruction(iindex, operator, result, val1, val2, mayBeInteger){

                        public boolean isPEI() {
                            return false;
                        }

                        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
                            return insts.BinaryOpInstruction(this.iindex, this.getOperator(), false, false, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], uses == null ? this.getUse(1) : uses[1], this.mayBeIntegerOp());
                        }
                    };
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference[] types, boolean isPEI) {
                    throw new UnsupportedOperationException();
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int[] typeValues, boolean isPEI) {
                    throw new UnsupportedOperationException();
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int typeValue, boolean isPEI) {
                    assert (isPEI);
                    return this.CheckCastInstruction(iindex, result, val, new int[]{typeValue}, true);
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference type, boolean isPEI) {
                    assert (isPEI);
                    return this.CheckCastInstruction(iindex, result, val, new TypeReference[]{type}, true);
                }

                public SSAComparisonInstruction ComparisonInstruction(int iindex, IComparisonInstruction.Operator operator, int result, int val1, int val2) {
                    return new SSAComparisonInstruction(iindex, operator, result, val1, val2);
                }

                public SSAConditionalBranchInstruction ConditionalBranchInstruction(int iindex, IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2, int target) {
                    return new SSAConditionalBranchInstruction(iindex, operator, type, val1, val2, target);
                }

                public SSAConversionInstruction ConversionInstruction(int iindex, int result, int val, TypeReference fromType, TypeReference toType, boolean overflow) {
                    assert (!overflow);
                    return new SSAConversionInstruction(iindex, result, val, fromType, toType){

                        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
                            if (uses != null && uses.length == 0) {
                                throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
                            }
                            return insts.ConversionInstruction(this.iindex, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], this.getFromType(), this.getToType(), false);
                        }
                    };
                }

                public SSAGetCaughtExceptionInstruction GetCaughtExceptionInstruction(int iindex, int bbNumber, int exceptionValueNumber) {
                    return new SSAGetCaughtExceptionInstruction(iindex, bbNumber, exceptionValueNumber);
                }

                public SSAGetInstruction GetInstruction(int iindex, int result, FieldReference field) {
                    throw new UnsupportedOperationException();
                }

                public SSAGetInstruction GetInstruction(int iindex, int result, int ref, FieldReference field) {
                    return new SSAGetInstruction(iindex, result, ref, field){

                        public boolean isPEI() {
                            return false;
                        }
                    };
                }

                public SSAGotoInstruction GotoInstruction(int iindex, int target) {
                    return new SSAGotoInstruction(iindex, target);
                }

                public SSAInstanceofInstruction InstanceofInstruction(int iindex, int result, int ref, TypeReference checkedType) {
                    throw new UnsupportedOperationException();
                }

                public SSAInvokeInstruction InvokeInstruction(int iindex, int result, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod bootstrap) {
                    throw new UnsupportedOperationException();
                }

                public SSAInvokeInstruction InvokeInstruction(int iindex, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod bootstrap) {
                    throw new UnsupportedOperationException();
                }

                public SSALoadMetadataInstruction LoadMetadataInstruction(int iindex, int lval, TypeReference entityType, Object token) {
                    throw new UnsupportedOperationException();
                }

                public SSAMonitorInstruction MonitorInstruction(int iindex, int ref, boolean isEnter) {
                    throw new UnsupportedOperationException();
                }

                public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site) {
                    return new SSANewInstruction(iindex, result, site){

                        public boolean isPEI() {
                            return true;
                        }

                        public Collection<TypeReference> getExceptionTypes() {
                            return Collections.singleton(JavaScriptTypes.TypeError);
                        }
                    };
                }

                public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site, int[] params) {
                    throw new UnsupportedOperationException();
                }

                public SSAPhiInstruction PhiInstruction(int iindex, int result, int[] params) {
                    return new SSAPhiInstruction(iindex, result, params);
                }

                public SSAPiInstruction PiInstruction(int iindex, int result, int val, int piBlock, int successorBlock, SSAInstruction cause) {
                    return new SSAPiInstruction(iindex, result, val, piBlock, successorBlock, cause);
                }

                public SSAPutInstruction PutInstruction(int iindex, int ref, int value, FieldReference field) {
                    return new SSAPutInstruction(iindex, ref, value, field){

                        public boolean isPEI() {
                            return false;
                        }
                    };
                }

                public SSAPutInstruction PutInstruction(int iindex, int value, FieldReference field) {
                    throw new UnsupportedOperationException();
                }

                public SSAReturnInstruction ReturnInstruction(int iindex) {
                    return new SSAReturnInstruction(iindex);
                }

                public SSAReturnInstruction ReturnInstruction(int iindex, int result, boolean isPrimitive) {
                    return new SSAReturnInstruction(iindex, result, isPrimitive);
                }

                public SSASwitchInstruction SwitchInstruction(int iindex, int val, int defaultLabel, int[] casesAndLabels) {
                    return new SSASwitchInstruction(iindex, val, defaultLabel, casesAndLabels);
                }

                public SSAThrowInstruction ThrowInstruction(int iindex, int exception) {
                    return new SSAThrowInstruction(iindex, exception){

                        public boolean isPEI() {
                            return true;
                        }

                        public Collection<TypeReference> getExceptionTypes() {
                            return Collections.emptySet();
                        }
                    };
                }

                public SSAUnaryOpInstruction UnaryOpInstruction(int iindex, IUnaryOpInstruction.IOperator operator, int result, int val) {
                    return new SSAUnaryOpInstruction(iindex, operator, result, val);
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, int indexVal, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, FieldReference field, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSALoadIndirectInstruction LoadIndirectInstruction(int iindex, int lval, TypeReference t, int addressVal) {
                    throw new UnsupportedOperationException();
                }

                public SSAStoreIndirectInstruction StoreIndirectInstruction(int iindex, int addressVal, int rval, TypeReference t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public PrototypeLookup PrototypeLookup(int iindex, int lval, int object) {
                    return new PrototypeLookup(iindex, lval, object);
                }

                @Override
                public SetPrototype SetPrototype(int iindex, int object, int prototype) {
                    return new SetPrototype(iindex, object, prototype);
                }
            };
        }

        public boolean isDoubleType(TypeReference type) {
            return type == JavaScriptTypes.Number || type == JavaScriptTypes.NumberObject;
        }

        public boolean isFloatType(TypeReference type) {
            return false;
        }

        public boolean isIntType(TypeReference type) {
            return false;
        }

        public boolean isLongType(TypeReference type) {
            return false;
        }

        public boolean isMetadataType(TypeReference type) {
            return false;
        }

        public boolean isStringType(TypeReference type) {
            return type == JavaScriptTypes.String || type == JavaScriptTypes.StringObject;
        }

        public boolean isVoidType(TypeReference type) {
            return false;
        }

        public TypeReference getStringType() {
            return JavaScriptTypes.String;
        }

        public PrimitiveType getPrimitive(TypeReference reference) {
            return PrimitiveType.getPrimitive((TypeReference)reference);
        }

        public boolean isBooleanType(TypeReference type) {
            return JavaScriptTypes.Boolean.equals((Object)type);
        }

        public boolean isCharType(TypeReference type) {
            return false;
        }

        public AbstractRootMethod getFakeRootMethod(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            return new JSCallGraph.JSFakeRoot(cha, options, cache);
        }

        public <T extends InstanceKey> ModRef.RefVisitor<T, ? extends ExtendedHeapModel> makeRefVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa, ExtendedHeapModel h) {
            return new JavaScriptModRef.JavaScriptRefVisitor<T>(n, result, pa, h);
        }

        public <T extends InstanceKey> ModRef.ModVisitor<T, ? extends ExtendedHeapModel> makeModVisitor(CGNode n, Collection<PointerKey> result, PointerAnalysis<T> pa, ExtendedHeapModel h, boolean ignoreAllocHeapDefs) {
            return new JavaScriptModRef.JavaScriptModVisitor<T>(n, result, h, pa);
        }
    };
    private final JavaScriptTranslatorFactory translatorFactory;
    private final CAstRewriterFactory<?, ?> preprocessor;
    private static final Set<CAstQualifier> functionQualifiers = HashSetFactory.make();
    final CAstAbstractModuleLoader.CoreClass ROOT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, AstTypeReference.rootTypeName, null, (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass UNDEFINED = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Undefined.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass PRIMITIVES = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Primitives.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass FAKEROOT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.FakeRoot.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass STRING = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.String.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass NULL = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Null.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass ARRAY = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Array.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Object.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass TYPE_ERROR = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.TypeError.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass CODE_BODY = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.CodeBody.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass FUNCTION = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Function.getName(), JavaScriptTypes.CodeBody.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass SCRIPT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Script.getName(), JavaScriptTypes.CodeBody.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass BOOLEAN = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Boolean.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass NUMBER = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Number.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass DATE = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.Date.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass REGEXP = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.RegExp.getName(), JavaScriptTypes.Root.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass BOOLEAN_OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.BooleanObject.getName(), JavaScriptTypes.Object.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass NUMBER_OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.NumberObject.getName(), JavaScriptTypes.Object.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass DATE_OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.DateObject.getName(), JavaScriptTypes.Object.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass REGEXP_OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.RegExpObject.getName(), JavaScriptTypes.Object.getName(), (IClassLoader)this, null);
    final CAstAbstractModuleLoader.CoreClass STRING_OBJECT = new CAstAbstractModuleLoader.CoreClass((CAstAbstractModuleLoader)this, JavaScriptTypes.StringObject.getName(), JavaScriptTypes.Object.getName(), (IClassLoader)this, null);
    public static final Set<String> bootstrapFileNames;
    private static String prologueFileName;

    public JavaScriptLoader(IClassHierarchy cha, JavaScriptTranslatorFactory translatorFactory) {
        this(cha, translatorFactory, null);
    }

    public JavaScriptLoader(IClassHierarchy cha, JavaScriptTranslatorFactory translatorFactory, CAstRewriterFactory<?, ?> preprocessor) {
        super(cha);
        this.translatorFactory = translatorFactory;
        this.preprocessor = preprocessor;
    }

    public IClass makeCodeBodyType(String name, TypeReference P, CAstSourcePositionMap.Position sourcePosition, CAstEntity entity, AstTranslator.WalkContext context) {
        return new CAstAbstractModuleLoader.DynamicCodeBody((CAstAbstractModuleLoader)this, TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)name)), P, (IClassLoader)this, sourcePosition, entity, context);
    }

    public IClass defineFunctionType(String name, CAstSourcePositionMap.Position pos, CAstEntity entity, AstTranslator.WalkContext context) {
        return this.makeCodeBodyType(name, JavaScriptTypes.Function, pos, entity, context);
    }

    public IClass defineScriptType(String name, CAstSourcePositionMap.Position pos, CAstEntity entity, AstTranslator.WalkContext context) {
        return this.makeCodeBodyType(name, JavaScriptTypes.Script, pos, entity, context);
    }

    public IMethod defineCodeBodyCode(String clsName, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
        CAstAbstractModuleLoader.DynamicCodeBody C = (CAstAbstractModuleLoader.DynamicCodeBody)this.lookupClass(clsName, this.cha);
        assert (C != null) : clsName;
        return C.setCodeBody(this.makeCodeBodyCode(cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, (IClass)C));
    }

    public CAstAbstractModuleLoader.DynamicMethodObject makeCodeBodyCode(AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo, IClass C) {
        return new CAstAbstractModuleLoader.DynamicMethodObject((CAstAbstractModuleLoader)this, C, functionQualifiers, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
    }

    public Language getLanguage() {
        return JS;
    }

    public ClassLoaderReference getReference() {
        return JavaScriptTypes.jsLoader;
    }

    public SSAInstructionFactory getInstructionFactory() {
        return JS.instructionFactory();
    }

    public static void resetPrologueFile() {
        prologueFileName = "prologue.js";
    }

    public static void setPrologueFile(String name) {
        prologueFileName = name;
    }

    public static void addBootstrapFile(String fileName) {
        bootstrapFileNames.add(fileName);
    }

    protected TranslatorToCAst getTranslatorToCAst(CAst ast, ModuleEntry module) {
        TranslatorToCAst translator = this.translatorFactory.make(ast, module);
        if (this.preprocessor != null) {
            translator.addRewriter(this.preprocessor, true);
        }
        return translator;
    }

    protected TranslatorToIR initTranslator() {
        return new JSAstTranslator(this);
    }

    protected boolean shouldTranslate(CAstEntity entity) {
        return true;
    }

    static {
        functionQualifiers.add(CAstQualifier.PUBLIC);
        functionQualifiers.add(CAstQualifier.FINAL);
        prologueFileName = "prologue.js";
        bootstrapFileNames = HashSetFactory.make();
        bootstrapFileNames.add(prologueFileName);
    }
}

