/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.DynamicCallSiteReference;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class JSAstTranslator
extends AstTranslator {
    private static final boolean DEBUG = false;
    public static final CAstType Any = new CAstType(){

        public String getName() {
            return "Any";
        }

        public Collection<CAstType> getSupertypes() {
            return Collections.EMPTY_SET;
        }
    };

    public JSAstTranslator(JavaScriptLoader loader) {
        super((IClassLoader)loader);
    }

    private static boolean isPrologueScript(AstTranslator.WalkContext context) {
        return JavaScriptLoader.bootstrapFileNames.contains(context.getModule().getName());
    }

    protected boolean useDefaultInitValues() {
        return false;
    }

    protected boolean hasImplicitGlobals() {
        return true;
    }

    protected boolean treatGlobalsAsLexicallyScoped() {
        return false;
    }

    protected TypeReference defaultCatchType() {
        return JavaScriptTypes.Root;
    }

    protected TypeReference makeType(CAstType type) {
        assert ("Any".equals(type.getName()));
        return JavaScriptTypes.Root;
    }

    protected boolean ignoreName(String name) {
        return super.ignoreName(name) || name.endsWith(" temp");
    }

    protected String[] makeNameMap(CAstEntity n, Set<AstTranslator.Scope> scopes, SSAInstruction[] insts) {
        String[] names = super.makeNameMap(n, scopes, insts);
        for (SSAInstruction inst : insts) {
            if (!(inst instanceof PrototypeLookup) || names[inst.getUse(0)] == null) continue;
            names[inst.getDef()] = names[inst.getUse(0)];
        }
        return names;
    }

    private void addDefinedCheck(CAstNode n, AstTranslator.WalkContext context, int readVn) {
        context.cfg().addPreNode(n);
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).CheckReference(context.cfg().getCurrentInstruction(), readVn));
        CAstNode target = context.getControlFlow().getTarget(n, (Object)JavaScriptTypes.ReferenceError);
        if (target != null) {
            context.cfg().addPreEdge(n, target, true);
        } else {
            context.cfg().addPreEdgeToExit(n, true);
        }
        context.cfg().newBlock(true);
    }

    protected int doLexicallyScopedRead(CAstNode n, AstTranslator.WalkContext context, String name, TypeReference type) {
        int readVn = super.doLexicallyScopedRead(n, context, name, type);
        this.addDefinedCheck(n, context, readVn);
        return readVn;
    }

    protected int doGlobalRead(CAstNode n, AstTranslator.WalkContext context, String name, TypeReference type) {
        int readVn = super.doGlobalRead(n, context, name, type);
        if (n != null && !"undefined".equals(name) && !"$$undefined".equals(name)) {
            this.addDefinedCheck(n, context, readVn);
        }
        return readVn;
    }

    protected boolean defineType(CAstEntity type, AstTranslator.WalkContext wc) {
        Assertions.UNREACHABLE((String)"JavaScript doesn't have types. I suggest you look elsewhere for your amusement.");
        return false;
    }

    protected void defineField(CAstEntity topEntity, AstTranslator.WalkContext wc, CAstEntity n) {
        Assertions.UNREACHABLE((String)"JavaScript doesn't have fields");
    }

    protected String composeEntityName(AstTranslator.WalkContext parent, CAstEntity f) {
        if (f.getKind() == 2) {
            return f.getName();
        }
        return parent.getName() + '/' + f.getName();
    }

    protected void declareFunction(CAstEntity N, AstTranslator.WalkContext context) {
        String fnName = this.composeEntityName(context, N);
        if (N.getKind() == 2) {
            ((JavaScriptLoader)this.loader).defineScriptType('L' + fnName, N.getPosition(), N, context);
        } else if (N.getKind() == 1) {
            ((JavaScriptLoader)this.loader).defineFunctionType('L' + fnName, N.getPosition(), N, context);
        } else {
            Assertions.UNREACHABLE();
        }
    }

    protected void defineFunction(CAstEntity N, AstTranslator.WalkContext definingContext, AbstractCFG<SSAInstruction, ? extends IBasicBlock<SSAInstruction>> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation LI, AstMethod.DebuggingInformation debugInfo) {
        String fnName = this.composeEntityName(definingContext, N);
        ((JavaScriptLoader)this.loader).defineCodeBodyCode('L' + fnName, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, LI, debugInfo);
    }

    protected void doThrow(AstTranslator.WalkContext context, int exception) {
        context.cfg().addInstruction((SSAInstruction)this.insts.ThrowInstruction(context.cfg().getCurrentInstruction(), exception));
    }

    protected void doCall(AstTranslator.WalkContext context, CAstNode call, int result, int exception, CAstNode name, int receiver, int[] arguments) {
        MethodReference ref = name.getValue().equals("ctor") ? JavaScriptMethods.ctorReference : (name.getValue().equals("dispatch") ? JavaScriptMethods.dispatchReference : AstMethodReference.fnReference((TypeReference)JavaScriptTypes.CodeBody));
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).Invoke(context.cfg().getCurrentInstruction(), receiver, result, arguments, exception, (CallSiteReference)new DynamicCallSiteReference(ref, context.cfg().getCurrentInstruction())));
        context.cfg().addPreNode(call, context.getUnwindState());
        context.cfg().newBlock(true);
        if (context.getControlFlow().getTarget(call, null) != null) {
            context.cfg().addPreEdge(call, context.getControlFlow().getTarget(call, null), true);
        } else {
            context.cfg().addPreEdgeToExit(call, true);
        }
    }

    protected void doNewObject(AstTranslator.WalkContext context, CAstNode newNode, int result, Object type, int[] arguments) {
        assert (arguments == null);
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)("L" + type)));
        context.cfg().addInstruction((SSAInstruction)this.insts.NewInstruction(context.cfg().getCurrentInstruction(), result, NewSiteReference.make((int)context.cfg().getCurrentInstruction(), (TypeReference)typeRef)));
    }

    protected void doMaterializeFunction(CAstNode n, AstTranslator.WalkContext context, int result, int exception, CAstEntity fn) {
        int nm = context.currentScope().getConstantValue((Object)('L' + this.composeEntityName(context, fn)));
        int tmp = super.doGlobalRead(n, context, "Function", JavaScriptTypes.Function);
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).Invoke(context.cfg().getCurrentInstruction(), tmp, result, new int[]{nm}, exception, (CallSiteReference)new DynamicCallSiteReference(JavaScriptMethods.ctorReference, context.cfg().getCurrentInstruction())));
    }

    public void doArrayRead(AstTranslator.WalkContext context, int result, int arrayValue, CAstNode arrayRef, int[] dimValues) {
        Assertions.UNREACHABLE((String)"JSAstTranslator.doArrayRead() called!");
    }

    public void doArrayWrite(AstTranslator.WalkContext context, int arrayValue, CAstNode arrayRef, int[] dimValues, int rval) {
        Assertions.UNREACHABLE((String)"JSAstTranslator.doArrayWrite() called!");
    }

    protected void doFieldRead(AstTranslator.WalkContext context, int result, int receiver, CAstNode elt, CAstNode readNode) {
        this.visit(elt, (CAstVisitor.Context)context, (CAstVisitor)this);
        int x = context.currentScope().allocateTempValue();
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), x, receiver));
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).PrototypeLookup(context.cfg().getCurrentInstruction(), x, x));
        if (elt.getKind() == 300 && elt.getValue() instanceof String) {
            String field = (String)elt.getValue();
            context.currentScope().getConstantValue((Object)field);
            context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).GetInstruction(context.cfg().getCurrentInstruction(), result, x, field));
        } else {
            context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).PropertyRead(context.cfg().getCurrentInstruction(), result, x, context.getValue(elt)));
        }
        context.cfg().addPreNode(readNode, context.getUnwindState());
        context.cfg().newBlock(true);
        if (context.getControlFlow().getTarget(readNode, (Object)JavaScriptTypes.TypeError) != null) {
            context.cfg().addPreEdge(readNode, context.getControlFlow().getTarget(readNode, (Object)JavaScriptTypes.TypeError), true);
        } else {
            context.cfg().addPreEdgeToExit(readNode, true);
        }
    }

    protected void doFieldWrite(AstTranslator.WalkContext context, int receiver, CAstNode elt, CAstNode parent, int rval) {
        this.visit(elt, (CAstVisitor.Context)context, (CAstVisitor)this);
        if (elt.getKind() == 300 && elt.getValue() instanceof String) {
            String field = (String)elt.getValue();
            if (JSAstTranslator.isPrologueScript(context) && "__proto__".equals(field)) {
                context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).SetPrototype(context.cfg().getCurrentInstruction(), receiver, rval));
                return;
            }
        }
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).PropertyWrite(context.cfg().getCurrentInstruction(), receiver, context.getValue(elt), rval));
        context.cfg().addPreNode(parent, context.getUnwindState());
        context.cfg().newBlock(true);
        if (context.getControlFlow().getTarget(parent, (Object)JavaScriptTypes.TypeError) != null) {
            context.cfg().addPreEdge(parent, context.getControlFlow().getTarget(parent, (Object)JavaScriptTypes.TypeError), true);
        } else {
            context.cfg().addPreEdgeToExit(parent, true);
        }
    }

    private void doPrimitiveNew(AstTranslator.WalkContext context, int resultVal, String typeName) {
        this.doNewObject(context, null, resultVal, typeName + "Object", null);
        int rval = context.currentScope().getConstantValue((Object)typeName);
        context.currentScope().getConstantValue((Object)"class");
        context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).PutInstruction(context.cfg().getCurrentInstruction(), resultVal, rval, "class"));
    }

    protected void doPrimitive(int resultVal, AstTranslator.WalkContext context, CAstNode primitiveCall) {
        try {
            String name;
            switch (name = (String)primitiveCall.getChild(0).getValue()) {
                case "GlobalNaN": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Float.valueOf(Float.NaN))));
                    break;
                }
                case "GlobalInfinity": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Float.valueOf(Float.POSITIVE_INFINITY))));
                    break;
                }
                case "MathE": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.E)));
                    break;
                }
                case "MathPI": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.PI)));
                    break;
                }
                case "MathSQRT1_2": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.sqrt(0.5))));
                    break;
                }
                case "MathSQRT2": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.sqrt(2.0))));
                    break;
                }
                case "MathLN2": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.log(2.0))));
                    break;
                }
                case "MathLN10": {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue((Object)Math.log(10.0))));
                    break;
                }
                case "NewObject": {
                    this.doNewObject(context, null, resultVal, "Object", null);
                    break;
                }
                case "NewArray": {
                    this.doNewObject(context, null, resultVal, "Array", null);
                    break;
                }
                case "NewString": {
                    this.doPrimitiveNew(context, resultVal, "String");
                    break;
                }
                case "NewNumber": {
                    this.doPrimitiveNew(context, resultVal, "Number");
                    break;
                }
                case "NewRegExp": {
                    this.doPrimitiveNew(context, resultVal, "RegExp");
                    break;
                }
                case "NewFunction": {
                    this.doNewObject(context, null, resultVal, "Function", null);
                    break;
                }
                case "NewUndefined": {
                    this.doNewObject(context, null, resultVal, "Undefined", null);
                    break;
                }
                default: {
                    context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).AssignInstruction(context.cfg().getCurrentInstruction(), resultVal, context.currentScope().getConstantValue(null)));
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Cannot translate primitive " + primitiveCall.getChild(0).getValue(), e);
        }
    }

    protected void doIsFieldDefined(AstTranslator.WalkContext context, int result, int ref, CAstNode f) {
        if (f.getKind() == 300 && f.getValue() instanceof String) {
            String field = (String)f.getValue();
            FieldReference fieldRef = FieldReference.findOrCreate((TypeReference)JavaScriptTypes.Root, (Atom)Atom.findOrCreateUnicodeAtom((String)field), (TypeReference)JavaScriptTypes.Root);
            context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).IsDefinedInstruction(context.cfg().getCurrentInstruction(), result, ref, fieldRef));
        } else {
            context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).IsDefinedInstruction(context.cfg().getCurrentInstruction(), result, ref, context.getValue(f)));
        }
    }

    protected boolean visitInstanceOf(CAstNode n, AstTranslator.WalkContext c, CAstVisitor<AstTranslator.WalkContext> visitor) {
        AstTranslator.WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        context.setValue(n, result);
        return false;
    }

    protected void leaveInstanceOf(CAstNode n, AstTranslator.WalkContext c, CAstVisitor<AstTranslator.WalkContext> visitor) {
        AstTranslator.WalkContext context = c;
        int result = context.getValue(n);
        this.visit(n.getChild(0), (CAstVisitor.Context)context, visitor);
        int value = context.getValue(n.getChild(0));
        this.visit(n.getChild(1), (CAstVisitor.Context)context, visitor);
        int type = context.getValue(n.getChild(1));
        context.cfg().addInstruction((SSAInstruction)new JavaScriptInstanceOf(context.cfg().getCurrentInstruction(), result, value, type));
    }

    protected void doPrologue(AstTranslator.WalkContext context) {
        super.doPrologue(context);
        int tempVal = context.currentScope().allocateTempValue();
        this.doNewObject(context, null, tempVal, "Array", null);
        CAstSymbolImpl args = new CAstSymbolImpl("arguments", Any);
        context.currentScope().declare((CAstSymbol)args, tempVal);
    }

    protected boolean doVisit(CAstNode n, AstTranslator.WalkContext context, CAstVisitor<AstTranslator.WalkContext> visitor) {
        switch (n.getKind()) {
            case 122: {
                int result = context.currentScope().allocateTempValue();
                this.visit(n.getChild(0), (CAstVisitor.Context)context, (CAstVisitor)this);
                int ref = context.getValue(n.getChild(0));
                context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).TypeOfInstruction(context.cfg().getCurrentInstruction(), result, ref));
                context.setValue(n, result);
                return true;
            }
            case 1001: 
            case 1002: {
                this.visit(n.getChild(0), (CAstVisitor.Context)context, (CAstVisitor)this);
                int ref = context.getValue(n.getChild(0));
                context.cfg().addInstruction((SSAInstruction)((JSInstructionFactory)this.insts).WithRegion(context.cfg().getCurrentInstruction(), ref, n.getKind() == 1001));
                return true;
            }
        }
        return false;
    }

    protected CAstType topType() {
        return Any;
    }

    protected CAstType exceptionType() {
        return Any;
    }

    protected CAstSourcePositionMap.Position[] getParameterPositions(CAstEntity e) {
        if (e.getKind() == 2) {
            return new CAstSourcePositionMap.Position[0];
        }
        CAstSourcePositionMap.Position[] ps = new CAstSourcePositionMap.Position[e.getArgumentCount()];
        for (int i = 2; i < e.getArgumentCount(); ++i) {
            ps[i] = e.getPosition(i - 2);
        }
        return ps;
    }
}

