/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.ir.translator.ConstantFoldingRewriter;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.impl.CAstOperator;

public class JSConstantFoldingRewriter
extends ConstantFoldingRewriter {
    public JSConstantFoldingRewriter(CAst Ast) {
        super(Ast);
    }

    protected Object eval(CAstOperator op, Object lhs, Object rhs) {
        if (op == CAstOperator.OP_ADD) {
            if (lhs instanceof String || rhs instanceof String) {
                return String.valueOf(lhs) + rhs;
            }
            if (lhs instanceof Number && rhs instanceof Number) {
                return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
            }
        } else if (op != CAstOperator.OP_BIT_AND && op != CAstOperator.OP_BIT_OR && op != CAstOperator.OP_BIT_XOR && op != CAstOperator.OP_BITNOT) {
            if (op == CAstOperator.OP_CONCAT) {
                if (lhs instanceof String || rhs instanceof String) {
                    return String.valueOf(lhs) + rhs;
                }
            } else if (op == CAstOperator.OP_DIV) {
                if (lhs instanceof Number && rhs instanceof Number) {
                    return ((Number)lhs).doubleValue() / ((Number)rhs).doubleValue();
                }
            } else if (op != CAstOperator.OP_EQ) {
                if (op == CAstOperator.OP_GE) {
                    if (lhs instanceof Number && rhs instanceof Number) {
                        return ((Number)lhs).doubleValue() >= ((Number)rhs).doubleValue();
                    }
                } else if (op == CAstOperator.OP_GT) {
                    if (lhs instanceof Number && rhs instanceof Number) {
                        return ((Number)lhs).doubleValue() > ((Number)rhs).doubleValue();
                    }
                } else if (op == CAstOperator.OP_LE) {
                    if (lhs instanceof Number && rhs instanceof Number) {
                        return ((Number)lhs).doubleValue() <= ((Number)rhs).doubleValue();
                    }
                } else if (op != CAstOperator.OP_LSH) {
                    if (op == CAstOperator.OP_LT) {
                        if (lhs instanceof Number && rhs instanceof Number) {
                            return ((Number)lhs).doubleValue() < ((Number)rhs).doubleValue();
                        }
                    } else if (op == CAstOperator.OP_MOD) {
                        if (lhs instanceof Number && rhs instanceof Number) {
                            return ((Number)lhs).doubleValue() % ((Number)rhs).doubleValue();
                        }
                    } else if (op == CAstOperator.OP_MUL) {
                        if (lhs instanceof Number && rhs instanceof Number) {
                            return ((Number)lhs).doubleValue() * ((Number)rhs).doubleValue();
                        }
                    } else if (op != CAstOperator.OP_NE && op != CAstOperator.OP_NOT && op != CAstOperator.OP_REL_AND && op != CAstOperator.OP_REL_OR && op != CAstOperator.OP_REL_XOR && op != CAstOperator.OP_RSH && op != CAstOperator.OP_STRICT_EQ && op != CAstOperator.OP_STRICT_NE) {
                        if (op == CAstOperator.OP_SUB) {
                            if (lhs instanceof Number && rhs instanceof Number) {
                                return ((Number)lhs).doubleValue() - ((Number)rhs).doubleValue();
                            }
                        } else if (op == CAstOperator.OP_URSH) {
                            // empty if block
                        }
                    }
                }
            }
        }
        return null;
    }
}

