/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public interface JavaScriptTranslatorToCAst
extends TranslatorToCAst {

    public static class MemberDestructuringContext<C extends WalkContext<C, T>, T>
    implements WalkContext<C, T> {
        private final WalkContext<C, T> parent;
        private final Set<T> baseFor = new HashSet<T>();
        private int operationIndex;
        private boolean foundBase = false;

        protected MemberDestructuringContext(C parent, T initialBaseFor, int operationIndex) {
            this.parent = parent;
            this.baseFor.add(initialBaseFor);
            this.operationIndex = operationIndex;
        }

        @Override
        public int setOperation(T node) {
            if (this.baseFor.contains(node)) {
                this.foundBase = true;
                return this.operationIndex;
            }
            return -1;
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return this.foundBase;
        }

        @Override
        public void copyOperation(T from, T to) {
            if (this.baseFor.contains(from)) {
                this.baseFor.add(to);
            }
        }

        @Override
        public WalkContext<C, T> getParent() {
            return this.parent;
        }
    }

    public static class ScriptContext<C extends WalkContext<C, T>, T>
    extends FunctionContext<C, T> {
        private final String script;

        ScriptContext(C parent, T s, String script) {
            super(parent, s);
            this.script = script;
        }

        @Override
        public String script() {
            return this.script;
        }
    }

    public static class FunctionContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.FunctionContext<C, T>
    implements WalkContext<C, T> {
        private final Vector<CAstNode> initializers = new Vector();

        @Override
        public WalkContext<C, T> getParent() {
            return (WalkContext)super.getParent();
        }

        protected FunctionContext(C parent, T s) {
            super(parent, s);
        }

        @Override
        public void addNameDecl(CAstNode v) {
            this.initializers.add(v);
        }

        @Override
        public Collection<CAstNode> getNameDecls() {
            return this.initializers;
        }

        @Override
        public String script() {
            return ((WalkContext)this.parent).script();
        }

        public CAstNode getCatchTarget() {
            return CAstControlFlowMap.EXCEPTION_TO_EXIT;
        }

        @Override
        public int setOperation(T node) {
            return ((WalkContext)this.parent).setOperation(node);
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return ((WalkContext)this.parent).foundMemberOperation(node);
        }

        @Override
        public void copyOperation(T from, T to) {
            ((WalkContext)this.parent).copyOperation(from, to);
        }
    }

    public static class RootContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.RootContext<C, T>
    implements WalkContext<C, T> {
        @Override
        public WalkContext<C, T> getParent() {
            assert (false);
            return null;
        }

        @Override
        public String script() {
            return null;
        }

        public T top() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public void addNameDecl(CAstNode v) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Collection<CAstNode> getNameDecls() {
            Assertions.UNREACHABLE();
            return null;
        }

        public CAstNode getCatchTarget() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public int setOperation(T node) {
            return -1;
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return false;
        }

        @Override
        public void copyOperation(T from, T to) {
            Assertions.UNREACHABLE();
        }
    }

    public static interface WalkContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.WalkContext<C, T> {
        public WalkContext<C, T> getParent();

        default public String script() {
            return this.getParent().script();
        }

        default public void addNameDecl(CAstNode n) {
            this.getParent().addNameDecl(n);
        }

        default public Collection<CAstNode> getNameDecls() {
            return this.getParent().getNameDecls();
        }

        default public int setOperation(T node) {
            return this.getParent().setOperation(node);
        }

        default public boolean foundMemberOperation(T node) {
            return this.getParent().foundMemberOperation(node);
        }

        default public void copyOperation(T from, T to) {
            this.getParent().copyOperation(from, to);
        }
    }
}

