/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.util;

import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Iterator;

public class Util {
    public static IntSet getArgumentsArrayVns(IR ir, DefUse du) {
        int size;
        int originalArgsVn = Util.getArgumentsArrayVn(ir);
        MutableIntSet result = IntSetUtil.make();
        if (originalArgsVn == -1) {
            return result;
        }
        result.add(originalArgsVn);
        do {
            size = result.size();
            result.foreach(vn -> {
                for (SSAInstruction inst : Iterator2Iterable.make((Iterator)du.getUses(vn))) {
                    if (!(inst instanceof PrototypeLookup) && !(inst instanceof SSAPhiInstruction)) continue;
                    result.add(inst.getDef());
                }
            });
        } while (size != result.size());
        return result;
    }

    public static int getArgumentsArrayVn(IR ir) {
        for (int i = 0; i < ir.getInstructions().length; ++i) {
            SSAInstruction inst = ir.getInstructions()[i];
            if (inst == null) continue;
            for (int v = 0; v < inst.getNumberOfUses(); ++v) {
                String[] names = ir.getLocalNames(i, inst.getUse(v));
                if (names == null || names.length != 1 || !"arguments".equals(names[0])) continue;
                return inst.getUse(v);
            }
        }
        return -1;
    }
}

