/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodeLabeller;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CAstDumper {
    private static final boolean NORMALISE = false;
    private final NodeLabeller labeller;

    public CAstDumper() {
        this.labeller = new NodeLabeller();
    }

    public CAstDumper(NodeLabeller labeller) {
        this.labeller = labeller;
    }

    private static String indent(int indent) {
        return " ".repeat(indent);
    }

    public String dump(CAstEntity entity) {
        StringBuilder buf = new StringBuilder();
        this.dump(entity, 0, buf);
        return buf.toString();
    }

    private void dump(CAstEntity entity, int indent, StringBuilder buf) {
        Collection<Object> scopedEntities = Collections.emptySet();
        if (entity.getKind() == 2) {
            buf.append(CAstDumper.indent(indent)).append(entity.getName()).append(":\n");
            scopedEntities = this.dumpScopedEntities(entity, indent + 2, buf);
            this.dump(entity.getAST(), indent, buf, entity.getControlFlow());
        } else if (entity.getKind() == 1) {
            buf.append(CAstDumper.indent(indent)).append("function ").append(entity.getName()).append('(');
            for (int i = 0; i < entity.getArgumentCount(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(entity.getArgumentNames()[i]);
            }
            buf.append(") {\n");
            scopedEntities = this.dumpScopedEntities(entity, indent + 2, buf);
            this.dump(entity.getAST(), indent + 2, buf, entity.getControlFlow());
            buf.append(CAstDumper.indent(indent)).append("}\n\n");
        } else {
            throw new Error("Unknown entity kind " + entity.getKind());
        }
        for (CAstEntity cAstEntity : scopedEntities) {
            this.dump(cAstEntity, indent, buf);
        }
    }

    private Collection<CAstEntity> dumpScopedEntities(CAstEntity entity, int indent, StringBuilder buf) {
        ArrayList<CAstEntity> scopedEntities = new ArrayList<CAstEntity>();
        HashMap m = HashMapFactory.make();
        for (Map.Entry e : entity.getAllScopedEntities().entrySet()) {
            for (CAstEntity scopedEntity : (Collection)e.getValue()) {
                scopedEntities.add(scopedEntity);
                m.put(scopedEntity, (CAstNode)e.getKey());
            }
        }
        scopedEntities.sort(Comparator.comparing(CAstEntity::getName));
        buf.append(CAstDumper.indent(indent)).append("> ");
        boolean first = true;
        for (CAstEntity scopedEntity : scopedEntities) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(scopedEntity.getName()).append('@').append(this.labeller.addNode((CAstNode)m.get(scopedEntity)));
        }
        buf.append('\n');
        return scopedEntities;
    }

    private boolean isTrivial(CAstNode node) {
        switch (node.getKind()) {
            case 14: {
                return node.getChild(0).getKind() == 111 && this.isTrivial(node.getChild(1));
            }
            case 19: {
                return true;
            }
            case 3: 
            case 104: {
                return this.getNonTrivialChildCount(node) == 0;
            }
        }
        return false;
    }

    private int getNonTrivialChildCount(CAstNode node) {
        int cnt = 0;
        for (CAstNode child : node.getChildren()) {
            if (this.isTrivial(child)) continue;
            ++cnt;
        }
        return cnt;
    }

    private void dump(CAstNode node, int indent, StringBuilder buf, CAstControlFlowMap cfg) {
        if (this.isTrivial(node)) {
            return;
        }
        buf.append(CAstDumper.indent(indent)).append(this.labeller.addNode(node)).append(": ");
        if (node.getKind() == 300) {
            if (node.getValue() == null) {
                buf.append("null");
            } else if (node.getValue() instanceof Integer) {
                buf.append(String.valueOf(node.getValue()));
            } else {
                buf.append("\"").append(node.getValue()).append("\"");
            }
        } else if (node.getKind() == 301) {
            buf.append(node.getValue().toString());
        } else {
            buf.append(CAstPrinter.kindAsString((int)node.getKind()));
        }
        Collection labels = cfg.getTargetLabels(node);
        if (!labels.isEmpty()) {
            buf.append(" [");
            boolean first = true;
            for (Object label : labels) {
                CAstNode target = cfg.getTarget(node, label);
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                if (label instanceof CAstNode) {
                    buf.append("CAstNode@").append(this.labeller.addNode((CAstNode)label)).append(": ");
                } else {
                    buf.append(label).append(": ");
                }
                buf.append(this.labeller.addNode(target));
            }
            buf.append(']');
        }
        buf.append('\n');
        for (CAstNode child : node.getChildren()) {
            this.dump(child, indent + 2, buf, cfg);
        }
    }
}

