/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.CorrelationFinder;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ClosureExtractor;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.CorrelatedPairExtractionPolicy;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPolicy;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPolicyFactory;
import com.ibm.wala.cast.js.test.CAstDumper;
import com.ibm.wala.cast.js.test.TestForInBodyExtraction;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.classLoader.SourceURLModule;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class TestCorrelatedPairExtraction {
    private static final boolean ASSERT_EQUALS = true;

    public void testRewriter(String in, String out) {
        this.testRewriter(null, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewriter(String testName, String in, String out) {
        File tmp = null;
        try {
            tmp = File.createTempFile("test", ".js");
            FileUtil.writeFile((File)tmp, (String)in);
            final Map summaries = this.makeCorrelationFinder().findCorrelatedAccesses(Collections.singleton(new SourceURLModule(tmp.toURI().toURL())));
            CAstImpl ast = new CAstImpl();
            CAstEntity inEntity = this.parseJS(tmp, ast);
            ExtractionPolicyFactory policyFactory = new ExtractionPolicyFactory(){

                public ExtractionPolicy createPolicy(CAstEntity entity) {
                    CorrelatedPairExtractionPolicy policy = CorrelatedPairExtractionPolicy.make((CAstEntity)entity, (Map)summaries);
                    Assert.assertNotNull((Object)policy);
                    return policy;
                }
            };
            String actual = new CAstDumper().dump(new ClosureExtractor((CAst)ast, policyFactory).rewrite(inEntity));
            actual = TestForInBodyExtraction.eraseGeneratedNames(actual);
            FileUtil.writeFile((File)tmp, (String)out);
            String expected = new CAstDumper().dump(this.parseJS(tmp, ast));
            expected = TestForInBodyExtraction.eraseGeneratedNames(expected);
            FileUtil.writeFile((File)new File("build/expected.dump"), (String)expected);
            FileUtil.writeFile((File)new File("build/actual.dump"), (String)actual);
            Assert.assertEquals((String)testName, (Object)expected, (Object)actual);
        }
        catch (ClassHierarchyException | IOException e) {
            e.printStackTrace();
        }
        finally {
            if (tmp != null && tmp.exists()) {
                tmp.delete();
            }
        }
    }

    protected CAstEntity parseJS(File tmp, CAstImpl ast) throws IOException {
        String moduleName = tmp.getName();
        SourceFileModule module = new SourceFileModule(tmp, moduleName, null);
        return this.parseJS(ast, (SourceModule)module);
    }

    protected abstract CAstEntity parseJS(CAstImpl var1, SourceModule var2) throws IOException;

    protected abstract CorrelationFinder makeCorrelationFinder();

    @Test
    public void test1() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src) {\n    dest[p] = src[p];\n  }\n}", "function extend(dest, src) {\n  for(var p in src) {\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n  }\n}");
    }

    @Test
    public void test2() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src)\n    dest[p] = src[p];\n}", "function extend(dest, src) {\n  for(var p in src)\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n}");
    }

    @Test
    @Ignore
    public void test3() {
        this.testRewriter("function extend(dest, src) {\n  for(p in src)\n    dest[p] = src[p];\n}", "function extend(dest, src) {\n  for(p in src)\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n}");
    }

    @Test
    public void test4() {
        this.testRewriter("function extend(dest, src) {\n  var p;\n  for(p in src)\n    dest[p] = src[p];\n}", "function extend(dest, src) {\n  var p;\n  for(p in src)\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n}");
    }

    @Test
    public void test5() {
        this.testRewriter("function extend(dest, src) {\n  for(p in src) {\n    var p;\n    dest[p] = src[p];\n  }\n}", "function extend(dest, src) {\n  for(p in src) {\n    var p;\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n  }\n}");
    }

    @Test
    public void test6() {
        this.testRewriter("function extend(dest, src) {\n  for(p in src) {\n    dest[p] = src[p];\n    var p;\n  }\n}", "function extend(dest, src) {\n  for(p in src) {\n    var p;\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n  }\n}");
    }

    @Test
    @Ignore
    public void test7() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src) {\n    dest[p] = src[p];\n    p = true;\n  }\n  return p;\n}", null);
    }

    @Test
    public void test8() {
        this.testRewriter("Object.prototype.extend = function(src) {\n  for(var p in src)\n    this[p] = src[p];\n}", "Object.prototype.extend = function(src) {\n  for(var p in src)\n    (function _forin_body_0(p, thi$) {\n      thi$[p] = src[p];\n    })(p, this);\n}");
    }

    @Test
    @Ignore
    public void test9() {
        this.testRewriter("function defglobals(globals) {\n  for(var p in globals) {\n    (function() {\n      this[p] = globals[p];\n    })();\n  }\n}", "function defglobals(globals) {\n  for(var p in globals) {\n    (function() {\n      (function _forin_body_0(p, thi$) {\n        thi$[p] = globals[p];\n      })(p, this)\n    })();\n  }\n}");
    }

    @Test
    public void test10() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src) {\n    if(p == \"stop\")\n      break;\n    dest[p] = src[p];\n  }\n}", "function extend(dest, src) {\n  for(var p in src) {\n    if(p == \"stop\")\n      break;    (function _forin_body_0(p) {\n      dest[p] = src[p];\n    })(p);\n  }\n}");
    }

    @Test
    public void test11() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src) {\n    while(true) {\n      dest[p] = src[p];\n      break;\n    }\n  }\n}", "function extend(dest, src) {\n  for(var p in src) {\n    while(true) {\n      (function _forin_body_0(p) {\n        dest[p] = src[p];\n      })(p);\n      break;\n    }\n  }\n}");
    }

    @Test
    public void test12() {
        this.testRewriter("function extend(dest, src) {\n  outer: for(var p in src) {\n    while(true) {\n      dest[p] = src[p];\n      break outer;\n    }\n  }\n}", "function extend(dest, src) {\n  outer: for(var p in src) {\n    while(true) {\n      (function _forin_body_0(p) {\n        dest[p] = src[p];\n      })(p);      break outer;\n    }\n  }\n}");
    }

    @Test
    public void test13() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src) {\n    if(p == '__proto__')\n      throw new Exception('huh?');\n    dest[p] = src[p];\n  }\n}", "function extend(dest, src) {\n  for(var p in src) {\n    if(p == '__proto__')\n      throw new Exception('huh?');\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n     })(p);\n  }\n}");
    }

    @Test
    public void test14() {
        this.testRewriter("function extend(dest, src) {\n  var o = { dest: dest };\n  with(o) {\n    for(var p in src) {\n      dest[p] = src[p];\n    }\n  }\n}", "function extend(dest, src) {\n  var o = { dest: dest };\n  with(o) {\n    for(var p in src) {\n      (function _forin_body_0(p) {\n        dest[p] = src[p];\n      })(p);\n    }\n  }\n}");
    }

    @Test
    public void test15() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src)\n    dest[p] = src[p];\n}\nfunction foo() {\n  extend({}, {});\n}\nfoo();", "function extend(dest, src) {\n  for(var p in src)\n    (function _forin_body_0(p) {\n      dest[p] = src[p];\n    })(p);\n}\nfunction foo() {\n  extend({}, {});\n}\nfoo();");
    }

    @Test
    public void test16() {
        this.testRewriter("function ext(dest, src) {\n  for(var p in src)\n    do_ext(dest, p, src);\n}\nfunction do_ext(x, p, y) { x[p] = y[p]; }", "function ext(dest, src) {\n  for(var p in src)\n    do_ext(dest, p, src);\n}\nfunction do_ext(x, p, y) { x[p] = y[p]; }");
    }

    @Test
    public void test17() {
        this.testRewriter("function implement(dest, src) {\n  for(var p in src) {\n    dest.prototype[p] = src[p];\n  }\n}", "function implement(dest, src) {\n  for(var p in src) {\n    (function _forin_body_0(p) {\n      dest.prototype[p] = src[p];\n     })(p);\n  }\n}");
    }

    @Test
    public void test18() {
        this.testRewriter("function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property = properties[i], value = source[property];\n    this.prototype[property] = value;\n  }\n  return this;\n}", "function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property, value; property = properties[i]; value = (function _forin_body_0(property, thi$) { var value = source[property]; \n    thi$.prototype[property] = value; return value; })(property, this);\n  }\n  return this;\n}");
    }

    @Test
    public void test18_b() {
        this.testRewriter("function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property = properties[i], foo = 23, value = source[property];\n    this.prototype[property] = value;\n  }\n  return this;\n}", "function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property, foo, value; property = properties[i]; foo = 23; value = (function _forin_body_0(property, thi$) { var value = source[property];\n    thi$.prototype[property] = value; return value; })(property, this);\n  }\n  return this;\n}");
    }

    @Test
    public void test18_c() {
        this.testRewriter("function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property = properties[i], foo = 23, value = source[property], bar = 42;\n    this.prototype[property] = value;\n  }\n  return this;\n}", "function addMethods(source) {\n  var properties = Object.keys(source);\n  for (var i = 0, length = properties.length; i < length; i++) {\n    var property, foo, value, bar; property = properties[i]; foo = 23; value = function _forin_body_0(property, thi$) { var value = source[property]; bar = 42;\n    thi$.prototype[property] = value; return value; }(property, this);\n  }\n  return this;\n}");
    }

    @Test
    public void test19() {
        this.testRewriter("function extend(dest, src) {\n  for(var p in src)\n    if(foo(p)) write.call(dest, p, src[p]);\n}\nfunction write(p, v) { this[p] = v; }", "function extend(dest, src) {\n  for(var p in src)\n      (function _forin_body_0(p) { if(foo(p)) write.call(dest, p, src[p]); })(p);\n}\nfunction write(p, v) { this[p] = v; }");
    }

    @Test
    @Ignore
    public void test20() {
        this.testRewriter("function every(object, fn, bind) {\n  for(var key in object)\n    if(hasOwnProperty.call(object, key) && !fn.call(bind, object[key], key)) return false;\n}", "function every(object, fn, bind) {\n  for(var key in object) {\n    re$ = (function _forin_body_0(key) {\n      if (hasOwnProperty.call(object, key) && !fn.call(bind, object[key], key)) return { type: 'return', value: false };\n    })(key);\n    if(re$) { if(re$.type == 'return') return re$.value; }\n  }\n}");
    }

    @Test
    public void test21() {
        this.testRewriter("function extend(dest, src) {\n  var x, y;\n  for(var name in src) {\n    x = dest[name];\n    y = src[name];\n    dest[name] = join(x,y);\n  }\n}", "function extend(dest, src) {\n  var x, y;\n  for(var name in src) {\n    (function _forin_body_0(name) { x = dest[name];\n    y = src[name];\n    dest[name] = join(x,y); })(name);\n  }\n}");
    }

    @Test
    public void test22() {
        this.testRewriter("function(object, keys){\n  var results = {};\n  for (var i = 0, l = keys.length; i < l; i++){\n    var k = keys[i];\n    if (k in object) results[k] = object[k];\n  }\n  return results;\n}", "function(object, keys){\n  var results = {};\n  for (var i = 0, l = keys.length; i < l; i++){\n    var k = keys[i];\n    (function _forin_body_0(k) { if (k in object) results[k] = object[k]; })(k);\n  }\n  return results;\n}");
    }

    @Test
    public void test23() {
        this.testRewriter("function extend(dest, src) {\n  var s;\n  for(var p in src) {\n    s = src[p];\n    dest[p] = s;\n  }\n}", "function extend(dest, src) {\n  var s;\n  for(var p in src) {\n    s = (function _forin_body_0(p) {\n      var s;      s = src[p];\n      dest[p] = s;\n      return s;     })(p);\n  }\n}");
    }

    @Test
    public void test24() {
        this.testRewriter("function extend(dest, src) {  for(var p in src) {    arguments[0][p] = src[p];  }}", "function extend(dest, src) {  for(var p in src) {    arguments[0][p] = src[p];  }}");
    }

    @Test
    public void test25() {
        this.testRewriter("function eachProp(obj, func) {   var prop;   for (prop in obj) {     if (hasProp(obj, prop)) {       if (func(obj[prop], prop)) {         break;       }      }  }}", "function eachProp(obj, func) {   var prop;   for (prop in obj) {     if (hasProp(obj, prop)) {       re$ = (function _forin_body_0 (prop) { if (func(obj[prop], prop)) { return { type: \"goto\", target: 0 }; } })(prop);       if (re$) {         if (re$.type == \"goto\") {           if (re$.target == 0)             break;         }       }      }  }}");
    }
}

