/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.ipa.callgraph.CAstCallGraphUtil;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.ipa.callgraph.PropertyNameContextSelector;
import com.ibm.wala.cast.js.test.TestJSCallGraphShape;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import java.io.IOException;
import java.net.URL;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class TestForInLoopHack
extends TestJSCallGraphShape {
    private static final Object[][] assertionsForBadForin = new Object[][]{{ROOT, new String[]{"badforin.js"}}, {"badforin.js", new String[]{"badforin.js/testForIn", "badforin.js/_check_obj_foo", "badforin.js/_check_obj_bar", "badforin.js/_check_copy_foo", "badforin.js/_check_copy_bar"}}, {"badforin.js/testForIn", new String[]{"badforin.js/testForIn1", "badforin.js/testForIn2"}}, {"badforin.js/_check_obj_foo", new String[]{"badforin.js/testForIn1"}}, {"badforin.js/_check_copy_foo", new String[]{"badforin.js/testForIn1"}}, {"badforin.js/_check_obj_bar", new String[]{"badforin.js/testForIn2"}}, {"badforin.js/_check_copy_bar", new String[]{"badforin.js/testForIn2"}}};
    private static final Object[][] assertionsForBadForinHackPrecision = new Object[][]{{"badforin.js/_check_obj_foo", new String[]{"!badforin.js/testForIn2"}}, {"badforin.js/_check_copy_foo", new String[]{"!badforin.js/testForIn2"}}, {"badforin.js/_check_obj_bar", new String[]{"!badforin.js/testForIn1"}}, {"badforin.js/_check_copy_bar", new String[]{"!badforin.js/testForIn1"}}};
    private static final Object[][] assertionsForbadforin2 = new Object[][]{{ROOT, new String[]{"badforin2.js"}}, {"badforin2.js", new String[]{"badforin2.js/testForIn", "badforin2.js/_check_obj_foo", "badforin2.js/_check_obj_bar", "badforin2.js/_check_copy_foo", "badforin2.js/_check_copy_bar"}}, {"badforin2.js/testForIn", new String[]{"badforin2.js/testForIn1", "badforin2.js/testForIn2"}}, {"badforin2.js/_check_obj_foo", new String[]{"badforin2.js/testForIn1"}}, {"badforin2.js/_check_copy_foo", new String[]{"badforin2.js/testForIn1"}}, {"badforin2.js/_check_obj_bar", new String[]{"badforin2.js/testForIn2"}}, {"badforin2.js/_check_copy_bar", new String[]{"badforin2.js/testForIn2"}}};
    private static final Object[][] assertionsForbadforin2HackPrecision = new Object[][]{{"badforin2.js/_check_obj_foo", new String[]{"!badforin2.js/testForIn2"}}, {"badforin2.js/_check_copy_foo", new String[]{"!badforin2.js/testForIn2"}}, {"badforin2.js/_check_obj_bar", new String[]{"!badforin2.js/testForIn1"}}, {"badforin2.js/_check_copy_bar", new String[]{"!badforin2.js/testForIn1"}}};

    @Before
    public void config() {
        JSSourceExtractor.USE_TEMP_NAME = true;
        JSSourceExtractor.DELETE_UPON_EXIT = false;
    }

    @Test
    public void testPage3WithoutHack() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/page3.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
    }

    @Test
    public void testPage3WithHack() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/page3.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        TestForInLoopHack.addHackedForInLoopSensitivity(builder);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
    }

    @Ignore(value="This test now blows up due to proper handling of the || construct, used in extend().  Should handle this eventually.")
    @Test
    public void testJQueryWithHack() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/jquery_hacked.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        TestForInLoopHack.addHackedForInLoopSensitivity(builder);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
    }

    @Test
    public void testBadForInWithoutHack() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badforin.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForBadForin);
    }

    @Test
    public void testBadForInWithHack() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badforin.js");
        TestForInLoopHack.addHackedForInLoopSensitivity(B);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForBadForin);
        this.verifyGraphAssertions(CG, assertionsForBadForinHackPrecision);
    }

    @Test
    public void testbadforin2WithoutHack() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badforin2.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForbadforin2);
    }

    @Test
    public void testbadforin2WithHack() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badforin2.js");
        TestForInLoopHack.addHackedForInLoopSensitivity(B);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForbadforin2);
        this.verifyGraphAssertions(CG, assertionsForbadforin2HackPrecision);
    }

    @Test
    public void testForInRecursion() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badforin3.js");
        TestForInLoopHack.addHackedForInLoopSensitivity(B);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
    }

    private static void addHackedForInLoopSensitivity(JSCFABuilder builder) {
        ContextSelector orig = builder.getContextSelector();
        builder.setContextSelector((ContextSelector)new PropertyNameContextSelector(builder.getAnalysisCache(), orig));
    }
}

