/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.cast.ipa.callgraph.GlobalObjectKey;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstPropertyWrite;
import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.GlobalVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ObjectVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.PrototypeFieldVertex;
import com.ibm.wala.cast.js.html.DefaultSourceExtractor;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ipa.callgraph.TransitivePrototypeKey;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptConstructorFunctions;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.test.ExtractingToPredictableFileNames;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.js.util.FieldBasedCGUtil;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.cast.loader.AstDynamicField;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.NullProgressMonitor;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestPointerAnalyses {
    private final JavaScriptTranslatorFactory factory;

    protected TestPointerAnalyses(JavaScriptTranslatorFactory factory) {
        this.factory = factory;
        JSCallGraphUtil.setTranslatorFactory((JavaScriptTranslatorFactory)factory);
    }

    private static Pair<CGNode, NewSiteReference> map(CallGraph CG, Pair<CGNode, NewSiteReference> ptr) {
        CGNode n = (CGNode)ptr.fst;
        if (!(n.getMethod() instanceof JavaScriptConstructorFunctions.JavaScriptConstructor)) {
            return ptr;
        }
        Iterator preds = CG.getPredNodes((Object)n);
        if (!preds.hasNext()) {
            return ptr;
        }
        CGNode caller = (CGNode)preds.next();
        assert (!preds.hasNext()) : n;
        Iterator sites = CG.getPossibleSites(caller, n);
        CallSiteReference site = (CallSiteReference)sites.next();
        assert (!sites.hasNext());
        return Pair.make((Object)caller, (Object)new NewSiteReference(site.getProgramCounter(), ((NewSiteReference)ptr.snd).getDeclaredType()));
    }

    private static Set<Pair<CGNode, NewSiteReference>> map(CallGraph CG, Set<Pair<CGNode, NewSiteReference>> ptrs) {
        HashSet result = HashSetFactory.make();
        for (Pair<CGNode, NewSiteReference> ptr : ptrs) {
            result.add(TestPointerAnalyses.map(CG, ptr));
        }
        return result;
    }

    private static Set<Pair<CGNode, NewSiteReference>> ptrs(Set<CGNode> functions, int local, CallGraph CG, PointerAnalysis<? extends InstanceKey> pa) {
        HashSet result = HashSetFactory.make();
        for (CGNode n : functions) {
            OrdinalSet pointers;
            PointerKey l = pa.getHeapModel().getPointerKeyForLocal(n, local);
            if (l == null || (pointers = pa.getPointsToSet(l)) == null) continue;
            for (InstanceKey k : pointers) {
                for (Pair cs : Iterator2Iterable.make((Iterator)k.getCreationSites(CG))) {
                    result.add(cs);
                }
            }
        }
        return result;
    }

    private static boolean isGlobal(Set<CGNode> functions, int local, PointerAnalysis<? extends InstanceKey> pa) {
        for (CGNode n : functions) {
            OrdinalSet pointers;
            PointerKey l = pa.getHeapModel().getPointerKeyForLocal(n, local);
            if (l == null || (pointers = pa.getPointsToSet(l)) == null) continue;
            for (InstanceKey k : pointers) {
                if (!(k instanceof GlobalObjectKey) && !(k instanceof GlobalVertex)) continue;
                return true;
            }
        }
        return false;
    }

    private void testPage(URL page, Predicate<MethodReference> filter, Predicate<Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>>> test) throws WalaException, CancelException {
        try (ExtractingToPredictableFileNames predictable = new ExtractingToPredictableFileNames();){
            FieldBasedCGUtil fb = new FieldBasedCGUtil(this.factory);
            FieldBasedCallGraphBuilder.CallGraphResult fbResult = fb.buildCG(page, FieldBasedCGUtil.BuilderType.OPTIMISTIC, true, DefaultSourceExtractor.factory);
            JSCFABuilder propagationBuilder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)page);
            CallGraph propCG = propagationBuilder.makeCallGraph(propagationBuilder.getOptions());
            PointerAnalysis propPA = propagationBuilder.getPointerAnalysis();
            this.test(filter, test, (CallGraph)fbResult.getCallGraph(), (PointerAnalysis<ObjectVertex>)fbResult.getPointerAnalysis(), propCG, (PointerAnalysis<InstanceKey>)propPA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTestScript(String dir, String name, Predicate<MethodReference> filter, Predicate<Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>>> test) throws IOException, WalaException, CancelException {
        boolean save = JSSourceExtractor.USE_TEMP_NAME;
        try {
            JSSourceExtractor.USE_TEMP_NAME = false;
            FieldBasedCGUtil fb = new FieldBasedCGUtil(this.factory);
            FieldBasedCallGraphBuilder.CallGraphResult fbResult = fb.buildTestCG(dir, name, FieldBasedCGUtil.BuilderType.OPTIMISTIC, (MonitorUtil.IProgressMonitor)new NullProgressMonitor(), true);
            JSCFABuilder propagationBuilder = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)dir, (String)name);
            CallGraph propCG = propagationBuilder.makeCallGraph(propagationBuilder.getOptions());
            PointerAnalysis propPA = propagationBuilder.getPointerAnalysis();
            this.test(filter, test, (CallGraph)fbResult.getCallGraph(), (PointerAnalysis<ObjectVertex>)fbResult.getPointerAnalysis(), propCG, (PointerAnalysis<InstanceKey>)propPA);
        }
        finally {
            JSSourceExtractor.USE_TEMP_NAME = save;
        }
    }

    protected void test(Predicate<MethodReference> filter, Predicate<Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>>> test, CallGraph fbCG, PointerAnalysis<ObjectVertex> fbPA, CallGraph propCG, PointerAnalysis<InstanceKey> propPA) {
        HeapGraph hg = fbPA.getHeapGraph();
        HashSet functionsToCompare = HashSetFactory.make();
        for (CGNode n : fbCG) {
            MethodReference ref = n.getMethod().getReference();
            if (!filter.test(ref) || propCG.getNodes(ref).isEmpty()) continue;
            functionsToCompare.add(ref);
        }
        System.err.println(fbCG);
        for (MethodReference function : functionsToCompare) {
            System.err.println("testing " + function);
            Set fbNodes = fbCG.getNodes(function);
            Set propNodes = propCG.getNodes(function);
            CGNode node = (CGNode)fbNodes.iterator().next();
            IR ir = node.getIR();
            System.err.println(ir);
            int maxVn = -1;
            for (CallGraph cg : new CallGraph[]{fbCG, propCG}) {
                for (CGNode n : cg) {
                    IR nir = n.getIR();
                    if (nir == null || nir.getSymbolTable().getMaxValueNumber() <= maxVn) continue;
                    maxVn = nir.getSymbolTable().getMaxValueNumber();
                }
            }
            for (int i = 1; i <= maxVn; ++i) {
                Set<Pair<CGNode, NewSiteReference>> fbPtrs = TestPointerAnalyses.ptrs(fbNodes, i, fbCG, fbPA);
                Set<Pair<CGNode, NewSiteReference>> propPtrs = TestPointerAnalyses.map(propCG, TestPointerAnalyses.ptrs(propNodes, i, propCG, propPA));
                Assert.assertEquals((String)("analysis should agree on global object for " + i + " of " + ir), (Object)TestPointerAnalyses.isGlobal(fbNodes, i, fbPA), (Object)TestPointerAnalyses.isGlobal(propNodes, i, propPA));
                if (!fbPtrs.isEmpty() || !propPtrs.isEmpty()) {
                    System.err.println("checking local " + i + " of " + function + ": " + fbPtrs + " vs " + propPtrs);
                }
                Assert.assertTrue((String)(fbPtrs + " should intersect  " + propPtrs + " for " + i + " of " + ir), (boolean)test.test((Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>>)Pair.make(fbPtrs, propPtrs)));
            }
            SymbolTable symtab = ir.getSymbolTable();
            for (SSAInstruction inst : ir.getInstructions()) {
                if (inst instanceof JavaScriptPropertyWrite) {
                    int property = ((AstPropertyWrite)inst).getMemberRef();
                    if (!symtab.isConstant(property)) continue;
                    String p = JSCallGraphUtil.simulateToStringForPropertyNames((Object)symtab.getConstantValue(property));
                    int obj = ((AstPropertyWrite)inst).getObjectRef();
                    PointerKey objKey = fbPA.getHeapModel().getPointerKeyForLocal(node, obj);
                    OrdinalSet objPtrs = fbPA.getPointsToSet(objKey);
                    for (ObjectVertex o : objPtrs) {
                        PointerKey propKey = fbPA.getHeapModel().getPointerKeyForInstanceField((InstanceKey)o, (IField)new AstDynamicField(false, o.getConcreteType(), Atom.findOrCreateUnicodeAtom((String)p), JavaScriptTypes.Root));
                        Assert.assertTrue((String)("object " + o + " should have field " + propKey), (boolean)hg.hasEdge((Object)o, (Object)propKey));
                        int val = ((AstPropertyWrite)inst).getValue();
                        PointerKey valKey = fbPA.getHeapModel().getPointerKeyForLocal(node, val);
                        OrdinalSet valPtrs = fbPA.getPointsToSet(valKey);
                        for (ObjectVertex v : valPtrs) {
                            Assert.assertTrue((String)("field " + propKey + " should point to object " + valKey + "(" + v + ")"), (boolean)hg.hasEdge((Object)propKey, (Object)v));
                        }
                    }
                    System.err.println("heap graph models instruction " + inst);
                    continue;
                }
                if (inst instanceof AstGlobalWrite) {
                    String propName = ((AstGlobalWrite)inst).getGlobalName();
                    propName = propName.substring("global ".length());
                    PointerKey propKey = fbPA.getHeapModel().getPointerKeyForInstanceField(null, (IField)new AstDynamicField(false, null, Atom.findOrCreateUnicodeAtom((String)propName), JavaScriptTypes.Root));
                    Assert.assertTrue((String)("global " + propName + " should exist"), (boolean)hg.hasEdge((Object)GlobalVertex.instance(), (Object)propKey));
                    System.err.println("heap graph models instruction " + inst);
                    continue;
                }
                if (!(inst instanceof JavaScriptInvoke)) continue;
                int vn = ((JavaScriptInvoke)inst).getReceiver();
                Set<Pair<CGNode, NewSiteReference>> fbPrototypes = TestPointerAnalyses.getFbPrototypes(fbPA, (HeapGraph<ObjectVertex>)hg, fbCG, node, vn);
                Set<Pair<CGNode, NewSiteReference>> propPrototypes = TestPointerAnalyses.getPropPrototypes(propPA, propCG, node, vn);
                Assert.assertTrue((String)("should have prototype overlap for " + fbPrototypes + " and " + propPrototypes + " at " + inst), (fbPrototypes.isEmpty() && propPrototypes.isEmpty() || !Collections.disjoint(fbPrototypes, propPrototypes) ? 1 : 0) != 0);
            }
        }
        for (InstanceKey k : fbPA.getInstanceKeys()) {
            k.getCreationSites(fbCG);
            for (String f : new String[]{"__proto__", "prototype"}) {
                boolean dump = false;
                PointerKey pointerKeyForInstanceField = fbPA.getHeapModel().getPointerKeyForInstanceField(k, (IField)new AstDynamicField(false, k.getConcreteType(), Atom.findOrCreateUnicodeAtom((String)f), JavaScriptTypes.Root));
                if (!hg.containsNode((Object)pointerKeyForInstanceField)) {
                    dump = true;
                    System.err.println("no " + f + " for " + k + "(" + k.getConcreteType() + ")");
                } else if (!hg.getSuccNodes((Object)pointerKeyForInstanceField).hasNext()) {
                    dump = true;
                    System.err.println("empty " + f + " for " + k + "(" + k.getConcreteType() + ")");
                }
                if (!dump) continue;
                for (Pair cs : Iterator2Iterable.make((Iterator)k.getCreationSites(fbCG))) {
                    System.err.println(cs);
                }
            }
        }
    }

    private static <T extends InstanceKey> Set<Pair<CGNode, NewSiteReference>> getPrototypeSites(PointerAnalysis<T> fbPA, CallGraph CG, Function<T, Iterator<T>> proto, CGNode node, int vn) {
        HashSet fbProtos = HashSetFactory.make();
        PointerKey fbKey = fbPA.getHeapModel().getPointerKeyForLocal(node, vn);
        OrdinalSet fbPointsTo = fbPA.getPointsToSet(fbKey);
        for (InstanceKey o : fbPointsTo) {
            for (InstanceKey p : Iterator2Iterable.make(proto.apply(o))) {
                for (Pair cs : Iterator2Iterable.make((Iterator)p.getCreationSites(CG))) {
                    fbProtos.add(cs);
                }
            }
        }
        return fbProtos;
    }

    private static Set<Pair<CGNode, NewSiteReference>> getFbPrototypes(PointerAnalysis<ObjectVertex> fbPA, HeapGraph<ObjectVertex> hg, CallGraph CG, CGNode node, int vn) {
        return TestPointerAnalyses.getPrototypeSites(fbPA, CG, o -> {
            PrototypeFieldVertex proto = new PrototypeFieldVertex(PrototypeFieldVertex.PrototypeField.__proto__, o);
            if (hg.containsNode((Object)proto)) {
                return new MapIterator(hg.getSuccNodes((Object)proto), ObjectVertex.class::cast);
            }
            return EmptyIterator.instance();
        }, node, vn);
    }

    private static Set<Pair<CGNode, NewSiteReference>> getPropPrototypes(PointerAnalysis<InstanceKey> fbPA, CallGraph CG, CGNode node, int vn) {
        return TestPointerAnalyses.getPrototypeSites(fbPA, CG, o -> fbPA.getPointsToSet((PointerKey)new TransitivePrototypeKey(o)).iterator(), node, vn);
    }

    private void testPageUserCodeEquivalent(URL page) throws WalaException, CancelException {
        String name = page.getFile().substring(page.getFile().lastIndexOf(47) + 1, page.getFile().lastIndexOf(46));
        this.testPage(page, this.nameFilter(name), new CheckPointers());
    }

    protected Predicate<MethodReference> nameFilter(String name) {
        return t -> {
            System.err.println(t + "  " + name);
            return t.getSelector().equals((Object)AstMethodReference.fnSelector) && t.getDeclaringClass().getName().toString().startsWith("L" + name);
        };
    }

    @Test
    public void testWindowOnload() throws WalaException, CancelException {
        this.testPageUserCodeEquivalent(this.getClass().getClassLoader().getResource("pages/windowonload.html"));
    }

    @Test
    public void testObjects() throws IOException, WalaException, CancelException {
        this.testTestScript("tests", "objects.js", this.nameFilter("tests/objects.js"), new CheckPointers());
    }

    @Test
    public void testInherit() throws IOException, WalaException, CancelException {
        this.testTestScript("tests", "inherit.js", this.nameFilter("tests/inherit.js"), new CheckPointers());
    }

    private static final class CheckPointers
    implements Predicate<Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>>> {
        private CheckPointers() {
        }

        private static Set<Pair<String, Integer>> map(Set<Pair<CGNode, NewSiteReference>> sites) {
            HashSet result = HashSetFactory.make();
            for (Pair<CGNode, NewSiteReference> s : sites) {
                result.add(Pair.make((Object)((CGNode)s.fst).getMethod().toString(), (Object)((NewSiteReference)s.snd).getProgramCounter()));
            }
            return result;
        }

        @Override
        public boolean test(Pair<Set<Pair<CGNode, NewSiteReference>>, Set<Pair<CGNode, NewSiteReference>>> t) {
            if (((Set)t.snd).isEmpty()) {
                return true;
            }
            HashSet x = HashSetFactory.make(CheckPointers.map((Set)t.fst));
            x.retainAll(CheckPointers.map((Set)t.snd));
            return !x.isEmpty();
        }
    }
}

