/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds.hypergraph;

import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperEdge;
import com.ibm.wala.analysis.arraybounds.hypergraph.HyperNode;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.Weight;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirectedHyperGraph<T> {
    private final Map<T, HyperNode<T>> nodes = new HashMap<T, HyperNode<T>>();
    private final Set<DirectedHyperEdge<T>> edges = new HashSet<DirectedHyperEdge<T>>();

    public Set<DirectedHyperEdge<T>> getEdges() {
        return this.edges;
    }

    public Map<T, HyperNode<T>> getNodes() {
        return this.nodes;
    }

    public void reset() {
        for (HyperNode<T> node : this.getNodes().values()) {
            node.setWeight(Weight.NOT_SET);
            node.setNewWeight(Weight.NOT_SET);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (DirectedHyperEdge<T> edge : this.getEdges()) {
            buffer.append(edge.getSource());
            buffer.append(" -- ");
            buffer.append(edge.getWeight());
            buffer.append(" --> ");
            buffer.append(edge.getDestination());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public void updateNodeEdges() {
        for (HyperNode hyperNode : this.getNodes().values()) {
            hyperNode.setOutEdges(new HashSet());
            hyperNode.setInEdges(new HashSet());
        }
        for (DirectedHyperEdge directedHyperEdge : this.edges) {
            for (HyperNode node : directedHyperEdge.getSource()) {
                node.getOutEdges().add(directedHyperEdge);
            }
            for (HyperNode node : directedHyperEdge.getDestination()) {
                node.getInEdges().add(directedHyperEdge);
            }
        }
    }
}

