/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.HashSet;
import java.util.Set;

public class Exception2BitvectorTransformer {
    private OrdinalSetMapping<TypeReference> values;

    public OrdinalSetMapping<TypeReference> getValues() {
        return this.values;
    }

    public Exception2BitvectorTransformer(Set<TypeReference> exceptions) {
        this.createValues(exceptions);
        for (TypeReference exception : exceptions) {
            BitVector bv = new BitVector(this.values.getSize());
            bv.set(this.values.getMappedIndex((Object)exception));
        }
    }

    private void createValues(Set<TypeReference> exceptions) {
        Object[] exceptionsArray = new TypeReference[exceptions.size()];
        exceptions.toArray(exceptionsArray);
        this.values = new ObjectArrayMapping(exceptionsArray);
    }

    public BitVector computeBitVector(Set<TypeReference> exceptions) {
        BitVector result = new BitVector(this.values.getSize());
        for (TypeReference exception : exceptions) {
            int pos = this.values.getMappedIndex((Object)exception);
            if (pos != -1) {
                result.set(pos);
                continue;
            }
            throw new IllegalArgumentException("Got exception I don't know about,make sure only to use exceptions given to the constructor ");
        }
        return result;
    }

    public Set<TypeReference> computeExceptions(BitVector bitVector) {
        assert (bitVector.length() == this.values.getSize());
        HashSet<TypeReference> result = new HashSet<TypeReference>();
        for (int i = 0; i < bitVector.length(); ++i) {
            if (!bitVector.get(i)) continue;
            result.add((TypeReference)this.values.getMappedObject(i));
        }
        return result;
    }

    public Set<TypeReference> computeExceptions(BitVectorVariable bitVector) {
        HashSet<TypeReference> result = new HashSet<TypeReference>();
        for (int i = 0; i < this.values.getSize(); ++i) {
            if (!bitVector.get(i)) continue;
            result.add((TypeReference)this.values.getMappedObject(i));
        }
        return result;
    }
}

