/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.analysis.exceptionanalysis.ExceptionAnalysis;
import com.ibm.wala.analysis.exceptionanalysis.IntraproceduralExceptionAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.EdgeFilter;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;

public class ExceptionAnalysis2EdgeFilter
implements EdgeFilter<ISSABasicBlock> {
    private ExceptionAnalysis analysis;
    private CGNode node;

    public ExceptionAnalysis2EdgeFilter(ExceptionAnalysis analysis, CGNode node) {
        this.analysis = analysis;
        this.node = node;
    }

    @Override
    public boolean hasNormalEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        boolean originalEdge;
        boolean result = originalEdge = this.node.getIR().getControlFlowGraph().getNormalSuccessors(src).contains(dst);
        SSAInstruction instruction = IntraproceduralExceptionAnalysis.getThrowingInstruction(src);
        if (instruction != null && this.analysis.getFilter().getFilter(this.node).alwaysThrowsException(instruction)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasExceptionalEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        boolean originalEdge;
        boolean result = originalEdge = this.node.getIR().getControlFlowGraph().getExceptionalSuccessors(src).contains(dst);
        if (dst.isCatchBlock()) {
            if (!this.analysis.catchesException(this.node, src, dst)) {
                result = false;
            }
        } else {
            assert (dst.isExitBlock());
            result = this.analysis.hasUncaughtExceptions(this.node, src);
        }
        return result;
    }
}

