/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.ClassFactoryContextInterpreter;
import com.ibm.wala.analysis.reflection.ClassNewInstanceContextInterpreter;
import com.ibm.wala.analysis.reflection.FactoryBypassInterpreter;
import com.ibm.wala.analysis.reflection.GetClassContextInterpeter;
import com.ibm.wala.analysis.reflection.GetMethodContextInterpreter;
import com.ibm.wala.analysis.reflection.JavaLangClassContextInterpreter;
import com.ibm.wala.analysis.reflection.ReflectiveInvocationInterpreter;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.FieldReference;
import java.util.Iterator;

public class ReflectionContextInterpreter {
    public static SSAContextInterpreter createReflectionContextInterpreter(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView iAnalysisCacheView) {
        if (options == null) {
            throw new IllegalArgumentException("null options");
        }
        SSAContextInterpreter result = new SSAContextInterpreter(){

            @Override
            public boolean understands(CGNode node) {
                return false;
            }

            @Override
            public boolean recordFactoryType(CGNode node, IClass klass) {
                return false;
            }

            @Override
            public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
                return null;
            }

            @Override
            public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
                return null;
            }

            @Override
            public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
                return null;
            }

            @Override
            public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
                return null;
            }

            @Override
            public int getNumberOfStatements(CGNode node) {
                return 0;
            }

            @Override
            public IR getIR(CGNode node) {
                return null;
            }

            @Override
            public IRView getIRView(CGNode node) {
                return this.getIR(node);
            }

            @Override
            public DefUse getDU(CGNode node) {
                return null;
            }

            @Override
            public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode n) {
                return null;
            }
        };
        if (options.getReflectionOptions().getNumFlowToCastIterations() > 0) {
            result = new DelegatingSSAContextInterpreter(new FactoryBypassInterpreter(options, iAnalysisCacheView), result);
        }
        if (!options.getReflectionOptions().isIgnoreStringConstants()) {
            result = new DelegatingSSAContextInterpreter(new GetClassContextInterpeter(), new DelegatingSSAContextInterpreter(new DelegatingSSAContextInterpreter(new ClassFactoryContextInterpreter(), new ClassNewInstanceContextInterpreter(cha)), result));
        }
        if (!options.getReflectionOptions().isIgnoreMethodInvoke()) {
            result = new DelegatingSSAContextInterpreter(new ReflectiveInvocationInterpreter(), new DelegatingSSAContextInterpreter(new JavaLangClassContextInterpreter(), result));
        }
        if (!options.getReflectionOptions().isIgnoreStringConstants() && !options.getReflectionOptions().isIgnoreMethodInvoke()) {
            result = new DelegatingSSAContextInterpreter(new GetMethodContextInterpreter(), result);
        }
        return result;
    }
}

