/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.ClassFactoryContextSelector;
import com.ibm.wala.analysis.reflection.ClassNewInstanceContextSelector;
import com.ibm.wala.analysis.reflection.FactoryContextSelector;
import com.ibm.wala.analysis.reflection.GetClassContextSelector;
import com.ibm.wala.analysis.reflection.GetMethodContextSelector;
import com.ibm.wala.analysis.reflection.JavaLangClassContextSelector;
import com.ibm.wala.analysis.reflection.ReflectiveInvocationSelector;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DelegatingContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;

public class ReflectionContextSelector {
    public static ContextSelector createReflectionContextSelector(AnalysisOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("null options");
        }
        ContextSelector result = new ContextSelector(){

            @Override
            public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
                return null;
            }

            @Override
            public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
                return EmptyIntSet.instance;
            }
        };
        if (options.getReflectionOptions().getNumFlowToCastIterations() > 0) {
            result = new DelegatingContextSelector(new FactoryContextSelector(), result);
        }
        if (!options.getReflectionOptions().isIgnoreStringConstants()) {
            result = new DelegatingContextSelector(new DelegatingContextSelector(new DelegatingContextSelector(new ClassFactoryContextSelector(), new GetClassContextSelector()), new ClassNewInstanceContextSelector()), result);
        }
        if (!options.getReflectionOptions().isIgnoreMethodInvoke()) {
            result = new DelegatingContextSelector(new ReflectiveInvocationSelector(), new DelegatingContextSelector(new JavaLangClassContextSelector(), result));
        }
        if (!options.getReflectionOptions().isIgnoreStringConstants() && !options.getReflectionOptions().isIgnoreMethodInvoke()) {
            result = new DelegatingContextSelector(new GetMethodContextSelector(options.getReflectionOptions().isApplicationClassesOnly()), result);
        }
        return result;
    }
}

