/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public abstract class PrimitiveType
extends TypeAbstraction {
    protected static final Map<TypeReference, PrimitiveType> referenceToType = HashMapFactory.make();
    protected final TypeReference reference;
    protected final int size;

    public static PrimitiveType getPrimitive(TypeReference reference) {
        return referenceToType.get(reference);
    }

    protected PrimitiveType(TypeReference reference, int size) {
        this.reference = reference;
        this.size = size;
        referenceToType.put(reference, this);
    }

    @Override
    public TypeAbstraction meet(TypeAbstraction rhs) {
        if (rhs == TOP) {
            return this;
        }
        if (rhs == this) {
            return this;
        }
        if (rhs instanceof PrimitiveType) {
            if (this.size() < ((PrimitiveType)rhs).size()) {
                return this;
            }
            return rhs;
        }
        return TOP;
    }

    public int size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        return this.reference.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public IClass getType() {
        return null;
    }

    @Override
    public TypeReference getTypeReference() {
        return this.reference;
    }

    public String toString() {
        return this.reference.getName().toString();
    }
}

