/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.shrikeCT.SourceFileReader;
import com.ibm.wala.shrikeCT.SourcePositionTableReader;
import com.ibm.wala.shrikeCT.TypeAnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.annotations.TypeAnnotation;
import com.ibm.wala.types.generics.MethodTypeSignature;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class ShrikeCTMethod
extends ShrikeBTMethod
implements IBytecodeMethod<IInstruction> {
    private final int shrikeMethodIndex;
    private int modifiers = -1;
    private final IClassHierarchy cha;
    private static final IndirectionData NO_INDIRECTIONS = new IndirectionData(){
        private final int[] NOTHING = new int[0];

        public int[] indirectlyReadLocals(int instructionIndex) {
            return this.NOTHING;
        }

        public int[] indirectlyWrittenLocals(int instructionIndex) {
            return this.NOTHING;
        }
    };

    public ShrikeCTMethod(IClass klass, int index) {
        super(klass);
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        this.shrikeMethodIndex = index;
        this.cha = klass.getClassHierarchy();
    }

    @Override
    public byte[] getBytecodes() {
        CodeReader code = this.getCodeReader();
        if (code == null) {
            return null;
        }
        return code.getBytecode();
    }

    @Override
    protected String getMethodName() throws InvalidClassFileException {
        ClassReader reader = this.getClassReader();
        return reader.getMethodName(this.shrikeMethodIndex);
    }

    @Override
    protected String getMethodSignature() throws InvalidClassFileException {
        ClassReader reader = this.getClassReader();
        return reader.getMethodType(this.shrikeMethodIndex);
    }

    @Override
    protected int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.getClassReader().getMethodAccessFlags(this.shrikeMethodIndex);
        }
        return this.modifiers;
    }

    @Override
    protected Decoder makeDecoder() {
        CodeReader reader = this.getCodeReader();
        if (reader == null) {
            return null;
        }
        CTDecoder d = new CTDecoder(reader);
        try {
            d.decode();
        }
        catch (Decoder.InvalidBytecodeException ex) {
            Assertions.UNREACHABLE();
        }
        return d;
    }

    @Override
    public int getMaxLocals() {
        CodeReader reader = this.getCodeReader();
        return reader.getMaxLocals();
    }

    @Override
    public int getMaxStackHeight() {
        CodeReader reader = this.getCodeReader();
        return reader.getMaxStack() + 2;
    }

    @Override
    public boolean hasExceptionHandler() {
        CodeReader reader = this.getCodeReader();
        if (reader == null) {
            return false;
        }
        int[] handlers = reader.getRawHandlers();
        return handlers != null && handlers.length > 0;
    }

    @Override
    protected String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException {
        ExceptionsReader reader = this.getExceptionReader();
        if (reader == null) {
            return null;
        }
        return reader.getClasses();
    }

    @Override
    protected void processDebugInfo(ShrikeBTMethod.BytecodeInfo bcInfo) throws InvalidClassFileException {
        CodeReader cr = this.getCodeReader();
        bcInfo.lineNumberMap = LineNumberTableReader.makeBytecodeToSourceMap((CodeReader)cr);
        bcInfo.localVariableMap = LocalVariableTableReader.makeVarMap((CodeReader)cr);
        SourcePositionTableReader.Position param = null;
        try {
            param = SourcePositionTableReader.findParameterPosition((int)this.shrikeMethodIndex, (CodeReader)cr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bcInfo.paramPositionMap = new SPos[this.getNumberOfParameters()];
        if (param != null) {
            String fileName = ((ShrikeClass)this.getDeclaringClass()).getSourceFileReader().getSourceFile();
            SPos paramPos = new SPos(fileName, param.firstLine, param.lastLine, param.firstCol, param.lastCol);
            for (int i = 0; i < this.getNumberOfParameters(); ++i) {
                bcInfo.paramPositionMap[i] = paramPos;
            }
        }
        SourcePositionTableReader.Position[] pos = null;
        try {
            pos = SourcePositionTableReader.makeBytecodeToPositionMap((CodeReader)cr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pos == null && bcInfo.lineNumberMap != null) {
            pos = SourcePositionTableReader.makeLineNumberToPositionMap((int[])bcInfo.lineNumberMap);
        }
        if (pos != null) {
            String sourceFile = null;
            SourceFileReader reader = ((ShrikeClass)this.getDeclaringClass()).getSourceFileReader();
            if (reader != null) {
                sourceFile = reader.getSourceFile();
            }
            bcInfo.positionMap = new SPos[pos.length];
            for (int i = 0; i < pos.length; ++i) {
                SourcePositionTableReader.Position p = pos[i];
                bcInfo.positionMap[i] = new SPos(sourceFile, p.firstLine, p.lastLine, p.firstCol, p.lastCol);
            }
        }
    }

    @Override
    public String getLocalVariableName(int bcIndex, int localNumber) {
        int[][] map = null;
        try {
            map = this.getBCInfo().localVariableMap;
        }
        catch (InvalidClassFileException e1) {
            return null;
        }
        if (localNumber > this.getMaxLocals()) {
            throw new IllegalArgumentException("illegal local number: " + localNumber + ", method " + this.getDeclaringClass().getName() + '.' + this.getName() + " uses at most " + this.getMaxLocals());
        }
        if (map == null) {
            return null;
        }
        int[] localPairs = map[bcIndex];
        int localIndex = localNumber * 2;
        if (localPairs == null || localIndex >= localPairs.length) {
            return null;
        }
        int nameIndex = localPairs[localIndex];
        if (nameIndex == 0) {
            return null;
        }
        try {
            return this.getClassReader().getCP().getCPUtf8(nameIndex);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public boolean hasLocalVariableTable() {
        try {
            ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
            this.getCodeReader().initAttributeIterator(iter);
            while (iter.isValid()) {
                if (iter.getName().equals("LocalVariableTable")) {
                    return true;
                }
                iter.advance();
            }
            return false;
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    private ClassReader getClassReader() {
        return ((ShrikeClass)this.getDeclaringClass()).getReader();
    }

    private <T> T getReader(String attrName, ShrikeClass.GetReader<T> reader) {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        return ShrikeClass.getReader(iter, attrName, reader);
    }

    private CodeReader getCodeReader() {
        return this.getReader("Code", CodeReader::new);
    }

    private ExceptionsReader getExceptionReader() {
        return this.getReader("Exceptions", ExceptionsReader::new);
    }

    private SignatureReader getSignatureReader() {
        return this.getReader("Signature", SignatureReader::new);
    }

    private AnnotationsReader getAnnotationsReader(AnnotationsReader.AnnotationType type) {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        return AnnotationsReader.getReaderForAnnotation((AnnotationsReader.AnnotationType)type, (ClassReader.AttrIterator)iter);
    }

    private TypeAnnotationsReader getTypeAnnotationsReaderAtMethodInfo(TypeAnnotationsReader.AnnotationType type) {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        return TypeAnnotationsReader.getReaderForAnnotationAtMethodInfo((TypeAnnotationsReader.AnnotationType)type, (ClassReader.AttrIterator)iter, (ExceptionsReader)this.getExceptionReader(), (SignatureReader)this.getSignatureReader());
    }

    private TypeAnnotationsReader getTypeAnnotationsReaderAtCode(TypeAnnotationsReader.AnnotationType type) {
        CodeReader codeReader = this.getCodeReader();
        if (codeReader == null) {
            return null;
        }
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        codeReader.initAttributeIterator(iter);
        return TypeAnnotationsReader.getReaderForAnnotationAtCode((TypeAnnotationsReader.AnnotationType)type, (ClassReader.AttrIterator)iter, (CodeReader)this.getCodeReader());
    }

    private String computeGenericsSignature() throws InvalidClassFileException {
        SignatureReader reader = this.getSignatureReader();
        if (reader == null) {
            return null;
        }
        return reader.getSignature();
    }

    @Override
    public TypeReference getReturnType() {
        return this.getReference().getReturnType();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private String getGenericsSignature() throws InvalidClassFileException {
        return this.computeGenericsSignature();
    }

    public MethodTypeSignature getMethodTypeSignature() throws InvalidClassFileException {
        String sig = this.getGenericsSignature();
        return sig == null ? null : MethodTypeSignature.make(sig);
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(false);
    }

    @Override
    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) throws InvalidClassFileException {
        AnnotationsReader r = this.getAnnotationsReader(runtimeInvisible ? AnnotationsReader.AnnotationType.RuntimeInvisibleAnnotations : AnnotationsReader.AnnotationType.RuntimeVisibleAnnotations);
        return Annotation.getAnnotationsFromReader(r, this.getDeclaringClass().getClassLoader().getReference());
    }

    public Collection<TypeAnnotation> getTypeAnnotationsAtMethodInfo(boolean runtimeInvisible) throws InvalidClassFileException {
        TypeAnnotationsReader r = this.getTypeAnnotationsReaderAtMethodInfo(runtimeInvisible ? TypeAnnotationsReader.AnnotationType.RuntimeInvisibleTypeAnnotations : TypeAnnotationsReader.AnnotationType.RuntimeVisibleTypeAnnotations);
        ClassLoaderReference clRef = this.getDeclaringClass().getClassLoader().getReference();
        return TypeAnnotation.getTypeAnnotationsFromReader(r, TypeAnnotation.targetConverterAtMethodInfo(clRef), clRef);
    }

    public Collection<TypeAnnotation> getTypeAnnotationsAtCode(boolean runtimeInvisible) throws InvalidClassFileException {
        TypeAnnotationsReader r = this.getTypeAnnotationsReaderAtCode(runtimeInvisible ? TypeAnnotationsReader.AnnotationType.RuntimeInvisibleTypeAnnotations : TypeAnnotationsReader.AnnotationType.RuntimeVisibleTypeAnnotations);
        ClassLoaderReference clRef = this.getDeclaringClass().getClassLoader().getReference();
        return TypeAnnotation.getTypeAnnotationsFromReader(r, TypeAnnotation.targetConverterAtCode(clRef, this), clRef);
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        HashSet result = HashSetFactory.make();
        try {
            result.addAll(this.getAnnotations(true));
            result.addAll(this.getAnnotations(false));
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Collection<Annotation>[] getParameterAnnotations() {
        int numAnnotatedParams = this.isStatic() ? this.getNumberOfParameters() : this.getNumberOfParameters() - 1;
        Collection[] result = new Collection[numAnnotatedParams];
        Arrays.setAll(result, i -> HashSetFactory.make());
        try {
            int i2;
            ClassLoaderReference reference = this.getDeclaringClass().getClassLoader().getReference();
            AnnotationsReader r = this.getAnnotationsReader(AnnotationsReader.AnnotationType.RuntimeInvisibleParameterAnnotations);
            Collection<Annotation>[] paramAnnots = Annotation.getParameterAnnotationsFromReader(r, reference);
            if (paramAnnots != null) {
                assert (paramAnnots.length == result.length) : paramAnnots.length + " != " + result.length;
                for (i2 = 0; i2 < result.length; ++i2) {
                    result[i2].addAll(paramAnnots[i2]);
                }
            }
            if ((paramAnnots = Annotation.getParameterAnnotationsFromReader(r = this.getAnnotationsReader(AnnotationsReader.AnnotationType.RuntimeVisibleParameterAnnotations), reference)) != null) {
                assert (paramAnnots.length == result.length);
                for (i2 = 0; i2 < result.length; ++i2) {
                    result[i2].addAll(paramAnnots[i2]);
                }
            }
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public IndirectionData getIndirectionData() {
        return NO_INDIRECTIONS;
    }

    private static final class SPos
    implements IMethod.SourcePosition {
        String fileName;
        final int firstLine;
        final int lastLine;
        final int firstCol;
        final int lastCol;

        private SPos(String fileName, int firstLine, int lastLine, int firstCol, int lastCol) {
            this.firstLine = firstLine;
            this.lastLine = lastLine;
            this.firstCol = firstCol;
            this.lastCol = lastCol;
            this.fileName = fileName;
        }

        @Override
        public int getFirstCol() {
            return this.firstCol;
        }

        @Override
        public int getFirstLine() {
            return this.firstLine;
        }

        @Override
        public int getFirstOffset() {
            return 0;
        }

        @Override
        public int getLastCol() {
            return this.lastCol;
        }

        @Override
        public int getLastLine() {
            return this.lastLine;
        }

        @Override
        public int getLastOffset() {
            return 0;
        }

        @Override
        public int compareTo(IMethod.SourcePosition p) {
            if (p != null) {
                if (this.firstLine != p.getFirstLine()) {
                    return this.firstLine - p.getFirstLine();
                }
                if (this.firstCol != p.getFirstCol()) {
                    return this.firstCol - p.getFirstCol();
                }
                if (this.lastLine != p.getLastLine()) {
                    return this.lastLine - p.getLastLine();
                }
                if (this.lastCol != p.getLastCol()) {
                    return this.lastCol - p.getLastCol();
                }
                return 0;
            }
            return -1;
        }

        public String toString() {
            return this.fileName + '(' + this.firstLine + ',' + this.firstCol + '-' + this.lastLine + ',' + this.lastCol + ')';
        }
    }
}

