/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.PointerKeyAndCallSite;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDemandFlowGraph
extends AbstractFlowGraph {
    private static final boolean DEBUG = false;
    private static int wipeCount = 0;
    final BitVectorIntSet cgNodesVisited = new BitVectorIntSet();
    final Map<CGNode, Set<CallerSiteContext>> callerCache = HashMapFactory.make();

    @Override
    public void addSubgraphForNode(CGNode node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        IR ir = node.getIR();
        if (ir == null) {
            throw new IllegalArgumentException("no ir for node " + node);
        }
        int n = this.cg.getNumber(node);
        if (!this.cgNodesVisited.contains(n)) {
            this.cgNodesVisited.add(n);
            this.unconditionallyAddConstraintsFromNode(node, ir);
            this.addNodesForInvocations(node, ir);
            this.addNodesForParameters(node, ir);
        }
    }

    @Override
    public boolean hasSubgraphForNode(CGNode node) {
        return this.cgNodesVisited.contains(this.cg.getNumber(node));
    }

    public Iterator<PointerKeyAndCallSite> getParamSuccs(LocalPointerKey pk) {
        CGNode cgNode = (CGNode)this.params.get(pk);
        if (cgNode == null) {
            return EmptyIterator.instance();
        }
        int paramPos = pk.getValueNumber() - 1;
        ArrayList<PointerKeyAndCallSite> paramSuccs = new ArrayList<PointerKeyAndCallSite>();
        Iterator iterator = this.cg.iterator();
        while (iterator.hasNext()) {
            CGNode caller = (CGNode)iterator.next();
            this.addSubgraphForNode(caller);
            IR ir = caller.getIR();
            for (CallSiteReference call : Iterator2Iterable.make(ir.iterateCallSites())) {
                SSAAbstractInvokeInstruction[] callInstrs;
                if (!this.cg.getPossibleTargets(caller, call).contains(cgNode)) continue;
                for (SSAAbstractInvokeInstruction callInstr : callInstrs = ir.getCalls(call)) {
                    PointerKey actualPk = this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                    assert (this.containsNode(actualPk));
                    assert (this.containsNode(pk));
                    paramSuccs.add(new PointerKeyAndCallSite(actualPk, call));
                }
            }
        }
        return paramSuccs.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getParamPreds(LocalPointerKey pk) {
        Set instrs = (Set)this.callParams.get(pk);
        if (instrs == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> paramPreds = new ArrayList<PointerKeyAndCallSite>();
        for (SSAAbstractInvokeInstruction callInstr : instrs) {
            for (int i = 0; i < callInstr.getNumberOfUses(); ++i) {
                if (pk.getValueNumber() != callInstr.getUse(i)) continue;
                CallSiteReference callSiteRef = callInstr.getCallSite();
                Set<CGNode> possibleCallees = this.cg.getPossibleTargets(pk.getNode(), callSiteRef);
                for (CGNode callee : possibleCallees) {
                    this.addSubgraphForNode(callee);
                    PointerKey paramVal = this.heapModel.getPointerKeyForLocal(callee, i + 1);
                    assert (this.containsNode(paramVal));
                    paramPreds.add(new PointerKeyAndCallSite(paramVal, callSiteRef));
                }
            }
        }
        return paramPreds.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getReturnSuccs(LocalPointerKey pk) {
        SSAAbstractInvokeInstruction callInstr = (SSAAbstractInvokeInstruction)this.callDefs.get(pk);
        if (callInstr == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> returnSuccs = new ArrayList<PointerKeyAndCallSite>();
        boolean isExceptional = pk.getValueNumber() == callInstr.getException();
        CallSiteReference callSiteRef = callInstr.getCallSite();
        Set<CGNode> possibleCallees = this.cg.getPossibleTargets(pk.getNode(), callSiteRef);
        for (CGNode callee : possibleCallees) {
            PointerKey retVal;
            this.addSubgraphForNode(callee);
            PointerKey pointerKey = retVal = isExceptional ? this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : this.heapModel.getPointerKeyForReturnValue(callee);
            assert (this.containsNode(retVal));
            returnSuccs.add(new PointerKeyAndCallSite(retVal, callSiteRef));
        }
        return returnSuccs.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getReturnPreds(LocalPointerKey pk) {
        CGNode cgNode = (CGNode)this.returns.get(pk);
        if (cgNode == null) {
            return EmptyIterator.instance();
        }
        boolean isExceptional = pk == this.heapModel.getPointerKeyForExceptionalReturnValue(cgNode);
        ArrayList<PointerKeyAndCallSite> returnPreds = new ArrayList<PointerKeyAndCallSite>();
        Iterator iterator = this.cg.iterator();
        while (iterator.hasNext()) {
            CGNode caller = (CGNode)iterator.next();
            this.addSubgraphForNode(caller);
            IR ir = caller.getIR();
            for (CallSiteReference call : Iterator2Iterable.make(ir.iterateCallSites())) {
                SSAAbstractInvokeInstruction[] callInstrs;
                if (!this.cg.getPossibleTargets(caller, call).contains(cgNode)) continue;
                for (SSAAbstractInvokeInstruction callInstr : callInstrs = ir.getCalls(call)) {
                    PointerKey returnPk = this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                    assert (this.containsNode(returnPk));
                    assert (this.containsNode(pk));
                    returnPreds.add(new PointerKeyAndCallSite(returnPk, call));
                }
            }
        }
        return returnPreds.iterator();
    }

    protected abstract void addNodesForParameters(CGNode var1, IR var2);

    protected void unconditionallyAddConstraintsFromNode(CGNode node, IR ir) {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        AbstractDemandFlowGraph.debugPrintIR(ir);
        if (ir == null) {
            return;
        }
        this.addNodeInstructionConstraints(node, ir);
        this.addNodePassthruExceptionConstraints(node, ir);
        this.addNodeConstantConstraints(node, ir);
    }

    protected void addNodeInstructionConstraints(CGNode node, IR ir) {
        FlowStatementVisitor v = this.makeVisitor(node);
        SSACFG cfg = ir.getControlFlowGraph();
        Iterator iterator = cfg.iterator();
        while (iterator.hasNext()) {
            ISSABasicBlock b = (ISSABasicBlock)iterator.next();
            this.addBlockInstructionConstraints(node, cfg, b, v);
        }
    }

    protected void addBlockInstructionConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock b, FlowStatementVisitor v) {
        v.setBasicBlock(b);
        for (SSAInstruction s : b) {
            if (s == null) continue;
            s.visit(v);
        }
        this.addPhiConstraints(node, cfg, b);
    }

    private void addPhiConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock b) {
        for (ISSABasicBlock sb : Iterator2Iterable.make((Iterator)cfg.getSuccNodes(b))) {
            ISSABasicBlock back;
            if (sb.isExitBlock()) continue;
            int n = 0;
            Iterator iterator = Iterator2Iterable.make((Iterator)cfg.getPredNodes(sb)).iterator();
            while (iterator.hasNext() && (back = (ISSABasicBlock)iterator.next()) != b) {
                ++n;
            }
            assert (n < cfg.getPredNodeCount(sb));
            for (SSAPhiInstruction phi : Iterator2Iterable.make(sb.iteratePhis())) {
                if (phi == null) continue;
                PointerKey def = this.heapModel.getPointerKeyForLocal(node, phi.getDef());
                if (phi.getUse(n) <= 0) continue;
                PointerKey use = this.heapModel.getPointerKeyForLocal(node, phi.getUse(n));
                this.addNode(def);
                this.addNode(use);
                this.addEdge(def, use, AssignLabel.noFilter());
            }
        }
    }

    protected abstract FlowStatementVisitor makeVisitor(CGNode var1);

    private static void debugPrintIR(IR ir) {
    }

    @Override
    public Set<CallerSiteContext> getPotentialCallers(PointerKey formalPk) {
        CGNode callee = null;
        if (formalPk instanceof LocalPointerKey) {
            callee = ((LocalPointerKey)formalPk).getNode();
        } else if (formalPk instanceof ReturnValueKey) {
            callee = ((ReturnValueKey)formalPk).getNode();
        } else {
            throw new IllegalArgumentException("formalPk must represent a local");
        }
        HashSet ret = this.callerCache.get(callee);
        if (ret == null) {
            ret = HashSetFactory.make();
            for (CGNode caller : Iterator2Iterable.make((Iterator)this.cg.getPredNodes(callee))) {
                for (CallSiteReference call : Iterator2Iterable.make(this.cg.getPossibleSites(caller, callee))) {
                    ret.add(new CallerSiteContext(caller, call));
                }
            }
            this.callerCache.put(callee, ret);
        }
        return ret;
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site, LocalPointerKey actualPk) {
        return this.cg.getPossibleTargets(node, site);
    }

    public AbstractDemandFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, IClassHierarchy cha) {
        super(mam, heapModel, cha, cg);
    }

    protected static interface FlowStatementVisitor
    extends SSAInstruction.IVisitor {
        public void setBasicBlock(ISSABasicBlock var1);
    }
}

