/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACache;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.ref.ReferenceCleanser;

public class AnalysisCache
implements IAnalysisCacheView {
    private final IRFactory<IMethod> irFactory;
    private final SSACache ssaCache;
    private final SSAOptions ssaOptions;

    public AnalysisCache(IRFactory<IMethod> irFactory, SSAOptions ssaOptions, SSACache cache) {
        this.ssaOptions = ssaOptions;
        this.irFactory = irFactory;
        this.ssaCache = cache;
        ReferenceCleanser.registerCache(this);
    }

    @Override
    public void invalidate(IMethod method, Context C) {
        this.ssaCache.invalidate(method, C);
    }

    public SSACache getSSACache() {
        return this.ssaCache;
    }

    public SSAOptions getSSAOptions() {
        return this.ssaOptions;
    }

    @Override
    public IRFactory<IMethod> getIRFactory() {
        return this.irFactory;
    }

    @Override
    public IR getIR(IMethod method, Context context) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        return this.ssaCache.findOrCreateIR(method, context, this.ssaOptions);
    }

    @Override
    public IR getIR(IMethod m) {
        return this.getIR(m, Everywhere.EVERYWHERE);
    }

    @Override
    public DefUse getDefUse(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        return this.ssaCache.findOrCreateDU(ir, Everywhere.EVERYWHERE);
    }

    @Override
    public void clear() {
        this.ssaCache.wipe();
    }
}

