/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.ArgumentTypeEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.HashSet;

public class AllApplicationEntrypoints
extends HashSet<Entrypoint> {
    private static final long serialVersionUID = 6541081454519490199L;
    private static final boolean DEBUG = false;

    public AllApplicationEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        for (IClass klass : cha) {
            if (klass.isInterface() || !AllApplicationEntrypoints.isApplicationClass(scope, klass)) continue;
            for (IMethod iMethod : klass.getDeclaredMethods()) {
                if (iMethod.isAbstract()) continue;
                this.add(new ArgumentTypeEntrypoint(iMethod, cha));
            }
        }
    }

    private static boolean isApplicationClass(AnalysisScope scope, IClass klass) {
        return scope.getApplicationLoader().equals(klass.getClassLoader().getReference());
    }
}

