/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.BasicCallGraph;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.IntFunction;

public class ExplicitCallGraph
extends BasicCallGraph<SSAContextInterpreter>
implements BytecodeConstants {
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final IAnalysisCacheView cache;
    private final long maxNumberOfNodes;
    private final IMethod fakeRootMethod;
    private final ExplicitEdgeManager edgeManager = this.makeEdgeManger();

    public ExplicitCallGraph(IMethod fakeRootMethod, AnalysisOptions options, IAnalysisCacheView cache) {
        if (options == null) {
            throw new IllegalArgumentException("null options");
        }
        if (cache == null) {
            throw new IllegalArgumentException("null cache");
        }
        this.cha = fakeRootMethod.getClassHierarchy();
        this.options = options;
        this.cache = cache;
        this.maxNumberOfNodes = options.getMaxNumberOfNodes();
        this.fakeRootMethod = fakeRootMethod;
    }

    protected ExplicitNode makeNode(IMethod method, Context context) {
        return new ExplicitNode(method, context);
    }

    @Override
    protected CGNode makeFakeRootNode() throws CancelException {
        return this.findOrCreateNode(this.fakeRootMethod, Everywhere.EVERYWHERE);
    }

    @Override
    protected CGNode makeFakeWorldClinitNode() throws CancelException {
        return this.findOrCreateNode(new FakeWorldClinitMethod(this.fakeRootMethod.getDeclaringClass(), this.options, this.cache), Everywhere.EVERYWHERE);
    }

    @Override
    public CGNode findOrCreateNode(IMethod method, Context context) throws CancelException {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        BasicCallGraph.Key k = new BasicCallGraph.Key(method, context);
        CGNode result = this.getNode(k);
        if (result == null) {
            if (this.maxNumberOfNodes == -1L || (long)this.getNumberOfNodes() < this.maxNumberOfNodes) {
                result = this.makeNode(method, context);
                this.registerNode(k, result);
            } else {
                throw CancelException.make((String)"Too many nodes");
            }
        }
        return result;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public NumberedEdgeManager<CGNode> getEdgeManager() {
        return this.edgeManager;
    }

    protected ExplicitEdgeManager makeEdgeManger() {
        return new ExplicitEdgeManager();
    }

    @Override
    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getNumberOfTargets(site);
    }

    @Override
    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        if (!this.containsNode(src)) {
            throw new IllegalArgumentException("node not in callgraph " + src);
        }
        if (!this.containsNode(target)) {
            throw new IllegalArgumentException("node not in callgraph " + target);
        }
        assert (src instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)src;
        return n.getPossibleSites(target);
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getPossibleTargets(site);
    }

    public IntSet getPossibleTargetNumbers(CGNode node, CallSiteReference site) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("node not in callgraph " + node + " Site: " + site);
        }
        assert (node instanceof ExplicitNode);
        ExplicitNode n = (ExplicitNode)node;
        return n.getPossibleTargetNumbers(site);
    }

    public IAnalysisCacheView getAnalysisCache() {
        return this.cache;
    }

    protected class ExplicitEdgeManager
    implements NumberedEdgeManager<CGNode> {
        final IntFunction<CGNode> toNode = i -> {
            CGNode result = (CGNode)ExplicitCallGraph.this.getNode(i);
            return result;
        };
        final IBinaryNaturalRelation predecessors = new BasicNaturalRelation(new byte[]{2}, 0);

        protected ExplicitEdgeManager() {
        }

        public IntSet getSuccNodeNumbers(CGNode node) {
            ExplicitNode n = (ExplicitNode)node;
            return n.getAllTargetNumbers();
        }

        public IntSet getPredNodeNumbers(CGNode node) {
            ExplicitNode n = (ExplicitNode)node;
            int y = ExplicitCallGraph.this.getNumber(n);
            return this.predecessors.getRelated(y);
        }

        public Iterator<CGNode> getPredNodes(CGNode N) {
            IntSet s = this.getPredNodeNumbers(N);
            if (s == null) {
                return EmptyIterator.instance();
            }
            return new IntMapIterator(s.intIterator(), this.toNode);
        }

        public int getPredNodeCount(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            int y = ExplicitCallGraph.this.getNumber(n);
            return this.predecessors.getRelatedCount(y);
        }

        public Iterator<CGNode> getSuccNodes(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            return new IntMapIterator(n.getAllTargetNumbers().intIterator(), this.toNode);
        }

        public int getSuccNodeCount(CGNode N) {
            ExplicitNode n = (ExplicitNode)N;
            return n.getAllTargetNumbers().size();
        }

        public void addEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            this.predecessors.add(y, x);
        }

        public void removeEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            this.predecessors.remove(y, x);
        }

        protected void addEdge(int x, int y) {
            this.predecessors.add(y, x);
        }

        public void removeAllIncidentEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        public void removeIncomingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        public void removeOutgoingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        public boolean hasEdge(CGNode src, CGNode dst) {
            int x = ExplicitCallGraph.this.getNumber(src);
            int y = ExplicitCallGraph.this.getNumber(dst);
            return this.predecessors.contains(y, x);
        }
    }

    public class ExplicitNode
    extends BasicCallGraph.NodeImpl {
        protected final SparseVector<Object> targets;
        private final MutableSharedBitVectorIntSet allTargets;
        private WeakReference<IR> ir;
        private WeakReference<DefUse> du;

        protected ExplicitNode(IMethod method, Context C) {
            super(method, C);
            this.targets = new SparseVector();
            this.allTargets = new MutableSharedBitVectorIntSet();
            this.ir = new WeakReference<Object>(null);
            this.du = new WeakReference<Object>(null);
        }

        protected Set<CGNode> getPossibleTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result == null) {
                return Collections.emptySet();
            }
            if (result instanceof CGNode) {
                Set<CGNode> s = Collections.singleton((CGNode)result);
                return s;
            }
            IntSet s = (IntSet)result;
            HashSet h = HashSetFactory.make((int)s.size());
            IntIterator it = s.intIterator();
            while (it.hasNext()) {
                h.add(this.getCallGraph().getNode(it.next()));
            }
            return h;
        }

        protected IntSet getPossibleTargetNumbers(CallSiteReference site) {
            Object t = this.targets.get(site.getProgramCounter());
            if (t == null) {
                return null;
            }
            if (t instanceof CGNode) {
                return SparseIntSet.singleton((int)this.getCallGraph().getNumber((CGNode)t));
            }
            return (IntSet)t;
        }

        protected Iterator<CallSiteReference> getPossibleSites(CGNode to) {
            int n = this.getCallGraph().getNumber(to);
            return new FilterIterator(this.iterateCallSites(), o -> {
                IntSet s = this.getPossibleTargetNumbers((CallSiteReference)o);
                return s == null ? false : s.contains(n);
            });
        }

        protected int getNumberOfTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result == null) {
                return 0;
            }
            if (result instanceof CGNode) {
                return 1;
            }
            return ((IntSet)result).size();
        }

        @Override
        public boolean addTarget(CallSiteReference site, CGNode tNode) {
            return this.addTarget(site.getProgramCounter(), tNode);
        }

        protected boolean addTarget(int pc, CGNode tNode) {
            this.allTargets.add(this.getCallGraph().getNumber(tNode));
            Object S = this.targets.get(pc);
            if (S == null) {
                S = tNode;
                this.targets.set(pc, S);
                this.getCallGraph().addEdge(this, tNode);
                return true;
            }
            if (S instanceof CGNode) {
                if (S.equals(tNode)) {
                    return false;
                }
                MutableSharedBitVectorIntSet s = new MutableSharedBitVectorIntSet();
                s.add(this.getCallGraph().getNumber((CGNode)S));
                s.add(this.getCallGraph().getNumber(tNode));
                this.getCallGraph().addEdge(this, tNode);
                this.targets.set(pc, (Object)s);
                return true;
            }
            MutableIntSet s = (MutableIntSet)S;
            int n = this.getCallGraph().getNumber(tNode);
            if (!s.contains(n)) {
                s.add(n);
                this.getCallGraph().addEdge(this, tNode);
                return true;
            }
            return false;
        }

        public void removeTarget(CGNode target) {
            this.allTargets.remove(this.getCallGraph().getNumber(target));
            IntIterator it = this.targets.safeIterateIndices();
            while (it.hasNext()) {
                int pc = it.next();
                Object value = this.targets.get(pc);
                if (value instanceof CGNode) {
                    if (!value.equals(target)) continue;
                    this.targets.remove(pc);
                    continue;
                }
                MutableIntSet s = (MutableIntSet)value;
                int n = this.getCallGraph().getNumber(target);
                if (s.size() > 2) {
                    s.remove(n);
                    continue;
                }
                assert (s.size() == 2);
                if (!s.contains(n)) continue;
                s.remove(n);
                int i = s.intIterator().next();
                this.targets.set(pc, this.getCallGraph().getNode(i));
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return this.getMethod().hashCode() * 8681 + this.getContext().hashCode();
        }

        protected MutableSharedBitVectorIntSet getAllTargetNumbers() {
            return this.allTargets;
        }

        public void clearAllTargets() {
            this.targets.clear();
            this.allTargets.clear();
        }

        @Override
        public IR getIR() {
            if (this.getMethod().isWalaSynthetic()) {
                return ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).getIR(this);
            }
            IR ir = (IR)this.ir.get();
            if (ir == null) {
                ir = ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).getIR(this);
                this.ir = new WeakReference<IR>(ir);
            }
            return ir;
        }

        @Override
        public DefUse getDU() {
            if (this.getMethod().isWalaSynthetic()) {
                return ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).getDU(this);
            }
            DefUse du = (DefUse)this.du.get();
            if (du == null) {
                du = ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).getDU(this);
                this.du = new WeakReference<DefUse>(du);
            }
            return du;
        }

        public ExplicitCallGraph getCallGraph() {
            return ExplicitCallGraph.this;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites() {
            return ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).iterateCallSites(this);
        }

        @Override
        public Iterator<NewSiteReference> iterateNewSites() {
            return ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).iterateNewSites(this);
        }

        public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG() {
            return ((SSAContextInterpreter)this.getCallGraph().getInterpreter(this)).getCFG(this);
        }
    }
}

