/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.Worklist;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.fixpoint.UnaryStatement;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AssignEquation;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysisImpl;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToMap;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationGraph;
import com.ibm.wala.ipa.callgraph.propagation.UnarySideEffect;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.VerboseAction;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropagationSystem
extends DefaultFixedPointSolver<PointsToSetVariable> {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MEMORY = false;
    private static int DEBUG_MEM_COUNTER = 0;
    private static final int DEBUG_MEM_INTERVAL = 5;
    protected final PointsToMap pointsToMap = new PointsToMap();
    private final PropagationGraph flowGraph = new PropagationGraph();
    protected final MutableMapping<InstanceKey> instanceKeys = MutableMapping.make();
    private final Map<IClass, MutableIntSet> class2InstanceKey = HashMapFactory.make();
    private PointerAnalysis<InstanceKey> pointerAnalysis;
    private final PointerKeyFactory pointerKeyFactory;
    private final InstanceKeyFactory instanceKeyFactory;
    private final Map<PointsToSetVariable, Set<UnarySideEffect>> fixedSetMap = HashMapFactory.make();
    protected final CallGraph cg;
    private int verboseInterval = 100000;
    private int periodicMaintainInterval = 100000;

    public PropagationSystem(CallGraph cg, PointerKeyFactory pointerKeyFactory, InstanceKeyFactory instanceKeyFactory) {
        if (cg == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cg = cg;
        this.pointerKeyFactory = pointerKeyFactory;
        this.instanceKeyFactory = instanceKeyFactory;
    }

    public PointerAnalysis<InstanceKey> makePointerAnalysis(PropagationCallGraphBuilder builder) {
        return new PointerAnalysisImpl(builder, this.cg, this.pointsToMap, this.instanceKeys, this.pointerKeyFactory, this.instanceKeyFactory);
    }

    protected void registerFixedSet(PointsToSetVariable p, UnarySideEffect s) {
        Set set = MapUtil.findOrCreateSet(this.fixedSetMap, (Object)((Object)p));
        set.add(s);
    }

    protected void updateSideEffects(PointsToSetVariable p, PointsToSetVariable rep) {
        Set<UnarySideEffect> set = this.fixedSetMap.get((Object)p);
        if (set != null) {
            for (UnarySideEffect s : set) {
                s.replaceFixedSet(rep);
            }
            Set s2 = MapUtil.findOrCreateSet(this.fixedSetMap, (Object)((Object)rep));
            s2.addAll(set);
            this.fixedSetMap.remove((Object)p);
        }
    }

    private MutableIntSet findOrCreateSparseSetForClass(IClass klass) {
        assert (klass.getReference() != TypeReference.JavaLangObject);
        MutableIntSet result = this.class2InstanceKey.get(klass);
        if (result == null) {
            result = IntSetUtil.getDefaultIntSetFactory().make();
            this.class2InstanceKey.put(klass, result);
        }
        return result;
    }

    MutableIntSet cloneInstanceKeysForClass(IClass klass) {
        assert (klass.getReference() != TypeReference.JavaLangObject);
        MutableIntSet set = this.class2InstanceKey.get(klass);
        if (set == null) {
            return IntSetUtil.getDefaultIntSetFactory().make();
        }
        return IntSetUtil.getDefaultIntSetFactory().makeCopy((IntSet)set);
    }

    public IntSet getInstanceKeysForClass(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        assert (klass != klass.getClassHierarchy().getRootClass());
        return (IntSet)this.class2InstanceKey.get(klass);
    }

    public InstanceKey getInstanceKey(int i) {
        return (InstanceKey)this.instanceKeys.getMappedObject(i);
    }

    public int getInstanceIndex(InstanceKey ik) {
        return this.instanceKeys.getMappedIndex((Object)ik);
    }

    List<InstanceKey> getInstances(IntSet set) {
        LinkedList<InstanceKey> result = new LinkedList<InstanceKey>();
        IntIterator it = set.intIterator();
        while (it.hasNext()) {
            int j = it.next();
            result.add(this.getInstanceKey(j));
        }
        return result;
    }

    protected void initializeVariables() {
    }

    public void recordImplicitPointsToSet(PointerKey key) {
        LocalPointerKey lpk;
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (key instanceof LocalPointerKey && (lpk = (LocalPointerKey)key).isParameter()) {
            System.err.println("------------------ ERROR:");
            System.err.println("LocalPointerKey: " + lpk);
            System.err.println("Constant? " + lpk.getNode().getIR().getSymbolTable().isConstant(lpk.getValueNumber()));
            System.err.println("   -- IR:");
            System.err.println(lpk.getNode().getIR());
            Assertions.UNREACHABLE((String)"How can parameter be implicit?");
        }
        this.pointsToMap.recordImplicit(key);
    }

    public PointsToSetVariable findOrCreatePointsToSet(PointerKey key) {
        PointsToSetVariable result;
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (this.pointsToMap.isImplicit(key)) {
            System.err.println("Did not expect to findOrCreatePointsToSet for implicitly represented PointerKey");
            System.err.println(key);
            Assertions.UNREACHABLE();
        }
        if ((result = this.pointsToMap.getPointsToSet(key)) == null) {
            result = new PointsToSetVariable(key);
            this.pointsToMap.put(key, result);
        } else if (!this.pointsToMap.isUnified(key) && key instanceof FilteredPointerKey) {
            PointerKey pk = result.getPointerKey();
            if (!(pk instanceof FilteredPointerKey)) {
                result.setPointerKey(key);
                pk = key;
            }
            FilteredPointerKey fpk = (FilteredPointerKey)pk;
            assert (fpk != null);
            assert (key != null);
            if (fpk.getTypeFilter() == null) {
                Assertions.UNREACHABLE((String)"fpk.getTypeFilter() is null");
            }
            if (!fpk.getTypeFilter().equals(((FilteredPointerKey)key).getTypeFilter())) {
                Assertions.UNREACHABLE((String)("Cannot use filter " + ((FilteredPointerKey)key).getTypeFilter() + " for " + key + ": previously created different filter " + fpk.getTypeFilter()));
            }
        }
        return result;
    }

    public int findOrCreateIndexForInstanceKey(InstanceKey key) {
        int result = this.instanceKeys.getMappedIndex((Object)key);
        if (result == -1) {
            result = this.instanceKeys.add((Object)key);
        }
        return result;
    }

    public boolean newConstraint(PointerKey lhs, UnaryOperator<PointsToSetVariable> op, PointerKey rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("null lhs");
        }
        if (op == null) {
            throw new IllegalArgumentException("op null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs null");
        }
        PointsToSetVariable L = this.findOrCreatePointsToSet(lhs);
        PointsToSetVariable R = this.findOrCreatePointsToSet(rhs);
        if (op instanceof PropagationCallGraphBuilder.FilterOperator) {
            this.pointsToMap.recordTransitiveRoot(L.getPointerKey());
            if (!(L.getPointerKey() instanceof FilteredPointerKey)) {
                Assertions.UNREACHABLE((String)("expected filtered lhs " + L.getPointerKey() + ' ' + L.getPointerKey().getClass() + ' ' + lhs + ' ' + lhs.getClass()));
            }
        }
        return this.newStatement((IVariable)L, op, (IVariable)R, true, true);
    }

    public boolean newConstraint(PointerKey lhs, AbstractOperator<PointsToSetVariable> op, PointerKey rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("lhs null");
        }
        if (op == null) {
            throw new IllegalArgumentException("op null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs null");
        }
        assert (!this.pointsToMap.isUnified(lhs));
        assert (!this.pointsToMap.isUnified(rhs));
        PointsToSetVariable L = this.findOrCreatePointsToSet(lhs);
        PointsToSetVariable R = this.findOrCreatePointsToSet(rhs);
        return this.newStatement((IVariable)L, op, (IVariable[])new PointsToSetVariable[]{R}, true, true);
    }

    public boolean newConstraint(PointerKey lhs, AbstractOperator<PointsToSetVariable> op, PointerKey rhs1, PointerKey rhs2) {
        if (lhs == null) {
            throw new IllegalArgumentException("null lhs");
        }
        if (op == null) {
            throw new IllegalArgumentException("null op");
        }
        if (rhs1 == null) {
            throw new IllegalArgumentException("null rhs1");
        }
        if (rhs2 == null) {
            throw new IllegalArgumentException("null rhs2");
        }
        assert (!this.pointsToMap.isUnified(lhs));
        assert (!this.pointsToMap.isUnified(rhs1));
        assert (!this.pointsToMap.isUnified(rhs2));
        PointsToSetVariable L = this.findOrCreatePointsToSet(lhs);
        PointsToSetVariable R1 = this.findOrCreatePointsToSet(rhs1);
        PointsToSetVariable R2 = this.findOrCreatePointsToSet(rhs2);
        return this.newStatement((IVariable)L, op, (IVariable)R1, (IVariable)R2, true, true);
    }

    public boolean newFieldWrite(PointerKey lhs, UnaryOperator<PointsToSetVariable> op, PointerKey rhs) {
        return this.newConstraint(lhs, op, rhs);
    }

    public boolean newFieldRead(PointerKey lhs, UnaryOperator<PointsToSetVariable> op, PointerKey rhs) {
        return this.newConstraint(lhs, op, rhs);
    }

    public boolean newConstraint(PointerKey lhs, InstanceKey value) {
        this.pointsToMap.recordTransitiveRoot(lhs);
        PointsToSetVariable L = this.findOrCreatePointsToSet(lhs);
        int index = this.findOrCreateIndexForInstanceKey(value);
        if (!L.add(index)) {
            return false;
        }
        assert (value.getConcreteType() != null);
        if (!value.getConcreteType().getReference().equals(TypeReference.JavaLangObject)) {
            this.registerInstanceOfClass(value.getConcreteType(), index);
        }
        if (L.getGraphNodeId() > -1) {
            this.changedVariable((IVariable)L);
        }
        return true;
    }

    private void registerInstanceOfClass(IClass klass, int index) {
        assert (!klass.getReference().equals(TypeReference.JavaLangObject));
        IClass T = klass;
        this.registerInstanceWithAllSuperclasses(index, T);
        this.registerInstanceWithAllInterfaces(klass, index);
        if (klass.isArrayClass()) {
            ArrayClass aClass = (ArrayClass)klass;
            int dim = aClass.getDimensionality();
            this.registerMultiDimArraysForArrayOfObjectTypes(dim, index, aClass);
            IClass elementClass = aClass.getInnermostElementClass();
            if (elementClass != null) {
                this.registerArrayInstanceWithAllSuperclassesOfElement(index, elementClass, dim);
                this.registerArrayInstanceWithAllInterfacesOfElement(index, elementClass, dim);
            }
        }
    }

    private int registerMultiDimArraysForArrayOfObjectTypes(int dim, int index, ArrayClass aClass) {
        for (int i = 1; i < dim; ++i) {
            TypeReference jlo = PropagationSystem.makeArray(TypeReference.JavaLangObject, i);
            IClass jloClass = null;
            jloClass = aClass.getClassLoader().lookupClass(jlo.getName());
            MutableIntSet set = this.findOrCreateSparseSetForClass(jloClass);
            set.add(index);
        }
        return dim;
    }

    private void registerArrayInstanceWithAllInterfacesOfElement(int index, IClass elementClass, int dim) {
        Collection<IClass> ifaces = null;
        ifaces = elementClass.getAllImplementedInterfaces();
        for (IClass I : ifaces) {
            TypeReference iArrayRef = PropagationSystem.makeArray(I.getReference(), dim);
            IClass iArrayClass = null;
            iArrayClass = I.getClassLoader().lookupClass(iArrayRef.getName());
            MutableIntSet set = this.findOrCreateSparseSetForClass(iArrayClass);
            set.add(index);
        }
    }

    private static TypeReference makeArray(TypeReference element, int dim) {
        TypeReference iArrayRef = element;
        for (int i = 0; i < dim; ++i) {
            iArrayRef = TypeReference.findOrCreateArrayOf(iArrayRef);
        }
        return iArrayRef;
    }

    private void registerArrayInstanceWithAllSuperclassesOfElement(int index, IClass elementClass, int dim) {
        for (IClass T = elementClass.getSuperclass(); T != null; T = T.getSuperclass()) {
            TypeReference tArrayRef = PropagationSystem.makeArray(T.getReference(), dim);
            IClass tArrayClass = null;
            tArrayClass = T.getClassLoader().lookupClass(tArrayRef.getName());
            MutableIntSet set = this.findOrCreateSparseSetForClass(tArrayClass);
            set.add(index);
        }
    }

    private void registerInstanceWithAllInterfaces(IClass klass, int index) {
        Collection<IClass> ifaces = klass.getAllImplementedInterfaces();
        for (IClass I : ifaces) {
            MutableIntSet set = this.findOrCreateSparseSetForClass(I);
            set.add(index);
        }
    }

    private void registerInstanceWithAllSuperclasses(int index, IClass T) {
        while (T != null && !T.getReference().equals(TypeReference.JavaLangObject)) {
            MutableIntSet set = this.findOrCreateSparseSetForClass(T);
            set.add(index);
            T = T.getSuperclass();
        }
    }

    public void newSideEffect(UnaryOperator<PointsToSetVariable> op, PointerKey arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("null arg0");
        }
        assert (!this.pointsToMap.isUnified(arg0));
        PointsToSetVariable v1 = this.findOrCreatePointsToSet(arg0);
        this.newStatement(null, op, (IVariable)v1, true, true);
    }

    public void newSideEffect(AbstractOperator<PointsToSetVariable> op, PointerKey[] arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("null arg0");
        }
        PointsToSetVariable[] vs = new PointsToSetVariable[arg0.length];
        for (int i = 0; i < arg0.length; ++i) {
            assert (!this.pointsToMap.isUnified(arg0[i]));
            vs[i] = this.findOrCreatePointsToSet(arg0[i]);
        }
        this.newStatement(null, op, (IVariable[])vs, true, true);
    }

    public void newSideEffect(AbstractOperator<PointsToSetVariable> op, PointerKey arg0, PointerKey arg1) {
        assert (!this.pointsToMap.isUnified(arg0));
        assert (!this.pointsToMap.isUnified(arg1));
        PointsToSetVariable v1 = this.findOrCreatePointsToSet(arg0);
        PointsToSetVariable v2 = this.findOrCreatePointsToSet(arg1);
        this.newStatement(null, op, (IVariable)v1, (IVariable)v2, true, true);
    }

    protected void initializeWorkList() {
        this.addAllStatementsToWorkList();
    }

    public PointerAnalysis<InstanceKey> extractPointerAnalysis(PropagationCallGraphBuilder builder) {
        if (this.pointerAnalysis == null) {
            this.pointerAnalysis = this.makePointerAnalysis(builder);
        }
        return this.pointerAnalysis;
    }

    public void performVerboseAction() {
        super.performVerboseAction();
        if (this.getFixedPointSystem() instanceof VerboseAction) {
            ((VerboseAction)this.getFixedPointSystem()).performVerboseAction();
        }
        if (!this.workList.isEmpty()) {
            AbstractStatement s = this.workList.takeStatement();
            System.err.println(this.printRHSInstances(s));
            this.workList.insertStatement(s);
            System.err.println("CGNodes: " + this.cg.getNumberOfNodes());
        }
    }

    private String printRHSInstances(AbstractStatement s) {
        if (s instanceof UnaryStatement) {
            UnaryStatement u = (UnaryStatement)s;
            PointsToSetVariable rhs = (PointsToSetVariable)u.getRightHandSide();
            MutableIntSet value = rhs.getValue();
            int[] topFive = new int[5];
            value.foreach(x -> {
                System.arraycopy(topFive, 1, topFive, 0, 4);
                topFive[4] = x;
            });
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                int p = topFive[i];
                if (p == 0) continue;
                InstanceKey ik = this.getInstanceKey(p);
                result.append(p).append("  ").append(ik).append('\n');
            }
            return result.toString();
        }
        return s.getClass().toString();
    }

    public IFixedPointSystem<PointsToSetVariable> getFixedPointSystem() {
        return this.flowGraph;
    }

    public Iterator<PointerKey> iteratePointerKeys() {
        return this.pointsToMap.iterateKeys();
    }

    public int getNumberOfPointerKeys() {
        return this.pointsToMap.getNumberOfPointerKeys();
    }

    Worklist getWorklist() {
        return this.workList;
    }

    public Iterator<AbstractStatement> getStatementsThatUse(PointsToSetVariable v) {
        return this.flowGraph.getStatementsThatUse(v);
    }

    public Iterator<AbstractStatement<PointsToSetVariable, ?>> getStatementsThatDef(PointsToSetVariable v) {
        return this.flowGraph.getStatementsThatDef(v);
    }

    public NumberedGraph<PointsToSetVariable> getAssignmentGraph() {
        return this.flowGraph.getAssignmentGraph();
    }

    public Graph<PointsToSetVariable> getFilterAsssignmentGraph() {
        return this.flowGraph.getFilterAssignmentGraph();
    }

    public Graph<PointsToSetVariable> getFlowGraphIncludingImplicitConstraints() {
        return this.flowGraph.getFlowGraphIncludingImplicitConstraints();
    }

    public void revertToPreTransitive() {
        this.pointsToMap.revertToPreTransitive();
    }

    public Iterator<PointerKey> getTransitiveRoots() {
        return this.pointsToMap.getTransitiveRoots();
    }

    public boolean isTransitiveRoot(PointerKey key) {
        return this.pointsToMap.isTransitiveRoot(key);
    }

    protected void periodicMaintenance() {
        super.periodicMaintenance();
        ReferenceCleanser.clearSoftCaches();
    }

    public int getVerboseInterval() {
        return this.verboseInterval;
    }

    public void setVerboseInterval(int verboseInterval) {
        this.verboseInterval = verboseInterval;
    }

    public int getPeriodicMaintainInterval() {
        return this.periodicMaintainInterval;
    }

    public void setPeriodicMaintainInterval(int periodicMaintainInteval) {
        this.periodicMaintainInterval = periodicMaintainInteval;
    }

    public void unify(IntSet s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet cache = HashSetFactory.make((int)s.size());
        IntIterator it = s.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            cache.add(this.pointsToMap.getPointsToSet(i));
        }
        this.pointsToMap.unify(s);
        int rep = this.pointsToMap.getRepresentative(s.intIterator().next());
        this.updateEquationsForUnification(cache, rep);
        this.updateSideEffectsForUnification(cache, rep);
    }

    private void updateSideEffectsForUnification(HashSet<PointsToSetVariable> s, int rep) {
        PointsToSetVariable pRef = this.pointsToMap.getPointsToSet(rep);
        for (PointsToSetVariable p : s) {
            this.updateSideEffects(p, pRef);
        }
    }

    private void updateEquationsForUnification(HashSet<PointsToSetVariable> s, int rep) {
        PointsToSetVariable pRef = this.pointsToMap.getPointsToSet(rep);
        for (PointsToSetVariable p : s) {
            AssignEquation assign;
            if (p == pRef) continue;
            for (AbstractStatement as : Iterator2Collection.toSet(this.getStatementsThatDef(p))) {
                if (as instanceof AssignEquation) {
                    assign = (AssignEquation)as;
                    PointsToSetVariable rhs = (PointsToSetVariable)assign.getRightHandSide();
                    int rhsRep = this.pointsToMap.getRepresentative(this.pointsToMap.getIndex(rhs.getPointerKey()));
                    if (rhsRep == rep) {
                        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)as);
                        continue;
                    }
                    this.replaceLHS(pRef, p, (AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>>)as);
                    continue;
                }
                this.replaceLHS(pRef, p, (AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>>)as);
            }
            for (AbstractStatement as : Iterator2Collection.toSet(this.getStatementsThatUse(p))) {
                if (as instanceof AssignEquation) {
                    assign = (AssignEquation)as;
                    PointsToSetVariable lhs = (PointsToSetVariable)assign.getLHS();
                    int lhsRep = this.pointsToMap.getRepresentative(this.pointsToMap.getIndex(lhs.getPointerKey()));
                    if (lhsRep == rep) {
                        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)as);
                        continue;
                    }
                    this.replaceRHS(pRef, p, (AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>>)as);
                    continue;
                }
                this.replaceRHS(pRef, p, (AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>>)as);
            }
            if (this.flowGraph.getNumberOfStatementsThatDef(p) != 0 || this.flowGraph.getNumberOfStatementsThatUse(p) != 0) continue;
            this.flowGraph.removeVariable(p);
        }
    }

    private void replaceRHS(PointsToSetVariable pRef, PointsToSetVariable p, AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>> as) {
        if (as instanceof UnaryStatement) {
            assert (((UnaryStatement)as).getRightHandSide() == p);
            this.newStatement(as.getLHS(), (UnaryOperator)as.getOperator(), (IVariable)pRef, false, false);
        } else {
            IVariable[] rhs = as.getRHS();
            PointsToSetVariable[] newRHS = new PointsToSetVariable[rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                newRHS[i] = rhs[i].equals((Object)p) ? pRef : (PointsToSetVariable)rhs[i];
            }
            this.newStatement(as.getLHS(), as.getOperator(), (IVariable[])newRHS, false, false);
        }
        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)as);
    }

    private void replaceLHS(PointsToSetVariable pRef, PointsToSetVariable p, AbstractStatement<PointsToSetVariable, AbstractOperator<PointsToSetVariable>> as) {
        assert (as.getLHS() == p);
        if (as instanceof UnaryStatement) {
            this.newStatement((IVariable)pRef, (UnaryOperator)as.getOperator(), (IVariable)((PointsToSetVariable)((UnaryStatement)as).getRightHandSide()), false, false);
        } else {
            this.newStatement((IVariable)pRef, as.getOperator(), as.getRHS(), false, false);
        }
        this.flowGraph.removeStatement((IFixedPointStatement<PointsToSetVariable>)as);
    }

    public boolean isUnified(PointerKey result) {
        return this.pointsToMap.isUnified(result);
    }

    public boolean isImplicit(PointerKey result) {
        return this.pointsToMap.isImplicit(result);
    }

    public int getNumber(PointerKey p) {
        return this.pointsToMap.getIndex(p);
    }

    protected PointsToSetVariable[] makeStmtRHS(int size) {
        return new PointsToSetVariable[size];
    }
}

