/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContext;
import com.ibm.wala.util.intset.IntSet;

public abstract class CallStringContextSelector
implements ContextSelector {
    public static final ContextKey CALL_STRING = new ContextKey(){

        public String toString() {
            return "CALL_STRING_KEY";
        }
    };
    public static final ContextKey BASE = new ContextKey(){

        public String toString() {
            return "BASE_KEY";
        }
    };
    protected final ContextSelector base;

    public CallStringContextSelector(ContextSelector base) {
        this.base = base;
    }

    protected abstract int getLength(CGNode var1, CallSiteReference var2, IMethod var3);

    protected CallString getCallString(CGNode caller, CallSiteReference site, IMethod target) {
        int length = this.getLength(caller, site, target);
        if (length > 0) {
            if (caller.getContext().get(CALL_STRING) != null) {
                return new CallString(site, caller.getMethod(), length, (CallString)caller.getContext().get(CALL_STRING));
            }
            return new CallString(site, caller.getMethod());
        }
        return null;
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, receiver);
        CallString cs = this.getCallString(caller, site, callee);
        if (cs == null) {
            return baseContext;
        }
        if (baseContext == Everywhere.EVERYWHERE) {
            return new CallStringContext(cs);
        }
        return new CallStringContextPair(cs, baseContext);
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        return this.base.getRelevantParameters(caller, site);
    }

    public static class CallStringContextPair
    implements Context {
        private final CallString cs;
        private final Context base;

        public CallStringContextPair(CallString cs, Context base) {
            this.cs = cs;
            this.base = base;
        }

        public boolean equals(Object o) {
            return o instanceof Context && ((Context)o).isA(CallStringContextPair.class) && ((Context)o).get(CALL_STRING).equals(this.cs) && ((Context)o).get(BASE).equals(this.base);
        }

        public String toString() {
            return "CallStringContextPair: " + this.cs.toString() + ':' + this.base.toString();
        }

        public int hashCode() {
            return this.cs.hashCode() * this.base.hashCode();
        }

        @Override
        public ContextItem get(ContextKey name) {
            if (CALL_STRING.equals(name)) {
                return this.cs;
            }
            if (BASE.equals(name)) {
                return this.base;
            }
            return this.base.get(name);
        }

        public Context getBaseContext() {
            return this.base;
        }

        public CallString getCallString() {
            return this.cs;
        }
    }
}

