/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.LambdaSummaryClass;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeDynamicInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;
import java.util.Objects;

public class LambdaMethodTargetSelector
implements MethodTargetSelector {
    private final Map<BootstrapMethodsReader.BootstrapMethod, SummarizedMethod> methodSummaries = HashMapFactory.make();
    private final Map<BootstrapMethodsReader.BootstrapMethod, LambdaSummaryClass> classSummaries = HashMapFactory.make();
    private final MethodTargetSelector base;

    public LambdaMethodTargetSelector(MethodTargetSelector base) {
        this.base = base;
    }

    @Override
    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        MethodReference target;
        IClassHierarchy cha = caller.getClassHierarchy();
        if (LambdaMethodTargetSelector.isNonClinitLambdaMetafactoryMethod(cha, target = site.getDeclaredTarget())) {
            SSAInvokeDynamicInstruction invoke = (SSAInvokeDynamicInstruction)caller.getIR().getCalls(site)[0];
            try {
                return this.methodSummaries.computeIfAbsent(invoke.getBootstrap(), b -> {
                    MethodSummary summary = this.getLambdaFactorySummary(caller, site, target, invoke);
                    return new SummarizedMethod(summary.getMethod(), summary, cha.lookupClass(target.getDeclaringClass()));
                });
            }
            catch (LambdaSummaryClass.UnresolvedLambdaBodyException e) {
                return null;
            }
        }
        return this.base.getCalleeTarget(caller, site, receiver);
    }

    private MethodSummary getLambdaFactorySummary(CGNode caller, CallSiteReference site, MethodReference target, SSAInvokeDynamicInstruction invoke) {
        String cls = caller.getMethod().getDeclaringClass().getName().toString().replace("/", "$").substring(1);
        int bootstrapIndex = invoke.getBootstrap().getIndexInClassFile();
        MethodReference ref = MethodReference.findOrCreate(target.getDeclaringClass(), Atom.findOrCreateUnicodeAtom(target.getName().toString() + '$' + cls + '$' + bootstrapIndex), target.getDescriptor());
        MethodSummary summary = new MethodSummary(ref);
        if (site.isStatic()) {
            summary.setStatic(true);
        }
        int index = 0;
        IClass lambda = this.classSummaries.computeIfAbsent(invoke.getBootstrap(), b -> LambdaSummaryClass.create(caller, invoke));
        SSAInstructionFactory insts = Language.JAVA.instructionFactory();
        int v = target.getNumberOfParameters() + 2;
        summary.addStatement(insts.NewInstruction(index, v, NewSiteReference.make(index, lambda.getReference())));
        ++index;
        for (int i = 0; i < target.getNumberOfParameters(); ++i) {
            summary.addStatement(insts.PutInstruction(index++, v, i + 1, lambda.getField(LambdaSummaryClass.getCaptureFieldName(i)).getReference()));
        }
        summary.addStatement(insts.ReturnInstruction(index++, v, false));
        return summary;
    }

    private static boolean isNonClinitLambdaMetafactoryMethod(IClassHierarchy cha, MethodReference target) {
        return !target.getName().equals(MethodReference.clinitName) && Objects.equals(cha.lookupClass(TypeReference.LambdaMetaFactory), cha.lookupClass(target.getDeclaringClass()));
    }
}

