/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VolatileMethodSummary {
    private static final boolean DEBUG = false;
    private boolean allowReservedPC = false;
    private MethodSummary summary;
    private List<SSAInstruction> instructions = new ArrayList<SSAInstruction>();
    private Map<Integer, Atom> localNames = new HashMap<Integer, Atom>();
    private int currentProgramCounter = 0;
    private boolean locked = false;
    private static final Reserved RESERVED = new Reserved();

    public VolatileMethodSummary(MethodSummary summary) {
        if (summary == null) {
            throw new IllegalArgumentException("The given summary is null");
        }
        if (summary.getNumberOfStatements() > 0) {
            throw new IllegalArgumentException("The given summary is not empty");
        }
        this.summary = summary;
    }

    public SSAInstruction getStatementAt(int programCounter) {
        if (programCounter < 0) {
            throw new IllegalArgumentException("Program-Counter may not be negative!");
        }
        if (this.instructions.size() <= programCounter) {
            return null;
        }
        if (this.instructions.get(programCounter).equals(RESERVED)) {
            return null;
        }
        return this.instructions.get(programCounter);
    }

    public void reserveProgramCounters(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The count of ProgramCounters to reserve may not be negative");
        }
        for (int i = 0; i < count; ++i) {
            this.instructions.add(RESERVED);
        }
        this.currentProgramCounter += count;
    }

    public boolean allowReserved(boolean enable) {
        boolean prev = this.allowReservedPC;
        this.allowReservedPC = enable;
        return prev;
    }

    public boolean isReserved(int programCounter) {
        if (programCounter < 0) {
            throw new IllegalArgumentException("The Program-Counter may not be negative");
        }
        if (this.instructions.size() - 1 < programCounter) {
            return false;
        }
        if (this.instructions.get(programCounter) == null) {
            return false;
        }
        return this.instructions.get(programCounter).equals(RESERVED);
    }

    public boolean isFree(int programCounter) {
        if (programCounter < 0) {
            throw new IllegalArgumentException("The Program-Counter may not be negative");
        }
        if (this.instructions.size() - 1 < programCounter) {
            return true;
        }
        if (this.instructions.get(programCounter) == null) {
            return true;
        }
        if (this.instructions.get(programCounter).equals(RESERVED)) {
            return false;
        }
        return false;
    }

    public boolean isUsed(int programCounter) {
        if (programCounter < 0) {
            throw new IllegalArgumentException("The Program-Counter may not be negative");
        }
        if (this.instructions.size() - 1 < programCounter) {
            return false;
        }
        if (this.instructions.get(programCounter) == null) {
            return false;
        }
        return !this.instructions.get(programCounter).equals(RESERVED);
    }

    public boolean overwriteStatement(SSAInstruction statement) {
        if (this.locked) {
            throw new IllegalStateException("Summary locked due to call to getMethodSummary().");
        }
        if (statement == null) {
            throw new NullPointerException("Statement is null!");
        }
        if (statement.iIndex() < 0) {
            throw new IllegalArgumentException("Statement has a negative iindex");
        }
        if (!this.allowReservedPC && this.isReserved(statement.iIndex())) {
            throw new IllegalStateException("ProgramCounter " + statement.iIndex() + " is reserved! Use allowReserved(true).");
        }
        if (statement.iIndex() > this.currentProgramCounter) {
            throw new IllegalArgumentException("IIndex " + statement.iIndex() + " is greater than currentProgramCounter. Use getNextProgramCounter.");
        }
        boolean didOverwrite = this.isUsed(statement.iIndex());
        while (this.instructions.size() - 1 < statement.iIndex()) {
            this.instructions.add(null);
        }
        this.instructions.set(statement.iIndex(), statement);
        return didOverwrite;
    }

    public MethodSummary getMethodSummary() {
        if (this.locked) {
            return this.summary;
        }
        if (this.summary.getNumberOfStatements() > 0) {
            throw new IllegalStateException("Meanwhile Statements have been added to the summary given to the constructor. This behavior is not supported!");
        }
        this.locked = true;
        for (int i = 0; i < this.instructions.size(); ++i) {
            SSAInstruction inst = this.instructions.get(i);
            if (inst == null) {
                this.summary.addStatement(null);
                continue;
            }
            if (inst == RESERVED) {
                this.summary.addStatement(new SSAGotoInstruction(i, i + 1));
                continue;
            }
            this.summary.addStatement(inst);
        }
        this.instructions = null;
        return this.summary;
    }

    public void addStatement(SSAInstruction statement) {
        if (this.isUsed(statement.iIndex())) {
            throw new IllegalArgumentException("ProgramCounter " + statement.iIndex() + " is in use! By " + this.getStatementAt(statement.iIndex()) + " Use overwriteStatement().");
        }
        this.overwriteStatement(statement);
    }

    public void setLocalName(int number, String name) {
        this.localNames.put(number, Atom.findOrCreateAsciiAtom(name));
    }

    public void setLocalNames(Map<Integer, Atom> merge) {
        this.localNames.putAll(merge);
    }

    public Map<Integer, Atom> getLocalNames() {
        return this.localNames;
    }

    public void addConstant(Integer vn, ConstantValue value) {
        if (this.summary.getConstants() != null && this.summary.getConstants().containsKey(vn)) {
            throw new IllegalStateException("You redefined a constant at number " + vn);
        }
        if (vn <= 0) {
            throw new IllegalArgumentException("SSA-Value may not be zero or negative.");
        }
        this.summary.addConstant(vn, value);
    }

    public void addPoison(String reason) {
        this.summary.addPoison(reason);
    }

    public Map<Integer, ConstantValue> getConstants() {
        return this.summary.getConstants();
    }

    public MemberReference getMethod() {
        return this.summary.getMethod();
    }

    public int getNextProgramCounter() {
        while (this.isUsed(this.currentProgramCounter) || this.isReserved(this.currentProgramCounter)) {
            ++this.currentProgramCounter;
        }
        while (this.instructions.size() < this.currentProgramCounter) {
            this.instructions.add(null);
        }
        return this.currentProgramCounter;
    }

    public int getNumberOfParameters() {
        return this.summary.getNumberOfParameters();
    }

    public TypeReference getParameterType(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("The parater number may not be zero or negative! " + i + " given");
        }
        if (i >= this.summary.getNumberOfParameters()) {
            throw new ArrayIndexOutOfBoundsException("No such parameter index: " + i);
        }
        return this.summary.getParameterType(i);
    }

    public String getPoison() {
        return this.summary.getPoison();
    }

    public byte getPoisonLevel() {
        return this.summary.getPoisonLevel();
    }

    public TypeReference getReturnType() {
        return this.summary.getReturnType();
    }

    public SSAInstruction[] getStatements() {
        SSAInstruction[] ret = new SSAInstruction[this.instructions.size()];
        ret = this.instructions.toArray(ret);
        for (int i = 0; i < ret.length; ++i) {
            if (!ret[i].equals(RESERVED)) continue;
            ret[i] = null;
        }
        return ret;
    }

    public boolean hasPoison() {
        return this.summary.hasPoison();
    }

    public boolean isFactory() {
        return this.summary.isFactory();
    }

    public boolean isNative() {
        return this.summary.isNative();
    }

    public boolean isStatic() {
        return this.summary.isStatic();
    }

    public void setFactory(boolean b) {
        if (this.locked) {
            throw new IllegalStateException("Summary is locked. Unlock using unlock()");
        }
        this.summary.setFactory(b);
    }

    public void setPoisonLevel(byte b) {
        if (this.locked) {
            throw new IllegalStateException("Summary is locked. Unlock using unlock()");
        }
        this.summary.setPoisonLevel(b);
    }

    public void setStatic(boolean b) {
        if (this.locked) {
            throw new IllegalStateException("Summary is locked. Unlock using unlock()");
        }
        this.summary.setStatic(b);
    }

    public String toString() {
        return "VolatileMethodSummary of " + this.summary.toString();
    }

    private static final class Reserved
    extends SSAInstruction {
        public Reserved() {
            super(-1);
        }

        @Override
        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
            throw new IllegalStateException();
        }

        @Override
        public int hashCode() {
            return 12384;
        }

        @Override
        public boolean isFallThrough() {
            return true;
        }

        @Override
        public String toString(SymbolTable symbolTable) {
            return "Reserved Slot";
        }

        @Override
        public void visit(SSAInstruction.IVisitor v) {
            throw new IllegalStateException();
        }
    }
}

