/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayReferenceInstruction
extends SSAInstruction {
    private final int arrayref;
    private final int index;
    private final TypeReference elementType;

    SSAArrayReferenceInstruction(int iindex, int arrayref, int index, TypeReference elementType) {
        super(iindex);
        this.arrayref = arrayref;
        this.index = index;
        this.elementType = elementType;
        if (elementType == null) {
            throw new IllegalArgumentException("null elementType");
        }
    }

    @Override
    public int getNumberOfUses() {
        return 2;
    }

    @Override
    public int getUse(int j) {
        assert (j <= 1);
        return j == 0 ? this.arrayref : this.index;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    public int getIndex() {
        return this.index;
    }

    public TypeReference getElementType() {
        return this.elementType;
    }

    public boolean typeIsPrimitive() {
        return this.elementType.isPrimitiveType();
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

