/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JarStreamModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.classLoader.ResourceJarFileModule;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipException;

public class FileProvider {
    private static final int DEBUG_LEVEL = Integer.parseInt(System.getProperty("wala.debug.file", "0"));

    public Module getJarFileModule(String fileName) throws IOException {
        return this.getJarFileModule(fileName, FileProvider.class.getClassLoader());
    }

    public Module getJarFileModule(String fileName, ClassLoader loader) throws IOException {
        return this.getJarFileFromClassLoader(fileName, loader);
    }

    public URL getResource(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        return this.getResource(fileName, FileProvider.class.getClassLoader());
    }

    public URL getResource(String fileName, ClassLoader loader) {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        return loader.getResource(fileName);
    }

    public File getFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        return this.getFile(fileName, FileProvider.class.getClassLoader());
    }

    public File getFile(String fileName, ClassLoader loader) throws IOException {
        return this.getFileFromClassLoader(fileName, loader);
    }

    public File getFileFromClassLoader(String fileName, ClassLoader loader) throws FileNotFoundException {
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        URL url = null;
        try {
            url = loader.getResource(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG_LEVEL > 0) {
            System.err.println("FileProvider got url: " + url + " for " + fileName);
        }
        if (url == null) {
            File f = new File(fileName);
            if (f.exists()) {
                return f;
            }
            throw new FileNotFoundException(fileName);
        }
        return new File(this.filePathFromURL(url));
    }

    public InputStream getInputStreamFromClassLoader(String fileName, ClassLoader loader) throws FileNotFoundException {
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        InputStream is = loader.getResourceAsStream(fileName);
        if (is == null) {
            File f = new File(fileName);
            if (f.exists()) {
                return new FileInputStream(f);
            }
            throw new FileNotFoundException(fileName);
        }
        return is;
    }

    public Module getJarFileFromClassLoader(String fileName, ClassLoader loader) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        URL url = loader.getResource(fileName);
        if (DEBUG_LEVEL > 0) {
            System.err.println("FileProvider got url: " + url + " for " + fileName);
        }
        if (url == null) {
            try {
                return new JarFileModule(new JarFile(fileName, false));
            }
            catch (ZipException e) {
                throw new IOException("Could not find file: " + fileName, e);
            }
        }
        switch (url.getProtocol()) {
            case "jar": {
                JarURLConnection jc = (JarURLConnection)url.openConnection();
                JarFile f = jc.getJarFile();
                JarEntry entry = jc.getJarEntry();
                JarFileModule parent = new JarFileModule(f);
                return new NestedJarFileModule(parent, entry);
            }
            case "rsrc": {
                return new ResourceJarFileModule(url);
            }
            case "file": {
                String filePath = this.filePathFromURL(url);
                return new JarFileModule(new JarFile(filePath, false));
            }
        }
        URLConnection in = url.openConnection();
        JarInputStream jarIn = new JarInputStream(in.getInputStream(), false);
        return new JarStreamModule(jarIn);
    }

    public String filePathFromURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        try {
            URI uri = new File(URLDecoder.decode(url.getPath(), "UTF-8")).toURI();
            return uri.getPath();
        }
        catch (UnsupportedEncodingException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

