/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.scope;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JUnitEntryPoints {
    private static final boolean DEBUG = false;

    public static Iterable<Entrypoint> make(IClassHierarchy cha) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        HashSet result = HashSetFactory.make();
        for (IClass klass : cha) {
            if (!klass.getClassLoader().getReference().equals(ClassLoaderReference.Application) || !JUnitEntryPoints.isJUnitTestCase(klass)) continue;
            System.out.println("application class: " + klass);
            Collection<? extends IMethod> methods = klass.getAllMethods();
            for (IMethod iMethod : methods) {
                if (!JUnitEntryPoints.isJUnitMethod(iMethod)) continue;
                result.add(new DefaultEntrypoint(iMethod, cha));
                System.out.println("- adding test method as entry point: " + iMethod.getName().toString());
            }
        }
        return result::iterator;
    }

    public static Iterable<Entrypoint> makeOne(IClassHierarchy cha, String targetPackageName, String targetSimpleClassName, String targetMethodName) {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom targetPackageAtom = Atom.findOrCreateAsciiAtom(targetPackageName);
        Atom targetSimpleClassAtom = Atom.findOrCreateAsciiAtom(targetSimpleClassName);
        TypeName targetType = TypeName.findOrCreateClass(targetPackageAtom, targetSimpleClassAtom);
        Atom targetMethodAtom = Atom.findOrCreateAsciiAtom(targetMethodName);
        HashSet entryPts = HashSetFactory.make();
        for (IClass klass : cha) {
            TypeName klassType = klass.getName();
            if (!klassType.equals(targetType) || !JUnitEntryPoints.isJUnitTestCase(klass)) continue;
            for (IMethod iMethod : klass.getDeclaredMethods()) {
                Atom methodAtom = iMethod.getName();
                if (!methodAtom.equals(targetMethodAtom)) continue;
                entryPts.add(new DefaultEntrypoint(iMethod, cha));
                System.out.println("- adding entry point of the call graph: " + methodAtom.toString());
            }
            Set<IMethod> setUpTearDowns = JUnitEntryPoints.getSetUpTearDownMethods(klass);
            for (IMethod m : setUpTearDowns) {
                entryPts.add(new DefaultEntrypoint(m, cha));
            }
        }
        return entryPts::iterator;
    }

    public static boolean isJUnitTestCase(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        for (IClass ancestor = klass.getSuperclass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
            TypeName t = ancestor.getName();
            if (!t.equals(junitTestCaseType) && !t.equals(junitTestSuiteType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnitMethod(IMethod m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (!JUnitEntryPoints.isJUnitTestCase(m.getDeclaringClass())) {
            return false;
        }
        Atom method = m.getName();
        String methodName = method.toString();
        return methodName.startsWith("test") || methodName.equals("setUp") || methodName.equals("tearDown");
    }

    public static Set<IMethod> getSetUpTearDownMethods(IClass testClass) {
        Atom junitPackage = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom junitClass = Atom.findOrCreateAsciiAtom("TestCase");
        Atom junitSuite = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName junitTestCaseType = TypeName.findOrCreateClass(junitPackage, junitClass);
        TypeName junitTestSuiteType = TypeName.findOrCreateClass(junitPackage, junitSuite);
        Atom setUpMethodAtom = Atom.findOrCreateAsciiAtom("setUp");
        Atom tearDownMethodAtom = Atom.findOrCreateAsciiAtom("tearDown");
        HashSet result = HashSetFactory.make();
        for (IClass currClass = testClass; currClass != null && !currClass.getName().equals(junitTestCaseType) && !currClass.getName().equals(junitTestSuiteType); currClass = currClass.getSuperclass()) {
            for (IMethod iMethod : currClass.getDeclaredMethods()) {
                Atom methodAtom = iMethod.getName();
                if (!methodAtom.equals(setUpMethodAtom) && !methodAtom.equals(tearDownMethodAtom) && !iMethod.isClinit() && !iMethod.isInit()) continue;
                result.add(iMethod);
            }
        }
        return result;
    }
}

