/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.IVariable;

public abstract class GeneralStatement<T extends IVariable<T>>
extends AbstractStatement<T, AbstractOperator<T>> {
    protected final T lhs;
    protected final T[] rhs;
    private final int hashCode;
    private final AbstractOperator<T> operator;
    private static final int[] primes = new int[]{331, 337, 347, 1277};

    @Override
    public byte evaluate() {
        return this.operator.evaluate((IVariable)this.lhs, (IVariable[])this.rhs);
    }

    @Override
    public T getLHS() {
        return this.lhs;
    }

    @Override
    public boolean hasVariable(T cell) {
        if (this.lhs == cell) {
            return true;
        }
        for (T rh : this.rhs) {
            if (rh != cell) continue;
            return true;
        }
        return false;
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator) {
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = null;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, T op1, T op2) {
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = this.makeRHS(2);
        this.rhs[0] = op1;
        this.rhs[1] = op2;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, T op1, T op2, T op3) {
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        this.operator = operator;
        this.rhs = this.makeRHS(3);
        this.lhs = lhs;
        this.rhs[0] = op1;
        this.rhs[1] = op2;
        this.rhs[2] = op3;
        this.hashCode = this.makeHashCode();
    }

    public GeneralStatement(T lhs, AbstractOperator<T> operator, T[] rhs) {
        if (operator == null) {
            throw new IllegalArgumentException("null operator");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = (IVariable[])rhs.clone();
        this.hashCode = this.makeHashCode();
    }

    private int makeHashCode() {
        int result = this.operator.hashCode();
        if (this.lhs != null) {
            result += this.lhs.hashCode() * primes[0];
        }
        for (int i = 0; i < Math.min(this.rhs.length, 2); ++i) {
            if (this.rhs[i] == null) continue;
            result += primes[i + 1] * this.rhs[i].hashCode();
        }
        return result;
    }

    protected abstract T[] makeRHS(int var1);

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            GeneralStatement other = (GeneralStatement)o;
            if (this.hashCode == other.hashCode) {
                if (this.lhs == null || other.lhs == null ? other.lhs != this.lhs : !this.lhs.equals(other.lhs)) {
                    return false;
                }
                if (this.operator.equals(other.operator) && this.rhs.length == other.rhs.length) {
                    for (int i = 0; i < this.rhs.length; ++i) {
                        if (!(this.rhs[i] == null || other.rhs[i] == null ? other.rhs[i] != this.rhs[i] : !this.rhs[i].equals(other.rhs[i]))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public AbstractOperator<T> getOperator() {
        return this.operator;
    }

    @Override
    public T[] getRHS() {
        return this.rhs;
    }
}

