/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.Iterator2Collection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class MapIterator<X, Y>
implements Iterator<Y> {
    final Iterator<? extends X> i;
    final Function<X, Y> f;

    public MapIterator(Iterator<? extends X> i, Function<X, Y> f) {
        if (i == null) {
            throw new IllegalArgumentException("null i");
        }
        this.i = i;
        this.f = f;
    }

    @Override
    public Y next() {
        return this.f.apply(this.i.next());
    }

    @Override
    public boolean hasNext() {
        return this.i.hasNext();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "map: " + this.f + " of " + this.i;
    }

    public static <X, Y> Iterator<Y> map(Function<X, Y> f, Iterator<X> i) {
        return new MapIterator<X, Y>(i, f);
    }

    public static <X, Y> Set<Y> map(Function<X, Y> f, Collection<X> i) {
        return Iterator2Collection.toSet(new MapIterator<X, Y>(i.iterator(), f));
    }
}

