/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.LongIterator;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.LongSetAction;
import com.ibm.wala.util.intset.LongSetUtil;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SparseLongSet
implements LongSet {
    private static final int SINGLETON_CACHE_SIZE = 0;
    private static final SparseLongSet[] singletonCache = new SparseLongSet[0];
    protected long[] elements;
    protected int size = 0;

    protected SparseLongSet(int size) {
        this.elements = new long[size];
        this.size = size;
    }

    protected SparseLongSet(long[] backingArray) {
        if (backingArray == null) {
            throw new IllegalArgumentException("backingArray is null");
        }
        this.elements = backingArray;
        this.size = backingArray.length;
    }

    public SparseLongSet() {
        this.elements = null;
        this.size = 0;
    }

    protected SparseLongSet(SparseLongSet S) {
        this.cloneState(S);
    }

    private void cloneState(SparseLongSet S) {
        this.elements = (long[])S.elements.clone();
        this.size = S.size;
    }

    public SparseLongSet(IntSet S) throws IllegalArgumentException {
        if (S == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (S instanceof SparseLongSet) {
            this.cloneState((SparseLongSet)((Object)S));
        } else {
            this.elements = new long[S.size()];
            this.size = S.size();
            S.foreach(new IntSetAction(){
                private int index = 0;

                @Override
                public void act(int i) {
                    SparseLongSet.this.elements[this.index++] = i;
                }
            });
        }
    }

    @Override
    public final boolean contains(long x) {
        if (this.elements == null) {
            return false;
        }
        return LongSetUtil.binarySearch(this.elements, x, 0, this.size - 1) >= 0;
    }

    public final int getIndex(long x) {
        if (this.elements == null) {
            return -1;
        }
        return LongSetUtil.binarySearch(this.elements, x, 0, this.size - 1);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final long elementAt(int idx) throws NoSuchElementException {
        if (idx < 0 || idx >= this.size) {
            throw new NoSuchElementException();
        }
        return this.elements[idx];
    }

    private boolean sameValueInternal(SparseLongSet that) {
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == that.elements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean sameValue(LongSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseLongSet) {
            return this.sameValueInternal((SparseLongSet)that);
        }
        Assertions.UNREACHABLE(that.getClass().toString());
        return false;
    }

    private boolean isSubsetInternal(SparseLongSet that) {
        if (this.elements == null) {
            return true;
        }
        if (that.elements == null) {
            return false;
        }
        if (this.equals(that)) {
            return true;
        }
        if (this.sameValue(that)) {
            return true;
        }
        long[] ar = this.elements;
        int ai = 0;
        int al = this.size;
        long[] br = that.elements;
        int bi = 0;
        int bl = that.size;
        while (ai < al && bi < bl) {
            long cmp = ar[ai] - br[bi];
            if (cmp > 0L) {
                ++bi;
                continue;
            }
            if (cmp < 0L) {
                return false;
            }
            ++ai;
            ++bi;
        }
        return bi != bl || ai >= al;
    }

    public static SparseLongSet diff(SparseLongSet A, SparseLongSet B) {
        if (A == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (A.isEmpty()) {
            return new SparseLongSet(0);
        }
        if (B.isEmpty()) {
            return new SparseLongSet(A);
        }
        if (A.equals(B)) {
            return new SparseLongSet(0);
        }
        if (A.sameValue(B)) {
            return new SparseLongSet(0);
        }
        long[] ar = A.elements;
        int ai = 0;
        int al = A.size;
        long[] br = B.elements;
        int bi = 0;
        int bl = B.size;
        long[] cr = new long[al];
        int ci = 0;
        while (ai < al && bi < bl) {
            long cmp = ar[ai] - br[bi];
            if (cmp > 0L) {
                ++bi;
                continue;
            }
            if (cmp < 0L) {
                cr[ci++] = ar[ai];
                ++ai;
                continue;
            }
            ++ai;
            ++bi;
        }
        if (ai < al) {
            int tail = al - ai;
            System.arraycopy(ar, ai, cr, ci, tail);
            ci += tail;
        }
        ar = new long[ci];
        System.arraycopy(cr, 0, ar, 0, ci);
        return new SparseLongSet(ar);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(6 * this.size);
        sb.append("{ ");
        if (this.elements != null) {
            for (int ii = 0; ii < this.size; ++ii) {
                sb.append(this.elements[ii]);
                sb.append(' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static long[] parseLongArray(String str) throws NumberFormatException, IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException("malformed input: " + str);
        }
        if (str.charAt(0) != '{' || str.charAt(len - 1) != '}') {
            throw new NumberFormatException(str);
        }
        str = str.substring(1, len - 1);
        StringTokenizer tok = new StringTokenizer(str, " ,");
        TreeSet<Long> set = new TreeSet<Long>();
        while (tok.hasMoreTokens()) {
            set.add(Long.decode(tok.nextToken()));
        }
        long[] result = new long[set.size()];
        int i = 0;
        for (Long L : set) {
            result[i++] = L;
        }
        return result;
    }

    public static SparseLongSet singleton(int i) {
        if (i >= 0 && i < 0) {
            return singletonCache[i];
        }
        return new SparseLongSet(new long[]{i});
    }

    public static SparseLongSet pair(long i, long j) {
        if (j > i) {
            return new SparseLongSet(new long[]{i, j});
        }
        return new SparseLongSet(new long[]{j, i});
    }

    @Override
    public LongSet intersection(LongSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseLongSet) {
            MutableSparseLongSet temp = MutableSparseLongSet.make(this);
            temp.intersectWith((SparseLongSet)that);
            return temp;
        }
        Assertions.UNREACHABLE("Unexpected: " + that.getClass());
        return null;
    }

    @Override
    public LongIterator longIterator() {
        return new LongIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseLongSet.this.size;
            }

            @Override
            public long next() throws NoSuchElementException {
                if (SparseLongSet.this.elements == null) {
                    throw new NoSuchElementException();
                }
                return SparseLongSet.this.elements[this.i++];
            }
        };
    }

    @Override
    public void foreach(LongSetAction action) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        for (int i = 0; i < this.size; ++i) {
            action.act(this.elements[i]);
        }
    }

    @Override
    public void foreachExcluding(LongSet X, LongSetAction action) {
        if (X == null) {
            throw new IllegalArgumentException("null X");
        }
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        for (int i = 0; i < this.size; ++i) {
            if (X.contains(this.elements[i])) continue;
            action.act(this.elements[i]);
        }
    }

    @Override
    public final long max() throws IllegalStateException {
        if (this.elements == null) {
            throw new IllegalStateException("Illegal to ask max() on an empty int set");
        }
        return this.size > 0 ? this.elements[this.size - 1] : -1L;
    }

    public static SparseLongSet add(SparseLongSet s, int j) {
        if (s == null || s.elements == null) {
            return SparseLongSet.singleton(j);
        }
        SparseLongSet result = new SparseLongSet(s.size + 1);
        int k = 0;
        int m = 0;
        while (k < s.elements.length && s.elements[k] < (long)j) {
            result.elements[k++] = s.elements[m++];
        }
        if (k == s.size) {
            result.elements[k] = j;
        } else {
            if (s.elements[k] == (long)j) {
                --result.size;
            } else {
                result.elements[k++] = j;
            }
            while (k < result.size) {
                result.elements[k++] = s.elements[m++];
            }
        }
        return result;
    }

    @Override
    public boolean isSubset(LongSet that) throws IllegalArgumentException, UnimplementedError {
        if (that == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (that instanceof SparseLongSet) {
            return this.isSubsetInternal((SparseLongSet)that);
        }
        Assertions.UNREACHABLE("Unexpected type " + that.getClass());
        return false;
    }

    @Override
    public boolean containsAny(LongSet set) {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (set instanceof SparseLongSet) {
            return this.containsAny((SparseLongSet)set);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!set.contains(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(SparseLongSet set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        int i = 0;
        for (int j = 0; j < set.size; ++j) {
            long x = set.elements[j];
            while (i < this.size && this.elements[i] < x) {
                ++i;
            }
            if (i == this.size) {
                return false;
            }
            if (this.elements[i] != x) continue;
            return true;
        }
        return false;
    }

    static {
        for (int i = 0; i < 0; ++i) {
            SparseLongSet.singletonCache[i] = new SparseLongSet(new long[]{i});
        }
    }
}

