/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.util.collections.HashSetFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class FileUtil {
    public static Collection<File> listFiles(String dir, String regex, boolean recurse) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        File d = new File(dir);
        Pattern p = null;
        if (regex != null) {
            p = Pattern.compile(regex);
        }
        return FileUtil.listFiles(d, recurse, p);
    }

    private static Collection<File> listFiles(File directory, boolean recurse, Pattern p) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        HashSet<File> result = HashSetFactory.make();
        for (File file : files) {
            if (p == null || p.matcher(file.getAbsolutePath()).matches()) {
                result.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            result.addAll(FileUtil.listFiles(file, recurse, p));
        }
        return result;
    }

    public static void copy(String srcFileName, String destFileName) throws IOException {
        if (srcFileName == null) {
            throw new IllegalArgumentException("srcFileName is null");
        }
        if (destFileName == null) {
            throw new IllegalArgumentException("destFileName is null");
        }
        try (FileInputStream srcStream = new FileInputStream(srcFileName);
             FileOutputStream dstStream = new FileOutputStream(destFileName);
             FileChannel src = srcStream.getChannel();
             FileChannel dest = dstStream.getChannel();){
            long n = src.size();
            MappedByteBuffer buf = src.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            dest.write(buf);
        }
    }

    public static void deleteContents(String directory) throws IOException {
        File f = new File(directory);
        if (!f.exists()) {
            return;
        }
        if (!f.isDirectory()) {
            throw new IOException(directory + " is not a vaid directory");
        }
        for (String s : f.list()) {
            FileUtil.deleteRecursively(new File(f, s));
        }
    }

    private static void deleteRecursively(File f) throws IOException {
        boolean b;
        if (f.isDirectory()) {
            for (String s : f.list()) {
                FileUtil.deleteRecursively(new File(f, s));
            }
        }
        if (!(b = f.delete())) {
            throw new IOException("failed to delete " + f);
        }
    }

    public static final FileOutputStream createFile(String fileName) throws IOException {
        boolean result;
        if (fileName == null) {
            throw new IllegalArgumentException("null file");
        }
        File f = new File(fileName);
        if (f.getParentFile() != null && !f.getParentFile().exists() && !(result = f.getParentFile().mkdirs())) {
            throw new IOException("failed to create " + f.getParentFile());
        }
        if (f.exists()) {
            f.delete();
        }
        if (!(result = f.createNewFile())) {
            throw new IOException("failed to create " + f);
        }
        return new FileOutputStream(f);
    }

    public static byte[] readBytes(InputStream s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("null s");
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] bb;
            byte[] b = new byte[1024];
            int n = s.read(b);
            while (n != -1) {
                out.write(b, 0, n);
                n = s.read(b);
            }
            byte[] byArray = bb = out.toByteArray();
            return byArray;
        }
    }

    public static void writeFile(File f, String content) throws IOException {
        try (BufferedWriter fw = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            fw.append(content);
        }
    }

    public static void recurseFiles(Consumer<File> action, Predicate<File> filter, File top) {
        if (top.isDirectory()) {
            for (File f : top.listFiles(file -> filter.test(file) || file.isDirectory())) {
                FileUtil.recurseFiles(action, filter, f);
            }
        } else {
            action.accept(top);
        }
    }
}

