/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.DeviceBulkDeletionRequestList;
import com.ibm.wiotp.sdk.swagger.model.DeviceBulkDeletionResponseList;
import com.ibm.wiotp.sdk.swagger.model.DeviceBulkRegistrationRequestList;
import com.ibm.wiotp.sdk.swagger.model.DeviceListResponse;
import com.ibm.wiotp.sdk.swagger.model.DeviceWithPasswordList;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.InvalidRequestMessage;

import java.io.IOException;


import java.math.BigDecimal;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceBulkConfigurationApi {
    private ApiClient apiClient;

    public DeviceBulkConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceBulkConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for bulkDevicesAddPost
     * @param devices Devices to be registered (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesAddPostCall(DeviceBulkRegistrationRequestList devices, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = devices;

        // create path and map variables
        String localVarPath = "/bulk/devices/add";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call bulkDevicesAddPostValidateBeforeCall(DeviceBulkRegistrationRequestList devices, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'devices' is set
        if (devices == null) {
            throw new ApiException("Missing the required parameter 'devices' when calling bulkDevicesAddPost(Async)");
        }
        

        com.squareup.okhttp.Call call = bulkDevicesAddPostCall(devices, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Register multiple new devices
     * Register multiple new devices, each request can contain a maximum of 512 kB.  The response body will contain the generated authentication tokens for all devices. You must make sure to record these tokens when processing the response. We are not able to retrieve lost authentication tokens.
     * @param devices Devices to be registered (required)
     * @return DeviceWithPasswordList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceWithPasswordList bulkDevicesAddPost(DeviceBulkRegistrationRequestList devices) throws ApiException {
        ApiResponse<DeviceWithPasswordList> resp = bulkDevicesAddPostWithHttpInfo(devices);
        return resp.getData();
    }

    /**
     * Register multiple new devices
     * Register multiple new devices, each request can contain a maximum of 512 kB.  The response body will contain the generated authentication tokens for all devices. You must make sure to record these tokens when processing the response. We are not able to retrieve lost authentication tokens.
     * @param devices Devices to be registered (required)
     * @return ApiResponse&lt;DeviceWithPasswordList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceWithPasswordList> bulkDevicesAddPostWithHttpInfo(DeviceBulkRegistrationRequestList devices) throws ApiException {
        com.squareup.okhttp.Call call = bulkDevicesAddPostValidateBeforeCall(devices, null, null);
        Type localVarReturnType = new TypeToken<DeviceWithPasswordList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Register multiple new devices (asynchronously)
     * Register multiple new devices, each request can contain a maximum of 512 kB.  The response body will contain the generated authentication tokens for all devices. You must make sure to record these tokens when processing the response. We are not able to retrieve lost authentication tokens.
     * @param devices Devices to be registered (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesAddPostAsync(DeviceBulkRegistrationRequestList devices, final ApiCallback<DeviceWithPasswordList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = bulkDevicesAddPostValidateBeforeCall(devices, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceWithPasswordList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for bulkDevicesGet
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param typeId Optional filter of results by type ID (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesGetCall(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String typeId, String deviceId, String gatewayTypeId, String gatewayId, Boolean statusAlertEnabled, Object registrationDate, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/bulk/devices";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bookmark != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_bookmark", bookmark));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_limit", limit));
        if (sort != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_sort", sort));
        if (facets != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_facets", facets));
        if (typeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("typeId", typeId));
        if (deviceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceId", deviceId));
        if (gatewayTypeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("gatewayTypeId", gatewayTypeId));
        if (gatewayId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("gatewayId", gatewayId));
        if (statusAlertEnabled != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("status.alert.enabled", statusAlertEnabled));
        if (registrationDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("registration.date", registrationDate));
        if (mgmtDormant != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.dormant", mgmtDormant));
        if (mgmtSupportsDeviceActions != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.supports.deviceActions", mgmtSupportsDeviceActions));
        if (mgmtSupportsFirmwareActions != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.supports.firmwareActions", mgmtSupportsFirmwareActions));
        if (deviceInfoDescription != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.description", deviceInfoDescription));
        if (deviceInfoDescriptiveLocation != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.descriptiveLocation", deviceInfoDescriptiveLocation));
        if (deviceInfoSerialNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.serialNumber", deviceInfoSerialNumber));
        if (deviceInfoDeviceClass != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.deviceClass", deviceInfoDeviceClass));
        if (deviceInfoFwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.fwVersion", deviceInfoFwVersion));
        if (deviceInfoHwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.hwVersion", deviceInfoHwVersion));
        if (deviceInfoManufacturer != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.manufacturer", deviceInfoManufacturer));
        if (deviceInfoModel != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.model", deviceInfoModel));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call bulkDevicesGetValidateBeforeCall(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String typeId, String deviceId, String gatewayTypeId, String gatewayId, Boolean statusAlertEnabled, Object registrationDate, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = bulkDevicesGetCall(bookmark, limit, sort, facets, typeId, deviceId, gatewayTypeId, gatewayId, statusAlertEnabled, registrationDate, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List devices
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param typeId Optional filter of results by type ID (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return DeviceListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceListResponse bulkDevicesGet(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String typeId, String deviceId, String gatewayTypeId, String gatewayId, Boolean statusAlertEnabled, Object registrationDate, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        ApiResponse<DeviceListResponse> resp = bulkDevicesGetWithHttpInfo(bookmark, limit, sort, facets, typeId, deviceId, gatewayTypeId, gatewayId, statusAlertEnabled, registrationDate, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel);
        return resp.getData();
    }

    /**
     * List devices
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param typeId Optional filter of results by type ID (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return ApiResponse&lt;DeviceListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceListResponse> bulkDevicesGetWithHttpInfo(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String typeId, String deviceId, String gatewayTypeId, String gatewayId, Boolean statusAlertEnabled, Object registrationDate, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        com.squareup.okhttp.Call call = bulkDevicesGetValidateBeforeCall(bookmark, limit, sort, facets, typeId, deviceId, gatewayTypeId, gatewayId, statusAlertEnabled, registrationDate, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, null, null);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List devices (asynchronously)
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param typeId Optional filter of results by type ID (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesGetAsync(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String typeId, String deviceId, String gatewayTypeId, String gatewayId, Boolean statusAlertEnabled, Object registrationDate, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ApiCallback<DeviceListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = bulkDevicesGetValidateBeforeCall(bookmark, limit, sort, facets, typeId, deviceId, gatewayTypeId, gatewayId, statusAlertEnabled, registrationDate, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for bulkDevicesRemovePost
     * @param devices Devices to be deleted (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesRemovePostCall(DeviceBulkDeletionRequestList devices, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = devices;

        // create path and map variables
        String localVarPath = "/bulk/devices/remove";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call bulkDevicesRemovePostValidateBeforeCall(DeviceBulkDeletionRequestList devices, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'devices' is set
        if (devices == null) {
            throw new ApiException("Missing the required parameter 'devices' when calling bulkDevicesRemovePost(Async)");
        }
        

        com.squareup.okhttp.Call call = bulkDevicesRemovePostCall(devices, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete multiple devices
     * Delete multiple devices, each request can contain a maximum of 512 kB.
     * @param devices Devices to be deleted (required)
     * @return DeviceBulkDeletionResponseList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceBulkDeletionResponseList bulkDevicesRemovePost(DeviceBulkDeletionRequestList devices) throws ApiException {
        ApiResponse<DeviceBulkDeletionResponseList> resp = bulkDevicesRemovePostWithHttpInfo(devices);
        return resp.getData();
    }

    /**
     * Delete multiple devices
     * Delete multiple devices, each request can contain a maximum of 512 kB.
     * @param devices Devices to be deleted (required)
     * @return ApiResponse&lt;DeviceBulkDeletionResponseList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceBulkDeletionResponseList> bulkDevicesRemovePostWithHttpInfo(DeviceBulkDeletionRequestList devices) throws ApiException {
        com.squareup.okhttp.Call call = bulkDevicesRemovePostValidateBeforeCall(devices, null, null);
        Type localVarReturnType = new TypeToken<DeviceBulkDeletionResponseList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete multiple devices (asynchronously)
     * Delete multiple devices, each request can contain a maximum of 512 kB.
     * @param devices Devices to be deleted (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call bulkDevicesRemovePostAsync(DeviceBulkDeletionRequestList devices, final ApiCallback<DeviceBulkDeletionResponseList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = bulkDevicesRemovePostValidateBeforeCall(devices, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceBulkDeletionResponseList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
