/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.Device;
import com.ibm.wiotp.sdk.swagger.model.DeviceAdditionRequest;
import com.ibm.wiotp.sdk.swagger.model.DeviceAdditionResponse;
import com.ibm.wiotp.sdk.swagger.model.DeviceConcise;
import com.ibm.wiotp.sdk.swagger.model.DeviceListResponse;
import com.ibm.wiotp.sdk.swagger.model.DeviceUpdateRequest;
import com.ibm.wiotp.sdk.swagger.model.EdgeStatusResponse;
import com.ibm.wiotp.sdk.swagger.model.EdgeStatusResponseByService;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.InvalidRequestMessage;

import java.io.IOException;


import java.math.BigDecimal;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceConfigurationApi {
    private ApiClient apiClient;

    public DeviceConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdDelete
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDeleteCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDeleteValidateBeforeCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdDelete(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDeleteCall(typeId, deviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove device
     * Removes a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deviceTypesTypeIdDevicesDeviceIdDelete(String typeId, String deviceId) throws ApiException {
        deviceTypesTypeIdDevicesDeviceIdDeleteWithHttpInfo(typeId, deviceId);
    }

    /**
     * Remove device
     * Removes a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deviceTypesTypeIdDevicesDeviceIdDeleteWithHttpInfo(String typeId, String deviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDeleteValidateBeforeCall(typeId, deviceId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Remove device (asynchronously)
     * Removes a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDeleteAsync(String typeId, String deviceId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDeleteValidateBeforeCall(typeId, deviceId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdDevicesGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDevicesGetCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}/devices"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDevicesGetValidateBeforeCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdDevicesGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdDevicesGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDevicesGetCall(typeId, deviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get devices that are connected through the gateway specified by id {deviceId}
     * Gets information on devices that are connected through the specified gateway (typeId, deviceId) to Watson IoT Platform.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return DeviceListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceListResponse deviceTypesTypeIdDevicesDeviceIdDevicesGet(String typeId, String deviceId) throws ApiException {
        ApiResponse<DeviceListResponse> resp = deviceTypesTypeIdDevicesDeviceIdDevicesGetWithHttpInfo(typeId, deviceId);
        return resp.getData();
    }

    /**
     * Get devices that are connected through the gateway specified by id {deviceId}
     * Gets information on devices that are connected through the specified gateway (typeId, deviceId) to Watson IoT Platform.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return ApiResponse&lt;DeviceListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceListResponse> deviceTypesTypeIdDevicesDeviceIdDevicesGetWithHttpInfo(String typeId, String deviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDevicesGetValidateBeforeCall(typeId, deviceId, null, null);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get devices that are connected through the gateway specified by id {deviceId} (asynchronously)
     * Gets information on devices that are connected through the specified gateway (typeId, deviceId) to Watson IoT Platform.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdDevicesGetAsync(String typeId, String deviceId, final ApiCallback<DeviceListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdDevicesGetValidateBeforeCall(typeId, deviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdEdgestatusGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusGetCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}/edgestatus"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusGetValidateBeforeCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdEdgestatusGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdEdgestatusGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusGetCall(typeId, deviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Return the status of containers from an edge node.
     * Return the status of containers from an edge node.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return EdgeStatusResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public EdgeStatusResponse deviceTypesTypeIdDevicesDeviceIdEdgestatusGet(String typeId, String deviceId) throws ApiException {
        ApiResponse<EdgeStatusResponse> resp = deviceTypesTypeIdDevicesDeviceIdEdgestatusGetWithHttpInfo(typeId, deviceId);
        return resp.getData();
    }

    /**
     * Return the status of containers from an edge node.
     * Return the status of containers from an edge node.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return ApiResponse&lt;EdgeStatusResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<EdgeStatusResponse> deviceTypesTypeIdDevicesDeviceIdEdgestatusGetWithHttpInfo(String typeId, String deviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusGetValidateBeforeCall(typeId, deviceId, null, null);
        Type localVarReturnType = new TypeToken<EdgeStatusResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return the status of containers from an edge node. (asynchronously)
     * Return the status of containers from an edge node.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusGetAsync(String typeId, String deviceId, final ApiCallback<EdgeStatusResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusGetValidateBeforeCall(typeId, deviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EdgeStatusResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param serviceId Service ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetCall(String typeId, String deviceId, String serviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}/edgestatus/{serviceId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()))
            .replaceAll("\\{" + "serviceId" + "\\}", apiClient.escapeString(serviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetValidateBeforeCall(String typeId, String deviceId, String serviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGet(Async)");
        }
        
        // verify the required parameter 'serviceId' is set
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetCall(typeId, deviceId, serviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Return the status of containers from an edge node filtering by service.
     * Return the status of containers from an edge node filtering by service.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param serviceId Service ID (required)
     * @return EdgeStatusResponseByService
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public EdgeStatusResponseByService deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGet(String typeId, String deviceId, String serviceId) throws ApiException {
        ApiResponse<EdgeStatusResponseByService> resp = deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetWithHttpInfo(typeId, deviceId, serviceId);
        return resp.getData();
    }

    /**
     * Return the status of containers from an edge node filtering by service.
     * Return the status of containers from an edge node filtering by service.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param serviceId Service ID (required)
     * @return ApiResponse&lt;EdgeStatusResponseByService&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<EdgeStatusResponseByService> deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetWithHttpInfo(String typeId, String deviceId, String serviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetValidateBeforeCall(typeId, deviceId, serviceId, null, null);
        Type localVarReturnType = new TypeToken<EdgeStatusResponseByService>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return the status of containers from an edge node filtering by service. (asynchronously)
     * Return the status of containers from an edge node filtering by service.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param serviceId Service ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetAsync(String typeId, String deviceId, String serviceId, final ApiCallback<EdgeStatusResponseByService> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdEdgestatusServiceIdGetValidateBeforeCall(typeId, deviceId, serviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EdgeStatusResponseByService>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param expand Optional extensions to expand (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdGetCall(String typeId, String deviceId, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_expand", expand));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdGetValidateBeforeCall(String typeId, String deviceId, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdGetCall(typeId, deviceId, expand, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get device
     * Gets device details.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param expand Optional extensions to expand (optional)
     * @return Device
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Device deviceTypesTypeIdDevicesDeviceIdGet(String typeId, String deviceId, List<String> expand) throws ApiException {
        ApiResponse<Device> resp = deviceTypesTypeIdDevicesDeviceIdGetWithHttpInfo(typeId, deviceId, expand);
        return resp.getData();
    }

    /**
     * Get device
     * Gets device details.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param expand Optional extensions to expand (optional)
     * @return ApiResponse&lt;Device&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Device> deviceTypesTypeIdDevicesDeviceIdGetWithHttpInfo(String typeId, String deviceId, List<String> expand) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdGetValidateBeforeCall(typeId, deviceId, expand, null, null);
        Type localVarReturnType = new TypeToken<Device>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get device (asynchronously)
     * Gets device details.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param expand Optional extensions to expand (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdGetAsync(String typeId, String deviceId, List<String> expand, final ApiCallback<Device> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdGetValidateBeforeCall(typeId, deviceId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Device>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdPut
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param deviceUpdate Device update (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdPutCall(String typeId, String deviceId, DeviceUpdateRequest deviceUpdate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = deviceUpdate;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdPutValidateBeforeCall(String typeId, String deviceId, DeviceUpdateRequest deviceUpdate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdPut(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdPut(Async)");
        }
        
        // verify the required parameter 'deviceUpdate' is set
        if (deviceUpdate == null) {
            throw new ApiException("Missing the required parameter 'deviceUpdate' when calling deviceTypesTypeIdDevicesDeviceIdPut(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdPutCall(typeId, deviceId, deviceUpdate, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update device
     * Updates a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param deviceUpdate Device update (required)
     * @return DeviceConcise
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceConcise deviceTypesTypeIdDevicesDeviceIdPut(String typeId, String deviceId, DeviceUpdateRequest deviceUpdate) throws ApiException {
        ApiResponse<DeviceConcise> resp = deviceTypesTypeIdDevicesDeviceIdPutWithHttpInfo(typeId, deviceId, deviceUpdate);
        return resp.getData();
    }

    /**
     * Update device
     * Updates a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param deviceUpdate Device update (required)
     * @return ApiResponse&lt;DeviceConcise&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceConcise> deviceTypesTypeIdDevicesDeviceIdPutWithHttpInfo(String typeId, String deviceId, DeviceUpdateRequest deviceUpdate) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdPutValidateBeforeCall(typeId, deviceId, deviceUpdate, null, null);
        Type localVarReturnType = new TypeToken<DeviceConcise>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update device (asynchronously)
     * Updates a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param deviceUpdate Device update (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdPutAsync(String typeId, String deviceId, DeviceUpdateRequest deviceUpdate, final ApiCallback<DeviceConcise> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdPutValidateBeforeCall(typeId, deviceId, deviceUpdate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceConcise>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesGet
     * @param typeId Device type ID (required)
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesGetCall(String typeId, String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String deviceId, Boolean statusAlertEnabled, String gatewayTypeId, String gatewayId, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, Object registrationDate, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bookmark != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_bookmark", bookmark));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_limit", limit));
        if (sort != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_sort", sort));
        if (facets != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_facets", facets));
        if (deviceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceId", deviceId));
        if (statusAlertEnabled != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("status.alert.enabled", statusAlertEnabled));
        if (gatewayTypeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("gatewayTypeId", gatewayTypeId));
        if (gatewayId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("gatewayId", gatewayId));
        if (mgmtDormant != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.dormant", mgmtDormant));
        if (mgmtSupportsDeviceActions != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.supports.deviceActions", mgmtSupportsDeviceActions));
        if (mgmtSupportsFirmwareActions != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mgmt.supports.firmwareActions", mgmtSupportsFirmwareActions));
        if (registrationDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("registration.date", registrationDate));
        if (deviceInfoDescription != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.description", deviceInfoDescription));
        if (deviceInfoDescriptiveLocation != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.descriptiveLocation", deviceInfoDescriptiveLocation));
        if (deviceInfoSerialNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.serialNumber", deviceInfoSerialNumber));
        if (deviceInfoDeviceClass != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.deviceClass", deviceInfoDeviceClass));
        if (deviceInfoFwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.fwVersion", deviceInfoFwVersion));
        if (deviceInfoHwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.hwVersion", deviceInfoHwVersion));
        if (deviceInfoManufacturer != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.manufacturer", deviceInfoManufacturer));
        if (deviceInfoModel != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.model", deviceInfoModel));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesGetValidateBeforeCall(String typeId, String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String deviceId, Boolean statusAlertEnabled, String gatewayTypeId, String gatewayId, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, Object registrationDate, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesGetCall(typeId, bookmark, limit, sort, facets, deviceId, statusAlertEnabled, gatewayTypeId, gatewayId, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, registrationDate, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List devices
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param typeId Device type ID (required)
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return DeviceListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceListResponse deviceTypesTypeIdDevicesGet(String typeId, String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String deviceId, Boolean statusAlertEnabled, String gatewayTypeId, String gatewayId, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, Object registrationDate, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        ApiResponse<DeviceListResponse> resp = deviceTypesTypeIdDevicesGetWithHttpInfo(typeId, bookmark, limit, sort, facets, deviceId, statusAlertEnabled, gatewayTypeId, gatewayId, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, registrationDate, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel);
        return resp.getData();
    }

    /**
     * List devices
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param typeId Device type ID (required)
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return ApiResponse&lt;DeviceListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceListResponse> deviceTypesTypeIdDevicesGetWithHttpInfo(String typeId, String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String deviceId, Boolean statusAlertEnabled, String gatewayTypeId, String gatewayId, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, Object registrationDate, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesGetValidateBeforeCall(typeId, bookmark, limit, sort, facets, deviceId, statusAlertEnabled, gatewayTypeId, gatewayId, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, registrationDate, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, null, null);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List devices (asynchronously)
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - typeId - deviceId - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - registration.date - status.alert.enabled - status.alert.timestamp  The following facets are supported: - typeId - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - mgmt.dormant - mgmt.supports.deviceActions - mgmt.supports.firmwareActions - status.alert.enabled
     * @param typeId Device type ID (required)
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param deviceId Optional filter of results by device ID (optional)
     * @param statusAlertEnabled Optional filter of results by alert state (optional)
     * @param gatewayTypeId Optional filter of results by gateway type ID (optional)
     * @param gatewayId Optional filter of results by gateway ID (optional)
     * @param mgmtDormant Optional filter of results by dormant state (optional)
     * @param mgmtSupportsDeviceActions Optional filter of results by support for device actions (optional)
     * @param mgmtSupportsFirmwareActions Optional filter of results by support for firmware actions (optional)
     * @param registrationDate Optional filter of results by registration date (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesGetAsync(String typeId, String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String deviceId, Boolean statusAlertEnabled, String gatewayTypeId, String gatewayId, Boolean mgmtDormant, Boolean mgmtSupportsDeviceActions, Boolean mgmtSupportsFirmwareActions, Object registrationDate, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ApiCallback<DeviceListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesGetValidateBeforeCall(typeId, bookmark, limit, sort, facets, deviceId, statusAlertEnabled, gatewayTypeId, gatewayId, mgmtDormant, mgmtSupportsDeviceActions, mgmtSupportsFirmwareActions, registrationDate, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesPost
     * @param typeId Device type ID (required)
     * @param device Device to be added (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesPostCall(String typeId, DeviceAdditionRequest device, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = device;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesPostValidateBeforeCall(String typeId, DeviceAdditionRequest device, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesPost(Async)");
        }
        
        // verify the required parameter 'device' is set
        if (device == null) {
            throw new ApiException("Missing the required parameter 'device' when calling deviceTypesTypeIdDevicesPost(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesPostCall(typeId, device, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add device
     * Adds a device.
     * @param typeId Device type ID (required)
     * @param device Device to be added (required)
     * @return DeviceAdditionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceAdditionResponse deviceTypesTypeIdDevicesPost(String typeId, DeviceAdditionRequest device) throws ApiException {
        ApiResponse<DeviceAdditionResponse> resp = deviceTypesTypeIdDevicesPostWithHttpInfo(typeId, device);
        return resp.getData();
    }

    /**
     * Add device
     * Adds a device.
     * @param typeId Device type ID (required)
     * @param device Device to be added (required)
     * @return ApiResponse&lt;DeviceAdditionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceAdditionResponse> deviceTypesTypeIdDevicesPostWithHttpInfo(String typeId, DeviceAdditionRequest device) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesPostValidateBeforeCall(typeId, device, null, null);
        Type localVarReturnType = new TypeToken<DeviceAdditionResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add device (asynchronously)
     * Adds a device.
     * @param typeId Device type ID (required)
     * @param device Device to be added (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesPostAsync(String typeId, DeviceAdditionRequest device, final ApiCallback<DeviceAdditionResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesPostValidateBeforeCall(typeId, device, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceAdditionResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
