/*
 * IBM Watson IoT Platform Organization Information Management REST APIs
 * The Information Management APIs can be used to access device event data as well as  get and update device location and obtain weather information for that location. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html).  version: \"0002\" 
 *
 * OpenAPI spec version: 1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.DeviceLocation;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.UpdateableDeviceLocation;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceLocationApi {
    private ApiClient apiClient;

    public DeviceLocationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceLocationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdLocationGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationGetCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}/location"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationGetValidateBeforeCall(String typeId, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdLocationGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdLocationGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationGetCall(typeId, deviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get device location information
     * Gets location information for a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return DeviceLocation
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceLocation deviceTypesTypeIdDevicesDeviceIdLocationGet(String typeId, String deviceId) throws ApiException {
        ApiResponse<DeviceLocation> resp = deviceTypesTypeIdDevicesDeviceIdLocationGetWithHttpInfo(typeId, deviceId);
        return resp.getData();
    }

    /**
     * Get device location information
     * Gets location information for a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @return ApiResponse&lt;DeviceLocation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceLocation> deviceTypesTypeIdDevicesDeviceIdLocationGetWithHttpInfo(String typeId, String deviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationGetValidateBeforeCall(typeId, deviceId, null, null);
        Type localVarReturnType = new TypeToken<DeviceLocation>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get device location information (asynchronously)
     * Gets location information for a device.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationGetAsync(String typeId, String deviceId, final ApiCallback<DeviceLocation> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationGetValidateBeforeCall(typeId, deviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceLocation>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDevicesDeviceIdLocationPut
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param location Device location information (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationPutCall(String typeId, String deviceId, UpdateableDeviceLocation location, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = location;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}/devices/{deviceId}/location"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationPutValidateBeforeCall(String typeId, String deviceId, UpdateableDeviceLocation location, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDevicesDeviceIdLocationPut(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesTypeIdDevicesDeviceIdLocationPut(Async)");
        }
        
        // verify the required parameter 'location' is set
        if (location == null) {
            throw new ApiException("Missing the required parameter 'location' when calling deviceTypesTypeIdDevicesDeviceIdLocationPut(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationPutCall(typeId, deviceId, location, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update device location information
     * Updates the location information for a device. If no date is supplied, the entry is added with the current date and time.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param location Device location information (required)
     * @return DeviceLocation
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceLocation deviceTypesTypeIdDevicesDeviceIdLocationPut(String typeId, String deviceId, UpdateableDeviceLocation location) throws ApiException {
        ApiResponse<DeviceLocation> resp = deviceTypesTypeIdDevicesDeviceIdLocationPutWithHttpInfo(typeId, deviceId, location);
        return resp.getData();
    }

    /**
     * Update device location information
     * Updates the location information for a device. If no date is supplied, the entry is added with the current date and time.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param location Device location information (required)
     * @return ApiResponse&lt;DeviceLocation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceLocation> deviceTypesTypeIdDevicesDeviceIdLocationPutWithHttpInfo(String typeId, String deviceId, UpdateableDeviceLocation location) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationPutValidateBeforeCall(typeId, deviceId, location, null, null);
        Type localVarReturnType = new TypeToken<DeviceLocation>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update device location information (asynchronously)
     * Updates the location information for a device. If no date is supplied, the entry is added with the current date and time.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param location Device location information (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDevicesDeviceIdLocationPutAsync(String typeId, String deviceId, UpdateableDeviceLocation location, final ApiCallback<DeviceLocation> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDevicesDeviceIdLocationPutValidateBeforeCall(typeId, deviceId, location, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceLocation>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
