/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.ListOfLogEntries;

import java.io.IOException;


import java.math.BigDecimal;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceProblemDeterminationApi {
    private ApiClient apiClient;

    public DeviceProblemDeterminationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceProblemDeterminationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for logsConnectionGet
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param limit The maximum number of events to retrieve. The range is 1-20. (optional)
     * @param offset The number of events to skip before returning the list. The range is 1-1000. (optional)
     * @param fromTime The starting date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param toTime The ending date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call logsConnectionGetCall(String typeId, String deviceId, BigDecimal limit, BigDecimal offset, String fromTime, String toTime, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/logs/connection";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (typeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("typeId", typeId));
        if (deviceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceId", deviceId));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (fromTime != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("fromTime", fromTime));
        if (toTime != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("toTime", toTime));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call logsConnectionGetValidateBeforeCall(String typeId, String deviceId, BigDecimal limit, BigDecimal offset, String fromTime, String toTime, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling logsConnectionGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling logsConnectionGet(Async)");
        }
        

        com.squareup.okhttp.Call call = logsConnectionGetCall(typeId, deviceId, limit, offset, fromTime, toTime, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List device connection log events
     * List connection log events for a device to aid in diagnosing connectivity problems. The entries record successful connection, unsuccessful connection attempts, intentional disconnection and server-initiated disconnection.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param limit The maximum number of events to retrieve. The range is 1-20. (optional)
     * @param offset The number of events to skip before returning the list. The range is 1-1000. (optional)
     * @param fromTime The starting date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param toTime The ending date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @return ListOfLogEntries
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListOfLogEntries logsConnectionGet(String typeId, String deviceId, BigDecimal limit, BigDecimal offset, String fromTime, String toTime) throws ApiException {
        ApiResponse<ListOfLogEntries> resp = logsConnectionGetWithHttpInfo(typeId, deviceId, limit, offset, fromTime, toTime);
        return resp.getData();
    }

    /**
     * List device connection log events
     * List connection log events for a device to aid in diagnosing connectivity problems. The entries record successful connection, unsuccessful connection attempts, intentional disconnection and server-initiated disconnection.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param limit The maximum number of events to retrieve. The range is 1-20. (optional)
     * @param offset The number of events to skip before returning the list. The range is 1-1000. (optional)
     * @param fromTime The starting date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param toTime The ending date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @return ApiResponse&lt;ListOfLogEntries&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListOfLogEntries> logsConnectionGetWithHttpInfo(String typeId, String deviceId, BigDecimal limit, BigDecimal offset, String fromTime, String toTime) throws ApiException {
        com.squareup.okhttp.Call call = logsConnectionGetValidateBeforeCall(typeId, deviceId, limit, offset, fromTime, toTime, null, null);
        Type localVarReturnType = new TypeToken<ListOfLogEntries>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List device connection log events (asynchronously)
     * List connection log events for a device to aid in diagnosing connectivity problems. The entries record successful connection, unsuccessful connection attempts, intentional disconnection and server-initiated disconnection.
     * @param typeId Device type ID (required)
     * @param deviceId Device ID (required)
     * @param limit The maximum number of events to retrieve. The range is 1-20. (optional)
     * @param offset The number of events to skip before returning the list. The range is 1-1000. (optional)
     * @param fromTime The starting date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param toTime The ending date/time of the event range, in ISO 8601 format. fromTime and toTime must me used together. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call logsConnectionGetAsync(String typeId, String deviceId, BigDecimal limit, BigDecimal offset, String fromTime, String toTime, final ApiCallback<ListOfLogEntries> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = logsConnectionGetValidateBeforeCall(typeId, deviceId, limit, offset, fromTime, toTime, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListOfLogEntries>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
