/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.DeviceType;
import com.ibm.wiotp.sdk.swagger.model.DeviceTypeCreationRequest;
import com.ibm.wiotp.sdk.swagger.model.DeviceTypeListResponse;
import com.ibm.wiotp.sdk.swagger.model.DeviceTypeUpdateRequest;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.InvalidRequestMessage;

import java.io.IOException;


import java.math.BigDecimal;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceTypeConfigurationApi {
    private ApiClient apiClient;

    public DeviceTypeConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceTypeConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deviceTypesGet
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param id Optional filter of results by ID (optional)
     * @param description Optional filter of results by description (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesGetCall(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String id, String description, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bookmark != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_bookmark", bookmark));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("_limit", limit));
        if (sort != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_sort", sort));
        if (facets != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "_facets", facets));
        if (id != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
        if (description != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("description", description));
        if (deviceInfoDescription != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.description", deviceInfoDescription));
        if (deviceInfoDescriptiveLocation != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.descriptiveLocation", deviceInfoDescriptiveLocation));
        if (deviceInfoSerialNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.serialNumber", deviceInfoSerialNumber));
        if (deviceInfoDeviceClass != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.deviceClass", deviceInfoDeviceClass));
        if (deviceInfoFwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.fwVersion", deviceInfoFwVersion));
        if (deviceInfoHwVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.hwVersion", deviceInfoHwVersion));
        if (deviceInfoManufacturer != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.manufacturer", deviceInfoManufacturer));
        if (deviceInfoModel != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("deviceInfo.model", deviceInfoModel));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesGetValidateBeforeCall(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String id, String description, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = deviceTypesGetCall(bookmark, limit, sort, facets, id, description, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        return call;

    }

    /**
     * List device types
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - id - description - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - edgeConfiguration.enabled - edgeConfiguration.architecture - edgeConfiguration.edgeServices.id - edgeConfiguration.edgeServices.deploymentOverrides  The following facets are supported: - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param id Optional filter of results by ID (optional)
     * @param description Optional filter of results by description (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return DeviceTypeListResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceTypeListResponse deviceTypesGet(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String id, String description, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        ApiResponse<DeviceTypeListResponse> resp = deviceTypesGetWithHttpInfo(bookmark, limit, sort, facets, id, description, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel);
        return resp.getData();
    }

    /**
     * List device types
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - id - description - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - edgeConfiguration.enabled - edgeConfiguration.architecture - edgeConfiguration.edgeServices.id - edgeConfiguration.edgeServices.deploymentOverrides  The following facets are supported: - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param id Optional filter of results by ID (optional)
     * @param description Optional filter of results by description (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @return ApiResponse&lt;DeviceTypeListResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceTypeListResponse> deviceTypesGetWithHttpInfo(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String id, String description, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesGetValidateBeforeCall(bookmark, limit, sort, facets, id, description, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypeListResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List device types (asynchronously)
     * Sorting can be performed on any of the following properties (sort order can be reversed by prefixing the property name with &#39;-&#39;): - id - description - deviceInfo.description - deviceInfo.descriptiveLocation - deviceInfo.serialNumber - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model - edgeConfiguration.enabled - edgeConfiguration.architecture - edgeConfiguration.edgeServices.id - edgeConfiguration.edgeServices.deploymentOverrides  The following facets are supported: - deviceInfo.deviceClass - deviceInfo.fwVersion - deviceInfo.hwVersion - deviceInfo.manufacturer - deviceInfo.model
     * @param bookmark Used for paging through results. Issue the first request without specifying a bookmark, then take the bookmark returned in the response and provide it on the request for the next page. Repeat until the end of the result set indicated by the absence of a bookmark. Each request must use exactly the same values for the other parameters, or the results are undefined. (optional)
     * @param limit Maximum number of results returned per page. (optional, default to 25)
     * @param sort Define the sort order of results.  Specify a comma-separated list of properties, enclosed within square brackets. Prefix field names with &#39;-&#39; to sort in descending order.  For example: property1,property2 (optional)
     * @param facets Define the facets to return.  For example: property1,property2 (optional)
     * @param id Optional filter of results by ID (optional)
     * @param description Optional filter of results by description (optional)
     * @param deviceInfoDescription Optional filter of results by device description (optional)
     * @param deviceInfoDescriptiveLocation Optional filter of results by device location (optional)
     * @param deviceInfoSerialNumber Optional filter of results by serial number (optional)
     * @param deviceInfoDeviceClass Optional filter of results by device class (optional)
     * @param deviceInfoFwVersion Optional filter of results by firmware version (optional)
     * @param deviceInfoHwVersion Optional filter of results by hardware version (optional)
     * @param deviceInfoManufacturer Optional filter of results by manufacturer name (optional)
     * @param deviceInfoModel Optional filter of results by device model (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesGetAsync(String bookmark, BigDecimal limit, List<String> sort, List<String> facets, String id, String description, String deviceInfoDescription, String deviceInfoDescriptiveLocation, String deviceInfoSerialNumber, String deviceInfoDeviceClass, String deviceInfoFwVersion, String deviceInfoHwVersion, String deviceInfoManufacturer, String deviceInfoModel, final ApiCallback<DeviceTypeListResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesGetValidateBeforeCall(bookmark, limit, sort, facets, id, description, deviceInfoDescription, deviceInfoDescriptiveLocation, deviceInfoSerialNumber, deviceInfoDeviceClass, deviceInfoFwVersion, deviceInfoHwVersion, deviceInfoManufacturer, deviceInfoModel, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypeListResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesPost
     * @param deviceType Device type to be created (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesPostCall(DeviceTypeCreationRequest deviceType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = deviceType;

        // create path and map variables
        String localVarPath = "/device/types";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesPostValidateBeforeCall(DeviceTypeCreationRequest deviceType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'deviceType' is set
        if (deviceType == null) {
            throw new ApiException("Missing the required parameter 'deviceType' when calling deviceTypesPost(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesPostCall(deviceType, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create device type
     * Creates a device type for a normal device or a gateway. Gateways are specialization of devices but have the additional permission to register new devices and act on behalf of a device that is assigned to the gateway.
     * @param deviceType Device type to be created (required)
     * @return DeviceType
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceType deviceTypesPost(DeviceTypeCreationRequest deviceType) throws ApiException {
        ApiResponse<DeviceType> resp = deviceTypesPostWithHttpInfo(deviceType);
        return resp.getData();
    }

    /**
     * Create device type
     * Creates a device type for a normal device or a gateway. Gateways are specialization of devices but have the additional permission to register new devices and act on behalf of a device that is assigned to the gateway.
     * @param deviceType Device type to be created (required)
     * @return ApiResponse&lt;DeviceType&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceType> deviceTypesPostWithHttpInfo(DeviceTypeCreationRequest deviceType) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesPostValidateBeforeCall(deviceType, null, null);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create device type (asynchronously)
     * Creates a device type for a normal device or a gateway. Gateways are specialization of devices but have the additional permission to register new devices and act on behalf of a device that is assigned to the gateway.
     * @param deviceType Device type to be created (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesPostAsync(DeviceTypeCreationRequest deviceType, final ApiCallback<DeviceType> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesPostValidateBeforeCall(deviceType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdDelete
     * @param typeId Device type ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDeleteCall(String typeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdDeleteValidateBeforeCall(String typeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdDeleteCall(typeId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete device type
     * Deletes a device type.
     * @param typeId Device type ID (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deviceTypesTypeIdDelete(String typeId) throws ApiException {
        deviceTypesTypeIdDeleteWithHttpInfo(typeId);
    }

    /**
     * Delete device type
     * Deletes a device type.
     * @param typeId Device type ID (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deviceTypesTypeIdDeleteWithHttpInfo(String typeId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdDeleteValidateBeforeCall(typeId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete device type (asynchronously)
     * Deletes a device type.
     * @param typeId Device type ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdDeleteAsync(String typeId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdDeleteValidateBeforeCall(typeId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdGet
     * @param typeId Device type ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdGetCall(String typeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdGetValidateBeforeCall(String typeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdGetCall(typeId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get device type
     * Gets device type details.
     * @param typeId Device type ID (required)
     * @return DeviceType
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceType deviceTypesTypeIdGet(String typeId) throws ApiException {
        ApiResponse<DeviceType> resp = deviceTypesTypeIdGetWithHttpInfo(typeId);
        return resp.getData();
    }

    /**
     * Get device type
     * Gets device type details.
     * @param typeId Device type ID (required)
     * @return ApiResponse&lt;DeviceType&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceType> deviceTypesTypeIdGetWithHttpInfo(String typeId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdGetValidateBeforeCall(typeId, null, null);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get device type (asynchronously)
     * Gets device type details.
     * @param typeId Device type ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdGetAsync(String typeId, final ApiCallback<DeviceType> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdGetValidateBeforeCall(typeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesTypeIdPut
     * @param typeId Device type ID (required)
     * @param deviceTypeUpdate Device type update (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdPutCall(String typeId, DeviceTypeUpdateRequest deviceTypeUpdate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = deviceTypeUpdate;

        // create path and map variables
        String localVarPath = "/device/types/{typeId}"
            .replaceAll("\\{" + "typeId" + "\\}", apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesTypeIdPutValidateBeforeCall(String typeId, DeviceTypeUpdateRequest deviceTypeUpdate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling deviceTypesTypeIdPut(Async)");
        }
        
        // verify the required parameter 'deviceTypeUpdate' is set
        if (deviceTypeUpdate == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeUpdate' when calling deviceTypesTypeIdPut(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesTypeIdPutCall(typeId, deviceTypeUpdate, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update device type
     * Updates a device type.
     * @param typeId Device type ID (required)
     * @param deviceTypeUpdate Device type update (required)
     * @return DeviceType
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeviceType deviceTypesTypeIdPut(String typeId, DeviceTypeUpdateRequest deviceTypeUpdate) throws ApiException {
        ApiResponse<DeviceType> resp = deviceTypesTypeIdPutWithHttpInfo(typeId, deviceTypeUpdate);
        return resp.getData();
    }

    /**
     * Update device type
     * Updates a device type.
     * @param typeId Device type ID (required)
     * @param deviceTypeUpdate Device type update (required)
     * @return ApiResponse&lt;DeviceType&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeviceType> deviceTypesTypeIdPutWithHttpInfo(String typeId, DeviceTypeUpdateRequest deviceTypeUpdate) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesTypeIdPutValidateBeforeCall(typeId, deviceTypeUpdate, null, null);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update device type (asynchronously)
     * Updates a device type.
     * @param typeId Device type ID (required)
     * @param deviceTypeUpdate Device type update (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesTypeIdPutAsync(String typeId, DeviceTypeUpdateRequest deviceTypeUpdate, final ApiCallback<DeviceType> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesTypeIdPutValidateBeforeCall(typeId, deviceTypeUpdate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceType>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
