/*
 * IBM Watson IoT Platform Organization Information Management REST APIs
 * The Information Management APIs can be used to access device event data as well as  get and update device location and obtain weather information for that location. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html).  version: \"0002\" 
 *
 * OpenAPI spec version: 1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;
import com.ibm.wiotp.sdk.swagger.model.Event;
import com.ibm.wiotp.sdk.swagger.model.Events;
import com.ibm.wiotp.sdk.swagger.model.LECConfig;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LastEventCacheApi {
    private ApiClient apiClient;

    public LastEventCacheApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LastEventCacheApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for configLecGet
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call configLecGetCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/config/lec";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call configLecGetValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = configLecGetCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Retrieve the Last Event Cache configuration for your organization
     * Retrieves the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to determine whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @return LECConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LECConfig configLecGet() throws ApiException {
        ApiResponse<LECConfig> resp = configLecGetWithHttpInfo();
        return resp.getData();
    }

    /**
     * Retrieve the Last Event Cache configuration for your organization
     * Retrieves the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to determine whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @return ApiResponse&lt;LECConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LECConfig> configLecGetWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = configLecGetValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<LECConfig>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve the Last Event Cache configuration for your organization (asynchronously)
     * Retrieves the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to determine whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call configLecGetAsync(final ApiCallback<LECConfig> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = configLecGetValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LECConfig>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for configLecPut
     * @param config LEC configuration to apply (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call configLecPutCall(LECConfig config, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = config;

        // create path and map variables
        String localVarPath = "/config/lec";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call configLecPutValidateBeforeCall(LECConfig config, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'config' is set
        if (config == null) {
            throw new ApiException("Missing the required parameter 'config' when calling configLecPut(Async)");
        }
        

        com.squareup.okhttp.Call call = configLecPutCall(config, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update the Last Event Cache configuration for your organization
     * Updates the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to control whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @param config LEC configuration to apply (required)
     * @return LECConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LECConfig configLecPut(LECConfig config) throws ApiException {
        ApiResponse<LECConfig> resp = configLecPutWithHttpInfo(config);
        return resp.getData();
    }

    /**
     * Update the Last Event Cache configuration for your organization
     * Updates the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to control whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @param config LEC configuration to apply (required)
     * @return ApiResponse&lt;LECConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LECConfig> configLecPutWithHttpInfo(LECConfig config) throws ApiException {
        com.squareup.okhttp.Call call = configLecPutValidateBeforeCall(config, null, null);
        Type localVarReturnType = new TypeToken<LECConfig>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update the Last Event Cache configuration for your organization (asynchronously)
     * Updates the current configuration for the Last Event Cache (LEC) feature for your organization. You can use this endpoint to control whether or not the LEC feature is currently enabled, along with how many days cached device events will persist for before being removed from the cache.
     * @param config LEC configuration to apply (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call configLecPutAsync(LECConfig config, final ApiCallback<LECConfig> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = configLecPutValidateBeforeCall(config, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LECConfig>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGet
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param eventName Event name (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetCall(String deviceType, String deviceId, String eventName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{deviceType}/devices/{deviceId}/events/{eventName}"
            .replaceAll("\\{" + "deviceType" + "\\}", apiClient.escapeString(deviceType.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()))
            .replaceAll("\\{" + "eventName" + "\\}", apiClient.escapeString(eventName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetValidateBeforeCall(String deviceType, String deviceId, String eventName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'deviceType' is set
        if (deviceType == null) {
            throw new ApiException("Missing the required parameter 'deviceType' when calling deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGet(Async)");
        }
        
        // verify the required parameter 'eventName' is set
        if (eventName == null) {
            throw new ApiException("Missing the required parameter 'eventName' when calling deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetCall(deviceType, deviceId, eventName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get last event for a specific event id for a specific device
     * Get last event for a specific event id for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param eventName Event name (required)
     * @return Event
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Event deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGet(String deviceType, String deviceId, String eventName) throws ApiException {
        ApiResponse<Event> resp = deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetWithHttpInfo(deviceType, deviceId, eventName);
        return resp.getData();
    }

    /**
     * Get last event for a specific event id for a specific device
     * Get last event for a specific event id for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param eventName Event name (required)
     * @return ApiResponse&lt;Event&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Event> deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetWithHttpInfo(String deviceType, String deviceId, String eventName) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetValidateBeforeCall(deviceType, deviceId, eventName, null, null);
        Type localVarReturnType = new TypeToken<Event>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get last event for a specific event id for a specific device (asynchronously)
     * Get last event for a specific event id for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param eventName Event name (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetAsync(String deviceType, String deviceId, String eventName, final ApiCallback<Event> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsEventNameGetValidateBeforeCall(deviceType, deviceId, eventName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Event>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deviceTypesDeviceTypeDevicesDeviceIdEventsGet
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsGetCall(String deviceType, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device/types/{deviceType}/devices/{deviceId}/events"
            .replaceAll("\\{" + "deviceType" + "\\}", apiClient.escapeString(deviceType.toString()))
            .replaceAll("\\{" + "deviceId" + "\\}", apiClient.escapeString(deviceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsGetValidateBeforeCall(String deviceType, String deviceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'deviceType' is set
        if (deviceType == null) {
            throw new ApiException("Missing the required parameter 'deviceType' when calling deviceTypesDeviceTypeDevicesDeviceIdEventsGet(Async)");
        }
        
        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deviceTypesDeviceTypeDevicesDeviceIdEventsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsGetCall(deviceType, deviceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all last events for a specific device
     * Get all last events for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @return Events
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Events deviceTypesDeviceTypeDevicesDeviceIdEventsGet(String deviceType, String deviceId) throws ApiException {
        ApiResponse<Events> resp = deviceTypesDeviceTypeDevicesDeviceIdEventsGetWithHttpInfo(deviceType, deviceId);
        return resp.getData();
    }

    /**
     * Get all last events for a specific device
     * Get all last events for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @return ApiResponse&lt;Events&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Events> deviceTypesDeviceTypeDevicesDeviceIdEventsGetWithHttpInfo(String deviceType, String deviceId) throws ApiException {
        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsGetValidateBeforeCall(deviceType, deviceId, null, null);
        Type localVarReturnType = new TypeToken<Events>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all last events for a specific device (asynchronously)
     * Get all last events for a specific device
     * @param deviceType Device type (required)
     * @param deviceId Device id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deviceTypesDeviceTypeDevicesDeviceIdEventsGetAsync(String deviceType, String deviceId, final ApiCallback<Events> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deviceTypesDeviceTypeDevicesDeviceIdEventsGetValidateBeforeCall(deviceType, deviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Events>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
