/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.api;

import com.google.gson.reflect.TypeToken;
import com.ibm.wiotp.sdk.swagger.ApiCallback;
import com.ibm.wiotp.sdk.swagger.ApiClient;
import com.ibm.wiotp.sdk.swagger.ApiException;
import com.ibm.wiotp.sdk.swagger.ApiResponse;
import com.ibm.wiotp.sdk.swagger.Configuration;
import com.ibm.wiotp.sdk.swagger.Pair;
import com.ibm.wiotp.sdk.swagger.ProgressRequestBody;
import com.ibm.wiotp.sdk.swagger.ProgressResponseBody;
import com.ibm.wiotp.sdk.swagger.model.DataTraffic;
import com.ibm.wiotp.sdk.swagger.model.ErrorMessage;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsageManagementApi {
    private ApiClient apiClient;

    public UsageManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for usageDataTrafficGet
     * @param start Start date in one of the following formats: YYYY (first day of the year), YYYY-MM (first day of the month), YYYY-MM-DD (specific day) (required)
     * @param end End date in one of the following formats: YYYY (last day of the year), YYYY-MM (last day of the month), YYYY-MM-DD (specific day) (required)
     * @param detail Indicates whether a daily breakdown will be included in the result set (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call usageDataTrafficGetCall(String start, String end, Boolean detail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/usage/data-traffic";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("start", start));
        if (end != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("end", end));
        if (detail != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("detail", detail));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "ApiKey" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call usageDataTrafficGetValidateBeforeCall(String start, String end, Boolean detail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'start' is set
        if (start == null) {
            throw new ApiException("Missing the required parameter 'start' when calling usageDataTrafficGet(Async)");
        }
        
        // verify the required parameter 'end' is set
        if (end == null) {
            throw new ApiException("Missing the required parameter 'end' when calling usageDataTrafficGet(Async)");
        }
        

        com.squareup.okhttp.Call call = usageDataTrafficGetCall(start, end, detail, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Retrieve the amount of data used
     * Retrieve the amount of data used
     * @param start Start date in one of the following formats: YYYY (first day of the year), YYYY-MM (first day of the month), YYYY-MM-DD (specific day) (required)
     * @param end End date in one of the following formats: YYYY (last day of the year), YYYY-MM (last day of the month), YYYY-MM-DD (specific day) (required)
     * @param detail Indicates whether a daily breakdown will be included in the result set (optional)
     * @return DataTraffic
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DataTraffic usageDataTrafficGet(String start, String end, Boolean detail) throws ApiException {
        ApiResponse<DataTraffic> resp = usageDataTrafficGetWithHttpInfo(start, end, detail);
        return resp.getData();
    }

    /**
     * Retrieve the amount of data used
     * Retrieve the amount of data used
     * @param start Start date in one of the following formats: YYYY (first day of the year), YYYY-MM (first day of the month), YYYY-MM-DD (specific day) (required)
     * @param end End date in one of the following formats: YYYY (last day of the year), YYYY-MM (last day of the month), YYYY-MM-DD (specific day) (required)
     * @param detail Indicates whether a daily breakdown will be included in the result set (optional)
     * @return ApiResponse&lt;DataTraffic&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DataTraffic> usageDataTrafficGetWithHttpInfo(String start, String end, Boolean detail) throws ApiException {
        com.squareup.okhttp.Call call = usageDataTrafficGetValidateBeforeCall(start, end, detail, null, null);
        Type localVarReturnType = new TypeToken<DataTraffic>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve the amount of data used (asynchronously)
     * Retrieve the amount of data used
     * @param start Start date in one of the following formats: YYYY (first day of the year), YYYY-MM (first day of the month), YYYY-MM-DD (specific day) (required)
     * @param end End date in one of the following formats: YYYY (last day of the year), YYYY-MM (last day of the month), YYYY-MM-DD (specific day) (required)
     * @param detail Indicates whether a daily breakdown will be included in the result set (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call usageDataTrafficGetAsync(String start, String end, Boolean detail, final ApiCallback<DataTraffic> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = usageDataTrafficGetValidateBeforeCall(start, end, detail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DataTraffic>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
