/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ibm.wiotp.sdk.swagger.model.DeviceInfo;
import com.ibm.wiotp.sdk.swagger.model.UpdateableDeviceLocation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * DeviceAdditionRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class DeviceAdditionRequest {
  @SerializedName("deviceId")
  private String deviceId = null;

  @SerializedName("authToken")
  private String authToken = null;

  @SerializedName("deviceInfo")
  private DeviceInfo deviceInfo = null;

  @SerializedName("location")
  private UpdateableDeviceLocation location = null;

  @SerializedName("metadata")
  private Object metadata = null;

  public DeviceAdditionRequest deviceId(String deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * Get deviceId
   * @return deviceId
  **/
  @ApiModelProperty(required = true, value = "")
  public String getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  public DeviceAdditionRequest authToken(String authToken) {
    this.authToken = authToken;
    return this;
  }

   /**
   * Authentication token, will be generated if not supplied
   * @return authToken
  **/
  @ApiModelProperty(value = "Authentication token, will be generated if not supplied")
  public String getAuthToken() {
    return authToken;
  }

  public void setAuthToken(String authToken) {
    this.authToken = authToken;
  }

  public DeviceAdditionRequest deviceInfo(DeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * Get deviceInfo
   * @return deviceInfo
  **/
  @ApiModelProperty(value = "")
  public DeviceInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(DeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }

  public DeviceAdditionRequest location(UpdateableDeviceLocation location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(value = "")
  public UpdateableDeviceLocation getLocation() {
    return location;
  }

  public void setLocation(UpdateableDeviceLocation location) {
    this.location = location;
  }

  public DeviceAdditionRequest metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Metadata of the device
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata of the device")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceAdditionRequest deviceAdditionRequest = (DeviceAdditionRequest) o;
    return Objects.equals(this.deviceId, deviceAdditionRequest.deviceId) &&
        Objects.equals(this.authToken, deviceAdditionRequest.authToken) &&
        Objects.equals(this.deviceInfo, deviceAdditionRequest.deviceInfo) &&
        Objects.equals(this.location, deviceAdditionRequest.location) &&
        Objects.equals(this.metadata, deviceAdditionRequest.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, authToken, deviceInfo, location, metadata);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceAdditionRequest {\n");
    
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    authToken: ").append(toIndentedString(authToken)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

