/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import org.threeten.bp.OffsetDateTime;

/**
 * DeviceFirmware
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class DeviceFirmware {
  @SerializedName("version")
  private String version = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("url")
  private String url = null;

  @SerializedName("verifier")
  private String verifier = null;

  @SerializedName("state")
  private BigDecimal state = null;

  @SerializedName("updateStatus")
  private BigDecimal updateStatus = null;

  @SerializedName("updatedDateTime")
  private OffsetDateTime updatedDateTime = null;

  public DeviceFirmware version(String version) {
    this.version = version;
    return this;
  }

   /**
   * The version of the firmware
   * @return version
  **/
  @ApiModelProperty(value = "The version of the firmware")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public DeviceFirmware name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the firmware to be used on the device
   * @return name
  **/
  @ApiModelProperty(value = "The name of the firmware to be used on the device")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DeviceFirmware url(String url) {
    this.url = url;
    return this;
  }

   /**
   * The URL from which the firmware image can be downloaded
   * @return url
  **/
  @ApiModelProperty(value = "The URL from which the firmware image can be downloaded")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public DeviceFirmware verifier(String verifier) {
    this.verifier = verifier;
    return this;
  }

   /**
   * The verifier such as a checksum for the firmware image to validate its integrity
   * @return verifier
  **/
  @ApiModelProperty(value = "The verifier such as a checksum for the firmware image to validate its integrity")
  public String getVerifier() {
    return verifier;
  }

  public void setVerifier(String verifier) {
    this.verifier = verifier;
  }

  public DeviceFirmware state(BigDecimal state) {
    this.state = state;
    return this;
  }

   /**
   * Indicates the state of the firmware image
   * @return state
  **/
  @ApiModelProperty(value = "Indicates the state of the firmware image")
  public BigDecimal getState() {
    return state;
  }

  public void setState(BigDecimal state) {
    this.state = state;
  }

  public DeviceFirmware updateStatus(BigDecimal updateStatus) {
    this.updateStatus = updateStatus;
    return this;
  }

   /**
   * Indicates the status of the update
   * @return updateStatus
  **/
  @ApiModelProperty(value = "Indicates the status of the update")
  public BigDecimal getUpdateStatus() {
    return updateStatus;
  }

  public void setUpdateStatus(BigDecimal updateStatus) {
    this.updateStatus = updateStatus;
  }

  public DeviceFirmware updatedDateTime(OffsetDateTime updatedDateTime) {
    this.updatedDateTime = updatedDateTime;
    return this;
  }

   /**
   * Date and time of initiating the last update (ISO8601)
   * @return updatedDateTime
  **/
  @ApiModelProperty(value = "Date and time of initiating the last update (ISO8601)")
  public OffsetDateTime getUpdatedDateTime() {
    return updatedDateTime;
  }

  public void setUpdatedDateTime(OffsetDateTime updatedDateTime) {
    this.updatedDateTime = updatedDateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceFirmware deviceFirmware = (DeviceFirmware) o;
    return Objects.equals(this.version, deviceFirmware.version) &&
        Objects.equals(this.name, deviceFirmware.name) &&
        Objects.equals(this.url, deviceFirmware.url) &&
        Objects.equals(this.verifier, deviceFirmware.verifier) &&
        Objects.equals(this.state, deviceFirmware.state) &&
        Objects.equals(this.updateStatus, deviceFirmware.updateStatus) &&
        Objects.equals(this.updatedDateTime, deviceFirmware.updatedDateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, name, url, verifier, state, updateStatus, updatedDateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceFirmware {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    verifier: ").append(toIndentedString(verifier)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    updateStatus: ").append(toIndentedString(updateStatus)).append("\n");
    sb.append("    updatedDateTime: ").append(toIndentedString(updatedDateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

