/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * DeviceInfo
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class DeviceInfo {
  @SerializedName("serialNumber")
  private String serialNumber = null;

  @SerializedName("manufacturer")
  private String manufacturer = null;

  @SerializedName("model")
  private String model = null;

  @SerializedName("deviceClass")
  private String deviceClass = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("fwVersion")
  private String fwVersion = null;

  @SerializedName("hwVersion")
  private String hwVersion = null;

  @SerializedName("descriptiveLocation")
  private String descriptiveLocation = null;

  public DeviceInfo serialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

   /**
   * The serial number of the device
   * @return serialNumber
  **/
  @ApiModelProperty(value = "The serial number of the device")
  public String getSerialNumber() {
    return serialNumber;
  }

  public void setSerialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
  }

  public DeviceInfo manufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
    return this;
  }

   /**
   * The manufacturer of the device
   * @return manufacturer
  **/
  @ApiModelProperty(value = "The manufacturer of the device")
  public String getManufacturer() {
    return manufacturer;
  }

  public void setManufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
  }

  public DeviceInfo model(String model) {
    this.model = model;
    return this;
  }

   /**
   * The model of the device
   * @return model
  **/
  @ApiModelProperty(value = "The model of the device")
  public String getModel() {
    return model;
  }

  public void setModel(String model) {
    this.model = model;
  }

  public DeviceInfo deviceClass(String deviceClass) {
    this.deviceClass = deviceClass;
    return this;
  }

   /**
   * The class of the device
   * @return deviceClass
  **/
  @ApiModelProperty(value = "The class of the device")
  public String getDeviceClass() {
    return deviceClass;
  }

  public void setDeviceClass(String deviceClass) {
    this.deviceClass = deviceClass;
  }

  public DeviceInfo description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The descriptive name of the device
   * @return description
  **/
  @ApiModelProperty(value = "The descriptive name of the device")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public DeviceInfo fwVersion(String fwVersion) {
    this.fwVersion = fwVersion;
    return this;
  }

   /**
   * The firmware version currently known to be on the device
   * @return fwVersion
  **/
  @ApiModelProperty(value = "The firmware version currently known to be on the device")
  public String getFwVersion() {
    return fwVersion;
  }

  public void setFwVersion(String fwVersion) {
    this.fwVersion = fwVersion;
  }

  public DeviceInfo hwVersion(String hwVersion) {
    this.hwVersion = hwVersion;
    return this;
  }

   /**
   * The hardware version of the device
   * @return hwVersion
  **/
  @ApiModelProperty(value = "The hardware version of the device")
  public String getHwVersion() {
    return hwVersion;
  }

  public void setHwVersion(String hwVersion) {
    this.hwVersion = hwVersion;
  }

  public DeviceInfo descriptiveLocation(String descriptiveLocation) {
    this.descriptiveLocation = descriptiveLocation;
    return this;
  }

   /**
   * A descriptive location, such as a room or building number, or a geographical region
   * @return descriptiveLocation
  **/
  @ApiModelProperty(value = "A descriptive location, such as a room or building number, or a geographical region")
  public String getDescriptiveLocation() {
    return descriptiveLocation;
  }

  public void setDescriptiveLocation(String descriptiveLocation) {
    this.descriptiveLocation = descriptiveLocation;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceInfo deviceInfo = (DeviceInfo) o;
    return Objects.equals(this.serialNumber, deviceInfo.serialNumber) &&
        Objects.equals(this.manufacturer, deviceInfo.manufacturer) &&
        Objects.equals(this.model, deviceInfo.model) &&
        Objects.equals(this.deviceClass, deviceInfo.deviceClass) &&
        Objects.equals(this.description, deviceInfo.description) &&
        Objects.equals(this.fwVersion, deviceInfo.fwVersion) &&
        Objects.equals(this.hwVersion, deviceInfo.hwVersion) &&
        Objects.equals(this.descriptiveLocation, deviceInfo.descriptiveLocation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNumber, manufacturer, model, deviceClass, description, fwVersion, hwVersion, descriptiveLocation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceInfo {\n");
    
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("    manufacturer: ").append(toIndentedString(manufacturer)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    deviceClass: ").append(toIndentedString(deviceClass)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    fwVersion: ").append(toIndentedString(fwVersion)).append("\n");
    sb.append("    hwVersion: ").append(toIndentedString(hwVersion)).append("\n");
    sb.append("    descriptiveLocation: ").append(toIndentedString(descriptiveLocation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

