/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ibm.wiotp.sdk.swagger.model.DeviceConcise;
import com.ibm.wiotp.sdk.swagger.model.SearchResultMetaInformation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * DeviceListResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class DeviceListResponse {
  @SerializedName("bookmark")
  private String bookmark = null;

  @SerializedName("meta")
  private SearchResultMetaInformation meta = null;

  @SerializedName("results")
  private List<DeviceConcise> results = new ArrayList<DeviceConcise>();

  public DeviceListResponse bookmark(String bookmark) {
    this.bookmark = bookmark;
    return this;
  }

   /**
   * Used to iterate through result set. To request the next page, repeat the request specifying this as the value of the &#39;_bookmark&#39; parameter.
   * @return bookmark
  **/
  @ApiModelProperty(required = true, value = "Used to iterate through result set. To request the next page, repeat the request specifying this as the value of the '_bookmark' parameter.")
  public String getBookmark() {
    return bookmark;
  }

  public void setBookmark(String bookmark) {
    this.bookmark = bookmark;
  }

  public DeviceListResponse meta(SearchResultMetaInformation meta) {
    this.meta = meta;
    return this;
  }

   /**
   * Get meta
   * @return meta
  **/
  @ApiModelProperty(required = true, value = "")
  public SearchResultMetaInformation getMeta() {
    return meta;
  }

  public void setMeta(SearchResultMetaInformation meta) {
    this.meta = meta;
  }

  public DeviceListResponse results(List<DeviceConcise> results) {
    this.results = results;
    return this;
  }

  public DeviceListResponse addResultsItem(DeviceConcise resultsItem) {
    this.results.add(resultsItem);
    return this;
  }

   /**
   * Get results
   * @return results
  **/
  @ApiModelProperty(required = true, value = "")
  public List<DeviceConcise> getResults() {
    return results;
  }

  public void setResults(List<DeviceConcise> results) {
    this.results = results;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceListResponse deviceListResponse = (DeviceListResponse) o;
    return Objects.equals(this.bookmark, deviceListResponse.bookmark) &&
        Objects.equals(this.meta, deviceListResponse.meta) &&
        Objects.equals(this.results, deviceListResponse.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookmark, meta, results);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceListResponse {\n");
    
    sb.append("    bookmark: ").append(toIndentedString(bookmark)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

