/*
 * IBM Watson IoT Platform Organization Administration REST APIs
 * The Organization Adminstration APIs can be used to configure an organization (including  creating and deleting devices), checking usage, service status and diagnosing device  connection problems. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html). 
 *
 * OpenAPI spec version: 0002
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ibm.wiotp.sdk.swagger.model.DeviceFirmware;
import com.ibm.wiotp.sdk.swagger.model.DeviceMgmtSupports;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;

/**
 * DeviceMgmt
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:06:21.121+01:00")
public class DeviceMgmt {
  @SerializedName("lastActivityDateTime")
  private OffsetDateTime lastActivityDateTime = null;

  @SerializedName("dormantDateTime")
  private OffsetDateTime dormantDateTime = null;

  @SerializedName("dormant")
  private Boolean dormant = null;

  @SerializedName("supports")
  private DeviceMgmtSupports supports = null;

  @SerializedName("firmware")
  private DeviceFirmware firmware = null;

  public DeviceMgmt lastActivityDateTime(OffsetDateTime lastActivityDateTime) {
    this.lastActivityDateTime = lastActivityDateTime;
    return this;
  }

   /**
   * Date and time of last device management server activity, updated periodically (ISO8601)
   * @return lastActivityDateTime
  **/
  @ApiModelProperty(required = true, value = "Date and time of last device management server activity, updated periodically (ISO8601)")
  public OffsetDateTime getLastActivityDateTime() {
    return lastActivityDateTime;
  }

  public void setLastActivityDateTime(OffsetDateTime lastActivityDateTime) {
    this.lastActivityDateTime = lastActivityDateTime;
  }

  public DeviceMgmt dormantDateTime(OffsetDateTime dormantDateTime) {
    this.dormantDateTime = dormantDateTime;
    return this;
  }

   /**
   * Date and time at which the managed device will automatically be set dormant (ISO8601)
   * @return dormantDateTime
  **/
  @ApiModelProperty(value = "Date and time at which the managed device will automatically be set dormant (ISO8601)")
  public OffsetDateTime getDormantDateTime() {
    return dormantDateTime;
  }

  public void setDormantDateTime(OffsetDateTime dormantDateTime) {
    this.dormantDateTime = dormantDateTime;
  }

  public DeviceMgmt dormant(Boolean dormant) {
    this.dormant = dormant;
    return this;
  }

   /**
   * Whether the device has become dormant
   * @return dormant
  **/
  @ApiModelProperty(required = true, value = "Whether the device has become dormant")
  public Boolean isDormant() {
    return dormant;
  }

  public void setDormant(Boolean dormant) {
    this.dormant = dormant;
  }

  public DeviceMgmt supports(DeviceMgmtSupports supports) {
    this.supports = supports;
    return this;
  }

   /**
   * Get supports
   * @return supports
  **/
  @ApiModelProperty(required = true, value = "")
  public DeviceMgmtSupports getSupports() {
    return supports;
  }

  public void setSupports(DeviceMgmtSupports supports) {
    this.supports = supports;
  }

  public DeviceMgmt firmware(DeviceFirmware firmware) {
    this.firmware = firmware;
    return this;
  }

   /**
   * Get firmware
   * @return firmware
  **/
  @ApiModelProperty(value = "")
  public DeviceFirmware getFirmware() {
    return firmware;
  }

  public void setFirmware(DeviceFirmware firmware) {
    this.firmware = firmware;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceMgmt deviceMgmt = (DeviceMgmt) o;
    return Objects.equals(this.lastActivityDateTime, deviceMgmt.lastActivityDateTime) &&
        Objects.equals(this.dormantDateTime, deviceMgmt.dormantDateTime) &&
        Objects.equals(this.dormant, deviceMgmt.dormant) &&
        Objects.equals(this.supports, deviceMgmt.supports) &&
        Objects.equals(this.firmware, deviceMgmt.firmware);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lastActivityDateTime, dormantDateTime, dormant, supports, firmware);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceMgmt {\n");
    
    sb.append("    lastActivityDateTime: ").append(toIndentedString(lastActivityDateTime)).append("\n");
    sb.append("    dormantDateTime: ").append(toIndentedString(dormantDateTime)).append("\n");
    sb.append("    dormant: ").append(toIndentedString(dormant)).append("\n");
    sb.append("    supports: ").append(toIndentedString(supports)).append("\n");
    sb.append("    firmware: ").append(toIndentedString(firmware)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

