/*
 * IBM Watson IoT Platform Organization Information Management REST APIs
 * The Information Management APIs can be used to access device event data as well as  get and update device location and obtain weather information for that location. For information on this API, and how to use Watson IoT Platform APIs generally see  [the API documentation](https://console.ng.bluemix.net/docs/services/IoT/reference/api.html).  version: \"0002\" 
 *
 * OpenAPI spec version: 1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.ibm.wiotp.sdk.swagger.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.UUID;

/**
 * Event
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-30T18:07:14.805+01:00")
public class Event {
  @SerializedName("deviceId")
  private String deviceId = null;

  @SerializedName("typeId")
  private String typeId = null;

  @SerializedName("eventId")
  private String eventId = null;

  @SerializedName("timestamp")
  private UUID timestamp = null;

  @SerializedName("payload")
  private byte[] payload = null;

  @SerializedName("format")
  private String format = null;

  public Event deviceId(String deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * Get deviceId
   * @return deviceId
  **/
  @ApiModelProperty(value = "")
  public String getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  public Event typeId(String typeId) {
    this.typeId = typeId;
    return this;
  }

   /**
   * Get typeId
   * @return typeId
  **/
  @ApiModelProperty(value = "")
  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public Event eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Event Id
   * @return eventId
  **/
  @ApiModelProperty(value = "Event Id")
  public String getEventId() {
    return eventId;
  }

  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  public Event timestamp(UUID timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * timestamp uuid
   * @return timestamp
  **/
  @ApiModelProperty(value = "timestamp uuid")
  public UUID getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(UUID timestamp) {
    this.timestamp = timestamp;
  }

  public Event payload(byte[] payload) {
    this.payload = payload;
    return this;
  }

   /**
   * Base64 encoded event payload
   * @return payload
  **/
  @ApiModelProperty(value = "Base64 encoded event payload")
  public byte[] getPayload() {
    return payload;
  }

  public void setPayload(byte[] payload) {
    this.payload = payload;
  }

  public Event format(String format) {
    this.format = format;
    return this;
  }

   /**
   * Describes the format of response, taken from the original event. For example \&quot;json\&quot;.
   * @return format
  **/
  @ApiModelProperty(value = "Describes the format of response, taken from the original event. For example \"json\".")
  public String getFormat() {
    return format;
  }

  public void setFormat(String format) {
    this.format = format;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.deviceId, event.deviceId) &&
        Objects.equals(this.typeId, event.typeId) &&
        Objects.equals(this.eventId, event.eventId) &&
        Objects.equals(this.timestamp, event.timestamp) &&
        Arrays.equals(this.payload, event.payload) &&
        Objects.equals(this.format, event.format);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, typeId, eventId, timestamp, Arrays.hashCode(payload), format);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

